/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.view.MessagePainter;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;

public class ShopPainter {
    private Graphics graphics;
    private MessagePainter messagePainter;
    private Image background;
    private Image muleImage;
    private Image muleHighlightImage;
    private Image assayBot;
    private int rows = 7;
    private int columns = 2;
    private Vector2f distance = new Vector2f(36.0f, 8.0f);
    private Color messageBackColor = new Color(0, 0, 0);
    private Color muleHighlight = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private View.TextStyle priceStyle = View.TextStyle.DISPLAY;

    public ShopPainter(Graphics graphics, MessagePainter messagePainter) throws SlickException {
        this.graphics = graphics;
        this.messagePainter = messagePainter;
        this.background = new MuleImage("images/shop.png");
        SpriteSheet spriteSheet = new SpriteSheet("images/store-mule.png", 32, 40, new Color(255, 0, 255));
        this.muleImage = spriteSheet.getSubImage(0, 0);
        this.muleHighlightImage = spriteSheet.getSubImage(1, 0);
        this.assayBot = new MuleImage("images/shop_assay_bot.png");
    }

    public void draw(Shop shop, boolean bl) {
        ViewProperties viewProperties = ViewProperties.get();
        int n = viewProperties.shopOffsetX;
        int n2 = viewProperties.shopOffsetY;
        this.graphics.setColor(Color.black);
        viewProperties.getClass();
        viewProperties.getClass();
        viewProperties.getClass();
        viewProperties.getClass();
        this.graphics.fillRect(10.0f, 10.0f, 620.0f, 360.0f);
        this.background.draw(n, n2);
        this.drawMules(shop, 355.0f, 221.0f);
        if (bl) {
            this.assayBot.draw(n + 69, n2 + 263);
        }
        this.priceStyle.print("" + Properties.mule.crystiteEquipmentCost, n + 54, n2 + 15);
        this.priceStyle.print("" + Properties.mule.smithoreEquipmentCost, n + 155, n2 + 15);
        this.priceStyle.print("" + Properties.mule.energyEquipmentCost, n + 291, n2 + 15);
        this.priceStyle.print("" + Properties.mule.foodEquipmentCost, n + 391, n2 + 15);
        this.priceStyle.print("" + shop.getMuleCost(), n + 381, n2 + 325);
    }

    public void drawTerminalBackground() {
        float f;
        int n = this.messagePainter.getTerminalWidth();
        if (n > 0 && (f = this.messagePainter.getTerminalColor().a) > 0.0f) {
            this.messageBackColor.a = f;
            int n2 = MessagePainter.TERMINAL_POS.x;
            int n3 = MessagePainter.TERMINAL_POS.y;
            this.graphics.setColor(this.messageBackColor);
            this.graphics.fillRect(n2 - (n += 10) / 2, n3 - 2, n, 18.0f);
        }
    }

    public void drawTitleBackground() {
        int n = this.messagePainter.getTitleWidth();
        if (n > 0) {
            int n2 = MessagePainter.TITLE_POS.x;
            int n3 = MessagePainter.TITLE_POS.y;
            this.graphics.setColor(Color.black);
            this.graphics.fillRect(n2 - (n += 10) / 2, n3 - 2, n, 18.0f);
        }
    }

    public void drawMules(Shop shop, float f, float f2) {
        ViewProperties.get().getClass();
        f += 100.0f;
        ViewProperties.get().getClass();
        f2 += 16.0f;
        if (this.muleHighlight.a > 0.0f) {
            this.muleHighlight.a -= 1.5f * Properties.mule.delta;
            if (this.muleHighlight.a < 0.0f) {
                this.muleHighlight.a = 0.0f;
            }
        }
        int n = shop.numMules();
        boolean bl = false;
        for (int i = 0; i < this.columns; ++i) {
            float f3 = f;
            float f4 = f2;
            if ((i + 1) * this.rows > n) {
                f4 += (float)((i + 1) * this.rows - n) * this.distance.y;
            }
            f3 += (float)i * this.distance.x;
            for (int j = 0; j < this.rows; ++j) {
                if (i * this.rows + j >= n) {
                    bl = true;
                    break;
                }
                this.muleImage.draw(f3, f4);
                if (this.muleHighlight.a > 0.0f) {
                    this.muleHighlightImage.draw(f3, f4, this.muleHighlight);
                }
                f4 += this.distance.y;
            }
            if (bl) break;
        }
    }

    public void enterMuleStore() {
        this.muleHighlight.a = 1.0f;
    }
}

