/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.User;
import com.turborilla.mule.view.View;
import java.util.ArrayList;
import java.util.Collection;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconnectPainter {
    private Graphics graphics;
    private Color background;
    private View.TextStyle titleStyle;
    private View.TextStyle textStyle;
    private int xPos = 110;
    private int yPos = 72;

    public ReconnectPainter(Graphics graphics) {
        this.graphics = graphics;
        this.background = new Color(0.0f, 0.0f, 0.0f, 0.6f);
        this.titleStyle = View.TextStyle.BIG;
        this.textStyle = View.TextStyle.DEBUG;
    }

    public void draw(Collection<User> collection, ArrayList<Integer> arrayList) {
        this.graphics.setColor(this.background);
        this.graphics.fillRect(this.xPos, this.yPos, 419.0f, 236.0f);
        this.titleStyle.printCentered("Reconnect", Color.white, 320, this.yPos + 20);
        int n = 0;
        for (User user : collection) {
            int n2 = this.yPos + 60 + 20 * n;
            Color color = user.getColor();
            boolean bl = arrayList.contains(user.getUserNumber());
            this.textStyle.print(user.getName(), color, this.xPos + 30, n2);
            if (bl) {
                this.textStyle.print("Ready", color, this.xPos + 330, n2);
            }
            ++n;
        }
    }

    public void drawStatusTimer(String string, float f) {
        this.drawStatus(string + (1 + (int)(f - 1.0E-4f)));
    }

    public void drawStatus(String string) {
        this.textStyle.printCentered(string, 320, this.yPos + 200);
    }
}

