/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.ImageBuffer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.ImageDataFactory;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.util.ResourceLoader;

public class PaletteImage {
    private String path;
    private LoadableImageData imageData;
    private ByteBuffer buffer;

    public PaletteImage(String string) throws SlickException {
        try {
            this.path = string;
            this.imageData = ImageDataFactory.getImageDataFor(string);
            this.buffer = this.imageData.loadImage(ResourceLoader.getResourceAsStream(string), false, null);
        }
        catch (IOException iOException) {
            throw new SlickException(iOException.toString());
        }
    }

    public Image createImage(Color[] colorArray) throws SlickException, MuleException {
        return this.createImage(colorArray, Color.magenta);
    }

    public Image createImage(Color[] colorArray, Color color) throws SlickException, MuleException {
        this.buffer.rewind();
        int n = this.imageData.getWidth();
        int n2 = this.imageData.getHeight();
        boolean bl = this.imageData.getDepth() == 32;
        int n3 = InternalTextureLoader.get2Fold(n);
        int n4 = bl ? 4 : 3;
        ImageBuffer imageBuffer = new ImageBuffer(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.buffer.position(i * n3 * n4);
            for (int j = 0; j < n; ++j) {
                int n5;
                int n6 = 0xFF & this.buffer.get();
                int n7 = 0xFF & this.buffer.get();
                int n8 = 0xFF & this.buffer.get();
                int n9 = n5 = bl ? 0xFF & this.buffer.get() : 255;
                if (n5 > 0) {
                    if (color != null && color.getRed() == n6 && color.getGreen() == n7 && color.getBlue() == n8) {
                        n5 = 0;
                    } else {
                        for (int k = 0; k < colorArray.length; k += 2) {
                            Color color2 = colorArray[k];
                            if (color2.getRed() != n6 || color2.getGreen() != n7 || color2.getBlue() != n8) continue;
                            Color color3 = colorArray[k + 1];
                            n6 = color3.getRed();
                            n7 = color3.getGreen();
                            n8 = color3.getBlue();
                            break;
                        }
                    }
                }
                imageBuffer.setRGBA(j, i, n6, n7, n8, n5);
            }
        }
        Image image = imageBuffer.getImage(2);
        if (image == null || image.getTexture() == null) {
            throw new MuleException("Couldn't create palette image\n" + this.path + "\n(" + imageBuffer.getTexWidth() + "x" + imageBuffer.getTexHeight() + ")");
        }
        return image;
    }

    public int getWidth() {
        return this.imageData.getWidth();
    }

    public int getHeight() {
        return this.imageData.getHeight();
    }
}

