/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import java.util.ArrayList;
import org.lwjgl.Sys;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.util.Log;

public class MuleAnimation
implements Renderable {
    private ArrayList frames = new ArrayList();
    private int currentFrame = -1;
    private long nextChange = 0L;
    private boolean stopped = false;
    private long timeLeft;
    private float speed = 1.0f;
    private int stopAt = -2;
    private long lastUpdate;
    private boolean firstUpdate = true;
    private boolean autoUpdate = true;
    private int direction = 1;
    private boolean pingPong;
    private boolean loop = true;

    public MuleAnimation(SpriteSheet spriteSheet, int[] nArray, int n, boolean bl) {
        for (int n2 : nArray) {
            this.addFrame(spriteSheet.getSprite(n2, 0), n2, n);
        }
        this.autoUpdate = bl;
    }

    protected void setSpriteSheet(SpriteSheet spriteSheet, int n) {
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.get(i);
            frame.duration = n;
            frame.image = spriteSheet.getSprite(frame.spriteSheetIndex, 0);
        }
    }

    public void setAutoUpdate(boolean bl) {
        this.autoUpdate = bl;
    }

    public void setPingPong(boolean bl) {
        this.pingPong = bl;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setSpeed(float f) {
        if (f > 0.0f) {
            this.nextChange = (long)((float)this.nextChange * this.speed / f);
            this.speed = f;
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void stop() {
        if (this.frames.size() == 0) {
            return;
        }
        this.timeLeft = this.nextChange;
        this.stopped = true;
    }

    public void start() {
        if (!this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.stopped = false;
        this.nextChange = this.timeLeft;
    }

    public void restart() {
        if (!this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.stopped = false;
        this.currentFrame = 0;
        this.nextChange = (int)((float)((Frame)this.frames.get((int)0)).duration / this.speed);
    }

    public void addFrame(Image image, int n, int n2) {
        if (n2 == 0) {
            Log.error("Invalid duration: " + n2);
            throw new RuntimeException("Invalid duration: " + n2);
        }
        if (this.frames.isEmpty()) {
            this.nextChange = (int)((float)n2 / this.speed);
        }
        this.frames.add(new Frame(image, n, n2));
        this.currentFrame = 0;
    }

    public void draw() {
        this.draw(0.0f, 0.0f);
    }

    public void draw(float f, float f2) {
        this.draw(f, f2, this.getWidth(), this.getHeight());
    }

    public void draw(float f, float f2, Color color) {
        this.draw(f, f2, this.getWidth(), this.getHeight(), color);
    }

    public void draw(float f, float f2, float f3, float f4) {
        this.draw(f, f2, f3, f4, Color.white);
    }

    public void draw(float f, float f2, float f3, float f4, Color color) {
        if (this.frames.size() == 0) {
            return;
        }
        if (this.autoUpdate) {
            long l = this.getTime();
            long l2 = l - this.lastUpdate;
            if (this.firstUpdate) {
                l2 = 0L;
                this.firstUpdate = false;
            }
            this.lastUpdate = l;
            this.nextFrame(l2);
        }
        Frame frame = (Frame)this.frames.get(this.currentFrame);
        frame.image.draw(f, f2, f3, f4, color);
    }

    public int getWidth() {
        return ((Frame)this.frames.get((int)this.currentFrame)).image.getWidth();
    }

    public int getHeight() {
        return ((Frame)this.frames.get((int)this.currentFrame)).image.getHeight();
    }

    public void drawFlash(float f, float f2, float f3, float f4) {
        this.drawFlash(f, f2, f3, f4, Color.white);
    }

    public void drawFlash(float f, float f2, float f3, float f4, Color color) {
        if (this.frames.size() == 0) {
            return;
        }
        if (this.autoUpdate) {
            long l = this.getTime();
            long l2 = l - this.lastUpdate;
            if (this.firstUpdate) {
                l2 = 0L;
                this.firstUpdate = false;
            }
            this.lastUpdate = l;
            this.nextFrame(l2);
        }
        Frame frame = (Frame)this.frames.get(this.currentFrame);
        frame.image.drawFlash(f, f2, f3, f4, color);
    }

    public void updateNoDraw() {
        if (this.autoUpdate) {
            long l = this.getTime();
            long l2 = l - this.lastUpdate;
            if (this.firstUpdate) {
                l2 = 0L;
                this.firstUpdate = false;
            }
            this.lastUpdate = l;
            this.nextFrame(l2);
        }
    }

    public void update(long l) {
        this.nextFrame(l);
    }

    public int getFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int n) {
        this.currentFrame = n;
    }

    public Image getImage(int n) {
        Frame frame = (Frame)this.frames.get(n);
        return frame.image;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Image getCurrentFrame() {
        Frame frame = (Frame)this.frames.get(this.currentFrame);
        return frame.image;
    }

    private void nextFrame(long l) {
        if (this.stopped) {
            return;
        }
        if (this.frames.size() == 0) {
            return;
        }
        this.nextChange -= l;
        while (this.nextChange < 0L && !this.stopped) {
            if (this.currentFrame == this.stopAt) {
                this.stopped = true;
                break;
            }
            if (this.currentFrame == this.frames.size() - 1 && !this.loop) break;
            this.currentFrame = (this.currentFrame + this.direction) % this.frames.size();
            if (this.pingPong && (this.currentFrame == 0 || this.currentFrame == this.frames.size() - 1)) {
                this.direction = -this.direction;
            }
            int n = (int)((float)((Frame)this.frames.get((int)this.currentFrame)).duration / this.speed);
            this.nextChange += (long)n;
        }
    }

    public void setLooping(boolean bl) {
        this.loop = bl;
    }

    private long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void stopAt(int n) {
        this.stopAt = n;
    }

    public int getDuration(int n) {
        return ((Frame)this.frames.get((int)n)).duration;
    }

    public void setDuration(int n, int n2) {
        ((Frame)this.frames.get((int)n)).duration = n2;
    }

    public int[] getDurations() {
        int[] nArray = new int[this.frames.size()];
        for (int i = 0; i < this.frames.size(); ++i) {
            nArray[i] = this.getDuration(i);
        }
        return nArray;
    }

    public String toString() {
        String string = "[Animation (" + this.frames.size() + ") ";
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.get(i);
            string = string + frame.duration + ",";
        }
        string = string + "]";
        return string;
    }

    private class Frame {
        public Image image;
        private int spriteSheetIndex;
        public int duration;

        public Frame(Image image, int n, int n2) {
            this.image = image;
            this.spriteSheetIndex = n;
            this.duration = n2;
        }
    }
}

