/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.MuleFileNotFoundException;
import com.turborilla.mule.Properties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Scanner;
import java.util.logging.Logger;
import org.newdawn.slick.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSkinParser {
    private static Logger logger = Logger.getLogger("mule");
    private HashMap<String, Element> elements = new HashMap();
    private static final String skinPath = "skins" + File.separator;

    public MapSkinParser(String string) throws MuleException, MuleFileNotFoundException {
        this.readElements(string, true);
        if (!string.equals(Properties.mule.defaultMapSkin)) {
            this.readElements(Properties.mule.defaultMapSkin, false);
        }
    }

    public static ArrayList<String> findSkins() {
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(skinPath);
        if (!file.exists()) {
            file = new File("resources" + File.separator + skinPath);
        }
        if ((fileArray = file.listFiles()) == null) {
            fileArray = new File[]{};
        }
        if (fileArray.length == 0) {
            logger.info("No extra skins found");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            arrayList.add(file2.getName());
            logger.info("Found skin \"" + file2.getName() + "\"");
        }
        if (!arrayList.contains(Properties.mule.defaultMapSkin)) {
            arrayList.add(Properties.mule.defaultMapSkin);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean hasElement(String string) throws MuleException {
        return this.elements.containsKey(string);
    }

    public Element getElement(String string) throws MuleException {
        Element element = this.elements.get(string);
        if (element == null) {
            throw new MuleException("Missing skin element $" + string);
        }
        return element;
    }

    private void readElements(String string, boolean bl) throws MuleException, MuleFileNotFoundException {
        InputStream inputStream;
        String string2 = skinPath + string + File.separator + "skin.txt";
        try {
            inputStream = ResourceLoader.getResourceAsStream(string2);
        }
        catch (RuntimeException runtimeException) {
            throw new MuleFileNotFoundException("Couldn't find skin \"" + string2 + "\"");
        }
        Scanner scanner = new Scanner(new BufferedInputStream(inputStream));
        Element element = null;
        while (scanner.hasNext()) {
            String string3;
            String string4 = scanner.next();
            if (string4.startsWith("//")) {
                if (!scanner.hasNextLine()) continue;
                string3 = scanner.nextLine();
                continue;
            }
            if (string4.startsWith("$")) {
                string3 = string4.substring(1).toLowerCase();
                if (this.elements.containsKey(string3)) {
                    if (bl) {
                        logger.warning(string2 + " contains duplicate element " + element);
                        element = new Element(string3, string);
                        this.elements.put(string3, element);
                        continue;
                    }
                    element = null;
                    continue;
                }
                element = new Element(string3, string);
                this.elements.put(string3, element);
                continue;
            }
            if (element == null) {
                if (!bl) continue;
                throw new MuleException(string2 + " contains field " + string4 + " without element. Did you forget the $-sign?");
            }
            element.addField(string4);
        }
    }

    public static class Element {
        private final String name;
        private final String skinName;
        private ArrayList<String> fields;

        public Element(String string, String string2) {
            this.name = string;
            this.skinName = string2;
            this.fields = new ArrayList();
        }

        public void addField(String string) {
            this.fields.add(string);
        }

        public String getPathname(int n) throws MuleException {
            try {
                return skinPath + this.skinName + File.separator + this.fields.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new MuleException("Map skin element " + this.name + " is missing field " + n);
            }
        }

        public int getInt(int n) throws MuleException {
            try {
                return Integer.parseInt(this.fields.get(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new MuleException("Map skin element " + this.name + " is missing field " + n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MuleException("Map skin element " + this.name + " has no integer in field " + n);
            }
        }

        public void print() {
            for (String string : this.fields) {
                System.err.print(" " + string);
            }
        }

        public int numFields() {
            return this.fields.size();
        }
    }
}

