/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2i;
import com.turborilla.mule.view.MapSkinParser;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.PaletteImage;
import com.turborilla.mule.view.ViewProperties;
import java.util.HashMap;
import java.util.logging.Logger;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class MapSkin {
    private static Logger logger = Logger.getLogger("mule");
    private HashMap<String, Image> images = new HashMap();
    private HashMap<String, Integer> tileVariations = new HashMap();
    private HashMap<String, CollisionBox> tileCollisions = new HashMap();
    private Vec2i factoryPos;
    private Vec2i factoryHighlightPos;
    private Vec2i factoryLowEnergyPos;
    private Vec2i[] productionBitPos;
    private Vec2i productionNonePos;
    private Vec2i crystiteAmountPos;
    private Vec2i landGrantOffset;
    private Decals mountains;
    private Decals water;
    private Decals smallWater;
    private Decals dirt;

    public MapSkin(MapSkinParser mapSkinParser) throws MuleException, SlickException {
        int n;
        String string;
        int n2;
        Object object;
        PlanetTile.PlanetTileType[] planetTileTypeArray = new PlanetTile.PlanetTileType[]{PlanetTile.PlanetTileType.Plain, PlanetTile.PlanetTileType.Desert, PlanetTile.PlanetTileType.Shop, PlanetTile.PlanetTileType.River, PlanetTile.PlanetTileType.Crater};
        for (PlanetTile.PlanetTileType planetTileType : planetTileTypeArray) {
            String string2 = planetTileType.identifier;
            String string3 = mapSkinParser.getElement(string2).getPathname(0);
            object = new SpriteSheet(string3, 64, 64);
            int n3 = ((SpriteSheet)object).getHorizontalCount();
            for (int i = 0; i < n3; ++i) {
                this.images.put(string2 + i, ((SpriteSheet)object).getSprite(i, 0));
            }
            this.tileVariations.put(string2, n3);
            this.loadCollision(mapSkinParser, string2);
        }
        this.mountains = new Decals(mapSkinParser, "decals-mountain", this);
        this.water = new Decals(mapSkinParser, "decals-water", this);
        this.smallWater = new Decals(mapSkinParser, "decals-small-water", this);
        this.dirt = new Decals(mapSkinParser, "decals-dirt", this);
        Object object2 = mapSkinParser.getElement("factory-pos");
        this.factoryPos = new Vec2i(((MapSkinParser.Element)object2).getInt(0), ((MapSkinParser.Element)object2).getInt(1));
        String string4 = mapSkinParser.getElement("factories").getPathname(0);
        PaletteImage paletteImage = new PaletteImage(string4);
        int n4 = paletteImage.getWidth() / 6;
        int n5 = paletteImage.getHeight() / Resource.values().length;
        for (n2 = 0; n2 < ViewProperties.get().avatarColors.length; ++n2) {
            object = ViewProperties.get().avatarColors[n2];
            Image image = paletteImage.createImage((Color[])object);
            SpriteSheet spriteSheet = new SpriteSheet(image, n4, n5);
            for (Resource object3 : Resource.values()) {
                for (int i = 0; i < spriteSheet.getHorizontalCount(); ++i) {
                    string = "factory-" + object3.getName() + i + "-color" + n2;
                    this.images.put(string, spriteSheet.getSprite(i, object3.ordinal()));
                }
            }
        }
        object2 = mapSkinParser.getElement("factory-highlight-pos");
        this.factoryHighlightPos = new Vec2i(((MapSkinParser.Element)object2).getInt(0), ((MapSkinParser.Element)object2).getInt(1));
        string4 = mapSkinParser.getElement("factory-highlights").getPathname(0);
        paletteImage = new PaletteImage(string4);
        n4 = paletteImage.getWidth() / Resource.values().length;
        n5 = paletteImage.getHeight();
        for (n2 = 0; n2 < ViewProperties.get().avatarColors.length; ++n2) {
            object = ViewProperties.get().avatarColors[n2];
            Image image = paletteImage.createImage((Color[])object);
            SpriteSheet spriteSheet = new SpriteSheet(image, n4, n5);
            for (Resource resource : Resource.values()) {
                String string2 = "factory-highlight-" + resource.getName() + "-color" + n2;
                this.images.put(string2, spriteSheet.getSprite(resource.ordinal(), 0));
            }
        }
        object2 = mapSkinParser.getElement("factory-low-energy-pos");
        this.factoryLowEnergyPos = new Vec2i(((MapSkinParser.Element)object2).getInt(0), ((MapSkinParser.Element)object2).getInt(1));
        string4 = mapSkinParser.getElement("factory-low-energy").getPathname(0);
        paletteImage = new PaletteImage(string4);
        n4 = paletteImage.getWidth() / Resource.values().length;
        n5 = paletteImage.getHeight() / 2;
        for (n2 = 0; n2 < ViewProperties.get().avatarColors.length; ++n2) {
            object = ViewProperties.get().avatarColors[n2];
            Image image = paletteImage.createImage((Color[])object);
            SpriteSheet spriteSheet = new SpriteSheet(image, n4, n5);
            for (Resource resource : Resource.values()) {
                for (int i = 0; i < 2; ++i) {
                    string = "factory-low-energy-" + resource.getName() + "-color" + n2 + "-power" + i;
                    this.images.put(string, spriteSheet.getSprite(resource.ordinal(), i));
                }
            }
        }
        object2 = mapSkinParser.getElement("production-bit-pos");
        this.productionBitPos = new Vec2i[8];
        for (int i = 0; i < this.productionBitPos.length; ++i) {
            this.productionBitPos[i] = new Vec2i(((MapSkinParser.Element)object2).getInt(2 * i + 0), ((MapSkinParser.Element)object2).getInt(2 * i + 1));
        }
        Object object4 = mapSkinParser.getElement("production-bit").getPathname(0);
        paletteImage = new PaletteImage((String)object4);
        for (n4 = 0; n4 < ViewProperties.get().avatarColors.length; ++n4) {
            Color[] colorArray = ViewProperties.get().avatarColors[n4];
            Image image = paletteImage.createImage(colorArray);
            object = "production-bit" + n4;
            this.images.put((String)object, image);
        }
        object2 = mapSkinParser.getElement("production-none-pos");
        this.productionNonePos = new Vec2i(((MapSkinParser.Element)object2).getInt(0), ((MapSkinParser.Element)object2).getInt(1));
        object4 = mapSkinParser.getElement("production-none").getPathname(0);
        paletteImage = new PaletteImage((String)object4);
        for (n4 = 0; n4 < ViewProperties.get().avatarColors.length; ++n4) {
            Color[] colorArray = ViewProperties.get().avatarColors[n4];
            Image image = paletteImage.createImage(colorArray);
            object = "production-none" + n4;
            this.images.put((String)object, image);
        }
        object2 = mapSkinParser.getElement("plot-border").getPathname(0);
        object4 = new PaletteImage((String)object2);
        for (n = 0; n < ViewProperties.get().avatarColors.length; ++n) {
            Color[] colorArray = ViewProperties.get().avatarColors[n];
            Image image = ((PaletteImage)object4).createImage(colorArray);
            String string6 = "plot-border" + n;
            this.images.put(string6, image);
        }
        object2 = new String[]{"border-corners", "border-left-right", "border-top-bottom"};
        object4 = new int[]{12, 2, 2};
        for (n = 0; n < ((Object)object2).length; ++n) {
            Object object5 = object2[n];
            Object object6 = object4[n];
            String string7 = mapSkinParser.getElement((String)object5).getPathname(0);
            object = new PaletteImage(string7);
            for (int i = 0; i < ViewProperties.get().avatarColors.length; ++i) {
                Color[] colorArray = ViewProperties.get().avatarColors[i];
                Image image = ((PaletteImage)object).createImage(colorArray);
                int n6 = image.getWidth() / object6;
                int n7 = image.getHeight();
                SpriteSheet spriteSheet = new SpriteSheet(image, n6, n7);
                for (int j = 0; j < object6; ++j) {
                    this.images.put((String)object5 + j + "-color" + i, spriteSheet.getSprite(j, 0));
                }
            }
        }
        object2 = mapSkinParser.getElement("crystite-amount-pos");
        this.crystiteAmountPos = new Vec2i(((MapSkinParser.Element)object2).getInt(0), ((MapSkinParser.Element)object2).getInt(1));
        int n8 = 5;
        String string8 = mapSkinParser.getElement("crystite-amounts").getPathname(0);
        Color[] colorArray = new MuleImage(string8);
        int n9 = colorArray.getWidth() / n8;
        int n10 = colorArray.getHeight();
        object = new SpriteSheet((Image)colorArray, n9, n10);
        for (int i = 0; i < n8; ++i) {
            this.images.put("crystite-amounts" + i, ((SpriteSheet)object).getSprite(i, 0));
        }
        object2 = mapSkinParser.getElement("claim-effect").getPathname(0);
        Object object7 = new PaletteImage((String)object2);
        for (int i = 0; i < ViewProperties.get().avatarColors.length; ++i) {
            colorArray = ViewProperties.get().avatarColors[i];
            Image image = ((PaletteImage)object7).createImage(colorArray);
            this.images.put("claim-effect" + i, image);
        }
        object2 = mapSkinParser.getElement("land-auction-frame").getPathname(0);
        object7 = new MuleImage((String)object2);
        this.images.put("land-auction-frame", (Image)object7);
        object2 = mapSkinParser.getElement("land-grant-frame").getPathname(0);
        object7 = new MuleImage((String)object2);
        this.images.put("land-grant-frame", (Image)object7);
        MapSkinParser.Element element = mapSkinParser.getElement("land-grant-frame-offset");
        this.landGrantOffset = new Vec2i(element.getInt(0), element.getInt(1));
    }

    public Image getImage(String string) {
        if (this.images.get(string) == null) {
            throw new RuntimeException("Missing image: " + string);
        }
        return this.images.get(string);
    }

    public Vec2i getProductionBitPos(int n) {
        return this.productionBitPos[n];
    }

    public Vec2i getProductionNonePos() {
        return this.productionNonePos;
    }

    public int getNumTiles(PlanetTile.PlanetTileType planetTileType) {
        return this.tileVariations.get(planetTileType.identifier);
    }

    public Decals getMountains() {
        return this.mountains;
    }

    public Decals getWater() {
        return this.water;
    }

    public Decals getSmallWater() {
        return this.smallWater;
    }

    public Decals getDirt() {
        return this.dirt;
    }

    public Vec2i getFactoryPos() {
        return this.factoryPos;
    }

    public Vec2i getFactoryHighlightPos() {
        return this.factoryHighlightPos;
    }

    public Vec2i getFactoryLowEnergyPos() {
        return this.factoryLowEnergyPos;
    }

    public Vec2i getCrystiteAmountPos() {
        return this.crystiteAmountPos;
    }

    public void destroy() throws SlickException {
        for (Image image : this.images.values()) {
            image.destroy();
        }
    }

    private int loadCollision(MapSkinParser mapSkinParser, String string) throws MuleException {
        String string2 = string + "-collision";
        if (!mapSkinParser.hasElement(string2)) {
            return 0;
        }
        MapSkinParser.Element element = mapSkinParser.getElement(string2);
        if (element.numFields() % 4 != 0) {
            throw new MuleException(string2 + " has an invalid number of fields");
        }
        int n = element.numFields() / 4;
        for (int i = 0; i < n; ++i) {
            CollisionBox collisionBox = new CollisionBox(element.getInt(0 + i * 4), element.getInt(1 + i * 4), element.getInt(2 + i * 4), element.getInt(3 + i * 4));
            this.tileCollisions.put(string + i, collisionBox);
        }
        return n;
    }

    public CollisionBox getCollisionBox(String string) {
        return this.tileCollisions.get(string);
    }

    public static class CollisionBox {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public CollisionBox(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static class Decals {
        private int num;
        private Vec2i size = new Vec2i();

        private Decals(MapSkinParser mapSkinParser, String string, MapSkin mapSkin) throws MuleException, SlickException {
            int n;
            MapSkinParser.Element element = mapSkinParser.getElement(string);
            String string2 = element.getPathname(0);
            this.size.set(element.getInt(1), element.getInt(2));
            SpriteSheet spriteSheet = new SpriteSheet(string2, this.size.x, this.size.y);
            this.num = spriteSheet.getHorizontalCount();
            for (n = 0; n < this.num; ++n) {
                mapSkin.images.put(string + n, spriteSheet.getSprite(n, 0));
            }
            n = mapSkin.loadCollision(mapSkinParser, string);
        }

        public int getNum() {
            return this.num;
        }

        public int getWidth() {
            return this.size.x;
        }

        public int getHeight() {
            return this.size.y;
        }
    }
}

