/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.map.Tile;
import com.turborilla.mule.model.util.Vec2i;
import com.turborilla.mule.view.Blinker;
import com.turborilla.mule.view.ClaimTileEffect;
import com.turborilla.mule.view.EffectPainter;
import com.turborilla.mule.view.MapBorderPainter;
import com.turborilla.mule.view.MapSkin;
import com.turborilla.mule.view.ViewProperties;
import java.util.Collection;
import java.util.Iterator;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter {
    private MapSkin skin;
    private Image[] crystiteAmounts;
    private Image landAuctionFrame;
    private Blinker blinker;
    private Player blinkingPlayer;
    private boolean otherTilesTransparent = false;
    private MapBorderPainter mapBorder;
    private final Color gridColor;
    private Graphics graphics;

    public MapPainter(Graphics graphics, Blinker blinker, MapBorderPainter mapBorderPainter) throws SlickException {
        this.gridColor = new Color(Properties.mule.gridColor[0], Properties.mule.gridColor[1], Properties.mule.gridColor[2]);
        this.graphics = graphics;
        this.blinker = blinker;
        this.mapBorder = mapBorderPainter;
    }

    void setSkin(MapSkin mapSkin) {
        this.skin = mapSkin;
        this.crystiteAmounts = new Image[5];
        for (int i = 0; i < this.crystiteAmounts.length; ++i) {
            this.crystiteAmounts[i] = mapSkin.getImage("crystite-amounts" + i);
        }
        this.landAuctionFrame = mapSkin.getImage("land-auction-frame");
    }

    public void setBlinkingPlayer(Player player) {
        this.blinkingPlayer = player;
    }

    public void setOtherPlayerTilesTransparent(boolean bl) {
        this.otherTilesTransparent = bl;
    }

    public void draw(PlanetMap planetMap, Collection<Player> collection, Player player) {
        this.draw(planetMap, collection, player, null, false);
    }

    public void draw(PlanetMap planetMap, Collection<Player> collection, Player player, Resource resource, boolean bl) {
        Object object;
        int n;
        int n2;
        PlanetTile planetTile;
        int n3;
        int n4;
        this.mapBorder.drawMapBorder(planetMap);
        for (n4 = 0; n4 < planetMap.getXSize(); ++n4) {
            for (n3 = 0; n3 < planetMap.getYSize(); ++n3) {
                planetTile = (PlanetTile)planetMap.getTile(n4, n3);
                n2 = n4 * 64 + ViewProperties.get().mapOffsetX;
                n = n3 * 64 + ViewProperties.get().mapOffsetY;
                boolean bl2 = planetTile.getFactory() != null && planetTile.getOwner() != player;
                this.drawTile(planetTile, n2, n, bl2);
                if (!planetTile.isAssayedBy(player)) continue;
                int n5 = planetTile.getCrystite();
                Image object2 = this.crystiteAmounts[n5];
                object = this.skin.getCrystiteAmountPos();
                object2.draw(n2 + ((Vec2i)object).x, n + ((Vec2i)object).y);
            }
        }
        for (n4 = 0; n4 < planetMap.getXSize(); ++n4) {
            for (n3 = 0; n3 < planetMap.getYSize(); ++n3) {
                planetTile = (PlanetTile)planetMap.getTile(n4, n3);
                n2 = n4 * 64 + ViewProperties.get().mapOffsetX;
                n = n3 * 64 + ViewProperties.get().mapOffsetY;
                Player player2 = planetTile.getOwner();
                if (player2 != null) {
                    Object object3 = null;
                    object3 = player2 == this.blinkingPlayer && this.blinker.isVisible() ? this.skin.getImage("plot-border0") : this.skin.getImage("plot-border" + player2.getColorIndex());
                    ((Image)object3).draw(n2, n);
                }
                for (Building building : planetTile.getBuildings()) {
                    boolean bl2;
                    if (!(building instanceof Factory)) continue;
                    object = (Factory)building;
                    int n5 = ((Factory)object).getPower() - ((Factory)object).getEnergyNeeded();
                    Image image = this.skin.getImage(((Factory)object).getIdentifier());
                    Vec2i vec2i = this.skin.getFactoryPos();
                    image.draw(n2 + vec2i.x, n + vec2i.y);
                    boolean bl3 = bl2 = ((Factory)object).getResource() == resource;
                    if (bl && n5 < 0) {
                        if (n5 == -((Factory)object).getEnergyNeeded()) {
                            image = this.skin.getImage(((Factory)object).getLowEnergyIdentifier() + "1");
                            bl2 = false;
                        } else {
                            image = this.skin.getImage(((Factory)object).getLowEnergyIdentifier() + "0");
                        }
                        vec2i = this.skin.getFactoryLowEnergyPos();
                        image.draw(n2 + vec2i.x, n + vec2i.y);
                    }
                    if (bl2) {
                        image = this.skin.getImage(((Factory)object).getHighlightIdentifier());
                        vec2i = this.skin.getFactoryHighlightPos();
                        image.draw(n2 + vec2i.x, n + vec2i.y);
                    }
                    if (!Properties.mule.showBonuses) continue;
                    this.graphics.setColor(Color.red);
                    this.graphics.drawString("" + ((Factory)object).getBonus(), n2 + 3, n);
                }
            }
        }
        if (Properties.mule.enableHomeBase) {
            this.graphics.setColor(Color.red);
            for (Player player3 : collection) {
                planetTile = player3.getHomeBase();
                if (planetTile == null) continue;
                n2 = planetTile.getPosX() * 64 + ViewProperties.get().mapOffsetX;
                n = planetTile.getPosY() * 64 + ViewProperties.get().mapOffsetY;
                this.graphics.drawString("HQ", n2 + 42, n + 48);
            }
        }
        if (Properties.mule.debugCollisionBoxes) {
            this.drawCollisions(planetMap);
        }
    }

    public void drawProduction(Collection<Player> collection) {
        for (Player player : collection) {
            int n = player.getColorIndex();
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                Image image;
                Factory factory = planetTile.getFactory();
                if (factory == null) continue;
                int n2 = planetTile.getPosX() * 64 + ViewProperties.get().mapOffsetX;
                int n3 = planetTile.getPosY() * 64 + ViewProperties.get().mapOffsetY;
                int n4 = factory.getProduction();
                if (n4 > 0) {
                    image = this.skin.getImage("production-bit" + n);
                    for (int i = 0; i < n4; ++i) {
                        Vec2i vec2i = this.skin.getProductionBitPos(i);
                        image.draw(n2 + vec2i.x, n3 + vec2i.y);
                    }
                    continue;
                }
                if (factory.getCapacity() != 0) continue;
                image = this.skin.getImage("production-none" + n);
                Vec2i vec2i = this.skin.getProductionNonePos();
                image.draw(n2 + vec2i.x, n3 + vec2i.y);
            }
        }
    }

    private void drawTile(Tile tile, int n, int n2, boolean bl) {
        Image image = this.skin.getImage(tile.getIdentifier());
        Color color = tile.getColor();
        image.draw(n + tile.getXOffset(), n2 + tile.getYOffset(), image.getWidth(), image.getHeight(), color);
        Iterator<Tile> iterator = tile.getTileBitIterator();
        while (iterator.hasNext()) {
            Tile tile2 = iterator.next();
            this.drawTile(tile2, n, n2, bl);
        }
    }

    public void tileClaimed(PlanetTile planetTile, EffectPainter effectPainter) {
        int n = planetTile.getOwner().getColorIndex();
        Image image = this.skin.getImage("claim-effect" + n);
        effectPainter.add(new ClaimTileEffect(planetTile, image));
    }

    public void tileSold(PlanetTile planetTile, EffectPainter effectPainter) {
        effectPainter.add(new ClaimTileEffect(planetTile, this.landAuctionFrame));
    }

    public void drawCollisions(PlanetMap planetMap) {
        this.graphics.setColor(Color.yellow);
        for (int i = 0; i < planetMap.getXSize(); ++i) {
            for (int j = 0; j < planetMap.getYSize(); ++j) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(i, j);
                for (Collidable collidable : planetTile.getCollisionSet().getCollidables()) {
                    float f = collidable.getPosition().x + (float)ViewProperties.get().mapOffsetX;
                    float f2 = collidable.getPosition().y + (float)ViewProperties.get().mapOffsetY;
                    Geometry.Rectangle rectangle = (Geometry.Rectangle)collidable.getGeometry();
                    this.graphics.drawRect(f - rectangle.getHalfWidth(), f2 - rectangle.getHalfHeight(), rectangle.getWidth(), rectangle.getHeight());
                }
            }
        }
    }

    public void drawSaleSign(PlanetTile planetTile) {
        if (planetTile == null) {
            return;
        }
        if (this.blinker.isVisible()) {
            int n = ViewProperties.get().mapOffsetX + planetTile.getPosX() * 64;
            int n2 = ViewProperties.get().mapOffsetY + planetTile.getPosY() * 64;
            this.landAuctionFrame.draw(n, n2);
        }
    }

    public Blinker getBlinker() {
        return this.blinker;
    }

    MapSkin getSkin() {
        return this.skin;
    }

    public static class TileGraphic {
        public final Image image;

        public TileGraphic(Image image) {
            this.image = image;
        }
    }
}

