/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Spectator;
import com.turborilla.mule.model.UserStatistics;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.AnimatedSprite;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobbyPainter3 {
    private MuleImage background;
    private Animation doorIdle;
    private Animation doorOpening;
    private ArrayList<PlayerSprite> players;
    private static final int[] BACKGROUND_OFFSET = new int[]{8, 8};
    private static final int[] SIGN_OFFSET = new int[]{36, 225};
    private static final int[][] PLAYER_POS = new int[][]{{157, 196}, {261, 196}, {365, 196}, {469, 196}};
    private static final int PLAYER_TEXT_OFFSET = 10;
    private static final int[] DOOR_POS = new int[]{317, 140};
    private View.TextStyle style = View.TextStyle.HUD;
    private boolean openDoor = false;
    private Timer outroTimer;
    private ArrayList<LobbyPainterListener> listeners;

    public LobbyPainter3() throws SlickException {
        this.background = new MuleImage("images/lobby/matchmake.png");
        AnimatedSprite animatedSprite = new AnimatedSprite("images/lobby/matchmake_door.png", 40, 55);
        this.doorIdle = animatedSprite.createAnimation(new int[]{0}, 1000);
        this.doorOpening = animatedSprite.createAnimation(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, 120);
        this.doorOpening.setLooping(false);
        this.players = new ArrayList();
        this.listeners = new ArrayList();
        this.outroTimer = new Timer(){

            public void finished() {
                for (LobbyPainterListener lobbyPainterListener : LobbyPainter3.this.listeners) {
                    lobbyPainterListener.finished();
                }
            }
        };
    }

    public void addListener(LobbyPainterListener lobbyPainterListener) {
        this.listeners.add(lobbyPainterListener);
    }

    public void removeListener(LobbyPainterListener lobbyPainterListener) {
        this.listeners.remove(lobbyPainterListener);
    }

    public void draw() {
        int n = BACKGROUND_OFFSET[0];
        int n2 = BACKGROUND_OFFSET[1];
        this.background.draw(n, n2);
        Animation animation = this.openDoor ? this.doorOpening : this.doorIdle;
        animation.draw(n + 292, n2 + 105);
    }

    public void drawPlayers(GameInfo gameInfo, boolean bl) {
        if (bl) {
            int n = BACKGROUND_OFFSET[0] + SIGN_OFFSET[0];
            int n2 = BACKGROUND_OFFSET[1] + SIGN_OFFSET[1];
            this.style.print("PLAYED", n, n2 + 0);
            this.style.print("WON", n, n2 + 18);
            this.style.print("RATIO", n, n2 + 36);
            this.style.print("ABANDONED", n, n2 + 54);
        }
        for (PlayerSprite playerSprite : this.players) {
            Object object;
            playerSprite.draw();
            if (!bl) continue;
            int n = playerSprite.player.getPlayerIndex();
            int n3 = BACKGROUND_OFFSET[0] + SIGN_OFFSET[0];
            int n4 = BACKGROUND_OFFSET[1] + SIGN_OFFSET[1];
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (playerSprite.player.getStatistics() != null) {
                object = gameInfo.getMode();
                UserStatistics.GameModeStatistics gameModeStatistics = playerSprite.player.getStatistics().getGameModeStatistics((GameMode)((Object)object));
                if (gameModeStatistics != null) {
                    string = "" + gameModeStatistics.getGamesFinished();
                    string2 = "" + gameModeStatistics.getGamesWon();
                    string3 = "" + gameModeStatistics.getWinPercentage() + "%";
                    string4 = "" + gameModeStatistics.getGamesAbandoned();
                } else {
                    string = "0";
                    string2 = "0";
                    string3 = "-";
                    string4 = "0";
                }
            } else if (playerSprite.player.getController() instanceof AIPlayerController || playerSprite.player.getUserId() == 0L) {
                string = "N/A";
                string2 = "N/A";
                string4 = "N/A";
            } else {
                string = "...";
                string2 = "...";
                string4 = "...";
            }
            n3 = BACKGROUND_OFFSET[0] + PLAYER_POS[n][0] + 10;
            object = ViewProperties.get().avatarColors[playerSprite.player.getColorIndex()][1];
            this.style.printCentered(string, (Color)object, n3, n4 + 0);
            this.style.printCentered(string2, (Color)object, n3, n4 + 18);
            this.style.printCentered(string3, (Color)object, n3, n4 + 36);
            this.style.printCentered(string4, (Color)object, n3, n4 + 54);
        }
    }

    public void drawMasterServerStatus(boolean bl, String string) {
        int n = BACKGROUND_OFFSET[0] + SIGN_OFFSET[0];
        int n2 = BACKGROUND_OFFSET[1] + SIGN_OFFSET[1];
        if (string != null) {
            this.style.print(string, n, n2);
        } else if (!bl) {
            this.style.print("NOT LOGGED IN", n, n2);
        } else {
            this.style.print("CONNECTING TO MASTER SERVER...", n, n2 + 72);
        }
    }

    public void drawSpectators(Collection<Spectator> collection, HashMap<Integer, Boolean> hashMap) {
    }

    public void printInitUdp(Player player) {
        int n = player.getPlayerIndex();
        int n2 = BACKGROUND_OFFSET[0] + PLAYER_POS[n][0] + 10;
        int n3 = BACKGROUND_OFFSET[1] + SIGN_OFFSET[1];
        this.style.printCentered("CONNECTING", player.getColor(), n2, n3 + 72);
    }

    public void addPlayer(Player player) {
        this.players.add(new PlayerSprite(player));
    }

    public void removePlayer(Player player) {
        Iterator<PlayerSprite> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            PlayerSprite playerSprite = iterator.next();
            if (playerSprite.player != player) continue;
            iterator.remove();
        }
    }

    public void startOutro() {
        this.openDoor = true;
        this.doorOpening.restart();
        if (Properties.mule.skipIntro) {
            this.outroTimer.start(0.0f);
        }
    }

    public void update() {
        if (this.openDoor) {
            if (!this.outroTimer.isStarted()) {
                boolean bl = true;
                for (PlayerSprite playerSprite : this.players) {
                    playerSprite.update();
                    bl = bl && playerSprite.finished;
                }
                if (bl) {
                    this.outroTimer.start(Properties.mule.matchmakingOutroTime);
                }
            } else {
                this.outroTimer.tick(Properties.mule.delta);
            }
        }
    }

    public static abstract class LobbyPainterListener {
        public abstract void finished();
    }

    private static class PlayerSprite {
        private final Player player;
        private Vec2 pos;
        private Color color = new Color(Color.white);
        private static final float speed = 110.0f;
        private static final float alphaDist = 28.0f;
        private float waitingTime;
        private boolean walkHorizontal = true;
        private boolean finished = false;

        public PlayerSprite(Player player) {
            this.player = player;
            this.getAvatar().setInShop(true);
            this.getAvatar().setDirection(ActorSprite.Direction.South);
            this.getAvatar().stopWalking();
            int n = player.getPlayerIndex();
            this.pos = new Vec2();
            this.pos.x = PLAYER_POS[n][0];
            this.pos.y = PLAYER_POS[n][1];
            this.waitingTime = n % 2 == 0 ? 0.6f : 0.0f;
        }

        public void draw() {
            if (!this.finished) {
                float f = (float)BACKGROUND_OFFSET[0] + this.pos.x;
                float f2 = (float)BACKGROUND_OFFSET[1] + this.pos.y;
                this.getAvatar().getSprite().getAnimation().draw(f - 22.0f, f2 - 40.0f, this.color);
            }
        }

        private void update() {
            float f = DOOR_POS[0];
            float f2 = DOOR_POS[1];
            if (this.waitingTime > 0.0f) {
                this.waitingTime -= Properties.mule.delta;
            } else if (this.walkHorizontal) {
                float f3 = Math.signum(f - this.pos.x);
                this.pos.x += f3 * 110.0f * Properties.mule.delta;
                if (f3 < 0.0f) {
                    this.getAvatar().setDirection(ActorSprite.Direction.West);
                } else {
                    this.getAvatar().setDirection(ActorSprite.Direction.East);
                }
                this.getAvatar().startWalking();
                if (f3 != Math.signum(f - this.pos.x)) {
                    this.pos.x = f;
                    this.walkHorizontal = false;
                }
            } else if (!this.finished) {
                this.pos.y -= 110.0f * Properties.mule.delta;
                this.getAvatar().setDirection(ActorSprite.Direction.North);
                if (this.pos.y <= f2 + 28.0f) {
                    float f4;
                    this.color.g = this.color.b = (f4 = 1.0f - (f2 + 28.0f - this.pos.y) / 28.0f);
                    this.color.r = this.color.b;
                }
                if (this.pos.y <= f2) {
                    this.finished = true;
                }
            }
        }

        private Avatar getAvatar() {
            return this.player.getAvatar();
        }
    }
}

