/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import com.turborilla.mule.view.Effect;
import com.turborilla.mule.view.ViewProperties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class LandPingEffect
extends Effect {
    private float scale;
    private float posX;
    private float posY;
    private Color color;
    private static Image landPing;

    public static void initialize() throws SlickException {
        landPing = new Image("images/land_ping.png");
    }

    public LandPingEffect(int n, float f, float f2) {
        this.posX = (float)ViewProperties.get().mapOffsetX + f;
        this.posY = (float)ViewProperties.get().mapOffsetY + f2 + 1.0f;
        this.color = new Color(ViewProperties.get().getAvatarMainColor(n));
        this.scale = 0.0f;
    }

    public void update() {
        this.scale += 3.5f * Properties.mule.delta;
        this.color.a -= 2.0f * Properties.mule.delta;
        if (this.color.a < 0.0f) {
            this.color.a = 0.0f;
        }
    }

    public void draw() {
        if (this.color.a > 0.0f) {
            float f = this.posX - this.scale * (float)(landPing.getWidth() / 2);
            float f2 = this.posY - this.scale * (float)(landPing.getHeight() / 2);
            landPing.draw(f, f2, this.scale, this.color);
        }
    }

    public boolean isFinished() {
        return this.color.a == 0.0f;
    }
}

