/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.AnimatedSprite;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class IntroPainter {
    private Ship ship;
    private SpriteSheet dustSheet;
    private ArrayList<Dust> engineDust;
    private int engineDustIndex = 0;
    private float[] engineDustSpawnTimes;
    private ArrayList<Dust> hullDust;
    private Random random;
    private SoundPlayer sound = SoundPlayer.get();
    private static final int[][] THRUSTER_OFFSETS = new int[][]{{-4, 93}, {94, 93}, {94, 40}, {-4, 40}};
    private static final int[][] DUST_OFFSETS = new int[][]{{240, 204}, {337, 204}, {337, 151}, {240, 151}};
    private static final Vec2 SHIP_START_POS = new Vec2(265.0f, -126.0f);
    private static final int LANDING_Y = 141;

    public IntroPainter() throws SlickException {
        int n;
        this.dustSheet = new SpriteSheet("images/intro/ship_dust.png", 38, 29);
        this.engineDust = new ArrayList();
        this.hullDust = new ArrayList();
        for (n = 0; n < 40; ++n) {
            this.engineDust.add(new Dust(this.dustSheet));
        }
        this.engineDustSpawnTimes = new float[4];
        for (n = 0; n < 15; ++n) {
            this.hullDust.add(new Dust(this.dustSheet));
        }
        this.ship = new Ship();
        this.random = new Random();
    }

    public void startLanding() {
        this.clearDust();
        this.sound.playShipLanding();
        this.ship.startLanding();
    }

    public void startTakeoff() {
        this.clearDust();
        this.sound.playShipTakeoff();
        this.ship.startTakeoff();
    }

    public boolean isLandingComplete() {
        return !this.ship.landing;
    }

    public boolean isTakeoffComplete() {
        return !this.ship.takeoff;
    }

    private void clearDust() {
        Arrays.fill(this.engineDustSpawnTimes, 0.0f);
        for (Dust dust : this.engineDust) {
            ((Dust)dust).color.a = 0.0f;
        }
        for (Dust dust : this.hullDust) {
            ((Dust)dust).color.a = 0.0f;
        }
    }

    public void update() {
        if (this.ship.thrustersOn && ((Ship)this.ship).pos.y > 41.0f) {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                this.engineDustSpawnTimes[n] = this.engineDustSpawnTimes[n] - Properties.mule.delta;
                if (!(this.engineDustSpawnTimes[i] <= 0.0f)) continue;
                this.engineDustSpawnTimes[i] = 0.031f + 0.002f * (141.0f - ((Ship)this.ship).pos.y);
                Dust dust = this.engineDust.get(this.engineDustIndex);
                dust.spawnEngine(i, ((Ship)this.ship).pos.y, this.random);
                this.engineDustIndex = (this.engineDustIndex + 1) % this.engineDust.size();
            }
        }
        this.ship.update();
        for (Dust dust : this.engineDust) {
            dust.update();
        }
        for (Dust dust : this.hullDust) {
            dust.update();
        }
    }

    public void draw() {
        for (Dust dust : this.engineDust) {
            dust.draw();
        }
        for (Dust dust : this.hullDust) {
            dust.draw();
        }
        this.ship.draw();
    }

    private static class Dust {
        private AnimatedSprite sprite;
        private Vec2 pos;
        private Vec2 vel;
        private Color color;

        public Dust(SpriteSheet spriteSheet) throws SlickException {
            this.sprite = new AnimatedSprite(spriteSheet, 100);
            this.pos = new Vec2(10.0f, 10.0f);
            this.vel = new Vec2(0.0f, 0.0f);
            this.color = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        }

        public void spawnEngine(int n, float f, Random random) {
            this.pos.set(ViewProperties.get().mapOffsetX + DUST_OFFSETS[n][0], ViewProperties.get().mapOffsetY + DUST_OFFSETS[n][1]);
            double d = Math.PI * 2 * random.nextDouble();
            float f2 = 20.0f + 20.0f * random.nextFloat();
            this.vel.x = f2 * (float)Math.cos(d);
            this.vel.y = f2 * (float)Math.sin(d) * 0.75f;
            float f3 = MuleMath.clamp((141.0f - f) / 200.0f, 0.0f, 1.0f);
            this.color.a = 1.0f - f3;
        }

        public void spawnHull(float f, float f2, int n, int n2, Random random) {
            double d = Math.PI * 2 * (double)n / (double)n2;
            float f3 = (float)Math.cos(d);
            float f4 = (float)Math.sin(d) * 0.75f;
            float f5 = 20.0f;
            this.pos.set(f + f5 * f3, f2 + f5 * f4);
            float f6 = 38.0f + 8.0f * random.nextFloat();
            this.vel.x = f6 * f3;
            this.vel.y = f6 * f4;
            this.color.a = 1.0f;
        }

        public void update() {
            if (this.color.a > 0.0f) {
                this.color.a -= 0.8f * Properties.mule.delta;
                if (this.color.a > 0.0f) {
                    this.pos.x += this.vel.x * Properties.mule.delta;
                    this.pos.y += this.vel.y * Properties.mule.delta;
                } else {
                    this.color.a = 0.0f;
                }
            }
        }

        public void draw() {
            if (this.color.a > 0.0f) {
                this.sprite.drawCentered(this.pos.x, this.pos.y, this.color);
            }
        }
    }

    private class Ship {
        private MuleImage shipSprite = new MuleImage("images/intro/ship.png");
        private AnimatedSprite thrusterSprite = new AnimatedSprite("images/intro/ship_thrust.png", 21, 39, 50);
        private Vec2 pos;
        private float waitingTime;
        private boolean landing;
        private boolean takeoff;
        private boolean thrustersOn;
        private boolean spawnedHullDust;

        public void startLanding() {
            this.pos = new Vec2(SHIP_START_POS);
            this.waitingTime = 0.0f;
            this.landing = true;
            this.takeoff = false;
            this.thrustersOn = true;
            this.spawnedHullDust = false;
        }

        public void startTakeoff() {
            this.pos = new Vec2(SHIP_START_POS.x, 141.0f);
            this.waitingTime = 0.0f;
            this.landing = false;
            this.takeoff = true;
            this.thrustersOn = true;
            this.spawnHullDust();
        }

        public void update() {
            if (this.waitingTime > 0.0f) {
                this.waitingTime -= Properties.mule.delta;
                if (this.waitingTime <= 0.0f) {
                    this.waitingTime = 0.0f;
                    this.landing = false;
                    this.takeoff = false;
                }
            } else if (this.landing) {
                float f = 0.2f * Math.abs(this.pos.y - 141.0f) + 9.6f;
                this.pos.y += f * Properties.mule.delta;
                if (this.pos.y > 133.0f) {
                    this.thrustersOn = false;
                    if (!this.spawnedHullDust) {
                        this.spawnHullDust();
                    }
                }
                if (this.pos.y >= 141.0f) {
                    this.pos.y = 141.0f;
                    this.waitingTime = 4.0f;
                }
            } else if (this.takeoff) {
                float f = 30.0f;
                if (this.pos.y > 111.0f) {
                    f -= 0.65f * (this.pos.y - 111.0f);
                }
                this.pos.y -= f * Properties.mule.delta;
                if (this.pos.y < SHIP_START_POS.y) {
                    this.pos.y = SHIP_START_POS.y;
                    this.waitingTime = 2.0f;
                }
            }
        }

        public void draw() {
            if (this.thrustersOn) {
                for (int[] nArray : THRUSTER_OFFSETS) {
                    this.thrusterSprite.draw(this.pos.x + (float)nArray[0], this.pos.y + (float)nArray[1]);
                }
            }
            this.shipSprite.draw(this.pos.x, this.pos.y);
        }

        private void spawnHullDust() {
            float f = this.pos.x + (float)this.shipSprite.getWidth() / 2.0f;
            float f2 = this.pos.y + (float)this.shipSprite.getHeight() / 2.0f + 20.0f;
            int n = IntroPainter.this.hullDust.size();
            for (int i = 0; i < n; ++i) {
                ((Dust)IntroPainter.this.hullDust.get(i)).spawnHull(f, f2, i, n, IntroPainter.this.random);
            }
            this.spawnedHullDust = true;
        }
    }
}

