/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.model.Hireling;
import com.turborilla.mule.model.HirelingManager;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.PaletteImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class HirelingPainter {
    private Graphics graphics;
    private ArrayList<Image> selectionFrame;

    public HirelingPainter(Graphics graphics) throws SlickException, MuleException {
        this.graphics = graphics;
        this.selectionFrame = new ArrayList();
        PaletteImage paletteImage = new PaletteImage("images/hire-frame.png");
        for (int i = 0; i < ViewProperties.get().avatarColors.length; ++i) {
            Color[] colorArray = ViewProperties.get().avatarColors[i];
            this.selectionFrame.add(paletteImage.createImage(colorArray));
        }
    }

    public void drawSelection(HirelingManager hirelingManager, Player player) {
        Hireling hireling = hirelingManager.getSelectedHireling();
        Image image = this.selectionFrame.get(player.getColorIndex());
        Vec2 vec2 = hireling.getAvatar().getPosition();
        ViewProperties.get().getClass();
        float f = 100.0f + vec2.x;
        ViewProperties.get().getClass();
        float f2 = 16.0f + vec2.y;
        image.draw(f - 30.0f, f2 - 48.0f);
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(f - 60.0f, f2 + 20.0f, 260.0f, 45.0f);
        int n = hireling.getSpeed();
        View.TextStyle.TERMINAL.print("Speed " + n, (int)f - 55, (int)f2 + 25);
        View.TextStyle.TERMINAL.print(hireling.getBonusString(), (int)f - 55, (int)f2 + 45);
        this.graphics.setColor(Color.white);
    }
}

