/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.view.Blinker;
import com.turborilla.mule.view.PaletteImage;
import com.turborilla.mule.view.View;
import com.turborilla.mule.view.ViewProperties;
import java.util.Collection;
import java.util.HashMap;
import org.newdawn.slick.BigImage;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.util.MaskUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUDPainter {
    private Graphics graphics;
    private Blinker blinker;
    private BigImage background;
    private Image[] backgroundParts;
    private Image[] hudlights;
    private Image[][] resourceIcons;
    private boolean hudlightsAlwaysVisible = false;
    private boolean hudlightsInvert = false;

    public HUDPainter(Graphics graphics, Blinker blinker) throws SlickException, MuleException {
        this.graphics = graphics;
        this.blinker = blinker;
        this.background = new BigImage("images/terminal.png", 2);
        this.backgroundParts = new BigImage[4];
        this.backgroundParts[0] = this.background.getSubImage(0, 0, 640, 10);
        this.backgroundParts[1] = this.background.getSubImage(630, 10, 10, 362);
        this.backgroundParts[2] = this.background.getSubImage(0, 370, 640, 110);
        this.backgroundParts[3] = this.background.getSubImage(0, 10, 10, 362);
        PaletteImage paletteImage = new PaletteImage("images/hud_resource_icons2.png");
        Color[][] colorArray = ViewProperties.get().avatarColors;
        this.resourceIcons = new Image[colorArray.length][];
        for (int i = 0; i < colorArray.length; ++i) {
            Color[] colorArray2 = null;
            colorArray2 = i == 0 ? new Color[]{new Color(-16776961), new Color(-4505343)} : colorArray[i];
            Image image = paletteImage.createImage(colorArray2);
            SpriteSheet spriteSheet = new SpriteSheet(image, 14, 14);
            this.resourceIcons[i] = new Image[5];
            for (int j = 0; j < this.resourceIcons[i].length; ++j) {
                this.resourceIcons[i][j] = spriteSheet.getSubImage(j, 0);
            }
        }
        SpriteSheet spriteSheet = new SpriteSheet("images/hudlights.png", 42, 10);
        this.hudlights = new Image[colorArray.length];
        for (int i = 1; i < colorArray.length; ++i) {
            this.hudlights[i] = spriteSheet.getSprite(0, i - 1);
        }
    }

    public void draw(Collection<Player> collection, Player player, Shop shop, int n) {
        this.backgroundParts[0].draw(0.0f, 0.0f);
        this.backgroundParts[1].draw(630.0f, 10.0f);
        this.backgroundParts[2].draw(0.0f, 370.0f);
        this.backgroundParts[3].draw(0.0f, 10.0f);
        View.TextStyle textStyle = View.TextStyle.HUD;
        int n2 = 387;
        for (Player player2 : collection) {
            int n3 = 113 + player2.getPlayerIndex() * 104;
            int n4 = player2.getColorIndex();
            this.resourceIcons[n4][1].draw(n3 + 9, n2 + 48);
            this.resourceIcons[n4][2].draw(n3 + 9, n2 + 68);
            this.resourceIcons[n4][0].draw(n3 + 50, n2 + 48);
            this.resourceIcons[n4][3].draw(n3 + 50, n2 + 68);
            Color color = ViewProperties.get().getAvatarMainColor(n4);
            textStyle.printCentered(player2.getHudName(), color, n3 + 51, n2 + 8);
            textStyle.printCentered("$" + player2.getMoney(), color, n3 + 51, n2 + 28);
            textStyle.print("" + player2.getSmithore(), color, n3 + 25, n2 + 48);
            textStyle.print("" + player2.getFood(), color, n3 + 25, n2 + 68);
            textStyle.print("" + player2.getCrystite(), color, n3 + 67, n2 + 48);
            textStyle.print("" + player2.getEnergy(), color, n3 + 67, n2 + 68);
            boolean bl = this.hudlightsAlwaysVisible;
            if (!bl) {
                if (this.hudlightsInvert) {
                    bl = !player2.isContinue();
                } else {
                    boolean bl2 = bl = player2.isContinue() || this.blinker.isVisible();
                }
            }
            if (!bl) continue;
            Image image = this.hudlights[player2.getColorIndex()];
            image.draw(n3 + 30, n2 - 5);
        }
        int n5 = 529;
        n2 = 387;
        this.resourceIcons[0][1].draw(n5 + 9, n2 + 48);
        this.resourceIcons[0][2].draw(n5 + 9, n2 + 68);
        this.resourceIcons[0][4].draw(n5 + 50, n2 + 48);
        this.resourceIcons[0][3].draw(n5 + 50, n2 + 68);
        textStyle.printCentered("Store", n5 + 51, n2 + 8);
        textStyle.print("" + shop.getSmithore(), n5 + 25, n2 + 48);
        textStyle.print("" + shop.getFood(), n5 + 25, n2 + 68);
        textStyle.print("" + shop.numMules(), n5 + 67, n2 + 48);
        textStyle.print("" + shop.getEnergy(), n5 + 67, n2 + 68);
    }

    public void drawLobby(Collection<Player> collection, HashMap<Integer, Boolean> hashMap, int n, boolean bl) {
        Object object;
        int n2;
        MaskUtil.defineMask();
        this.graphics.fillRect(8.0f, 8.0f, 624.0f, 364.0f);
        MaskUtil.finishDefineMask();
        MaskUtil.drawOffMask();
        this.background.draw(0.0f, 0.0f);
        View.TextStyle textStyle = View.TextStyle.HUD;
        int n3 = 387;
        for (Player player : collection) {
            n2 = 113 + player.getPlayerIndex() * 104;
            object = hashMap.get(player.getUserNumber());
            boolean bl2 = object == null ? player.isContinue() : ((Boolean)object).booleanValue();
            Color color = ViewProperties.get().getAvatarMainColor(player.getColorIndex());
            textStyle.printCentered(player.getHudName(), color, n2 + 51, n3 + 8);
            if (bl2) {
                textStyle.printCentered("Ready", color, n2 + 51, n3 + 46);
                continue;
            }
            textStyle.printCentered("Press", color, n2 + 51, n3 + 46);
            textStyle.printCentered("Button", color, n2 + 51, n3 + 64);
        }
        int n4 = 529;
        textStyle.printCentered("Buttons", n4 + 51, n3 + 10);
        textStyle.print("J", n4 + 13, n3 + 28);
        textStyle.print("Join", n4 + 35, n3 + 28);
        textStyle.print("U", n4 + 13, n3 + 46);
        textStyle.print("Unjoin", n4 + 35, n3 + 46);
        if (bl) {
            textStyle.print("A", n4 + 13, n3 + 64);
            textStyle.print("Add A.I.", n4 + 35, n3 + 64);
        }
        for (Player player : collection) {
            n2 = 113 + player.getPlayerIndex() * 104;
            object = this.hudlights[player.getColorIndex()];
            ((Image)object).draw(n2 + 30, n3 - 5);
        }
        MaskUtil.resetMask();
    }

    public void setLightsAlwaysVisible(boolean bl) {
        this.hudlightsAlwaysVisible = bl;
    }

    public void setInvertLights(boolean bl) {
        this.hudlightsInvert = bl;
    }

    public void setResourceHighlight(Resource resource) {
    }
}

