/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.Properties;
import java.util.ArrayList;
import org.lwjgl.input.Keyboard;

public class GameInput {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BUTTON = 4;
    public static final int FULLSCREEN = 5;
    public static final int CHAT = 6;
    public static final int JOIN = 7;
    public static final int UNJOIN = 8;
    public static final int ADD_AI = 9;
    public static final int DEBUG1 = 10;
    public static final int DEBUG2 = 11;
    public static final int DEBUG3 = 12;
    public static final int NUM_KEYS = 13;
    private ArrayList<Control> controls;
    private boolean[] keyDown = new boolean[1024];
    private boolean[] keyPressed = new boolean[1024];
    private int[] keyPressRecord = new int[1024];
    private int numKeysPressed = 0;

    GameInput() {
        this.controls = new ArrayList();
        for (int i = 0; i < 13; ++i) {
            this.controls.add(new Control());
        }
        this.setKey(7, 36);
        this.setKey(8, 22);
        this.setKey(9, 30);
        this.setKey(6, 28);
        if (Properties.mule.debugButtons) {
            this.setKey(10, 2);
            this.setKey(11, 3);
            this.setKey(12, 4);
        }
    }

    public boolean isDown(int n) {
        return this.controls.get(n).down;
    }

    public boolean isPressed(int n) {
        return this.controls.get(n).pressed;
    }

    public void setPressed(int n) {
        this.controls.get(n).forcePressed = true;
    }

    public void clearKeys(int n) {
        this.controls.get(n).clear();
    }

    public void setKey(int n, int n2) {
        this.controls.get(n).addKey(n2);
    }

    void update() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numKeysPressed; ++n2) {
            n = this.keyPressRecord[n2];
            this.keyPressed[n] = false;
        }
        this.numKeysPressed = 0;
        Keyboard.poll();
        while (Keyboard.next()) {
            n2 = Keyboard.getEventKey();
            n = Keyboard.getEventKeyState() ? 1 : 0;
            if (n != 0 || !this.keyDown[n2]) {
                this.keyPressed[n2] = true;
                if (this.numKeysPressed < this.keyPressRecord.length) {
                    this.keyPressRecord[this.numKeysPressed] = n2;
                    ++this.numKeysPressed;
                }
            }
            this.keyDown[n2] = n;
        }
        for (n2 = 0; n2 < this.controls.size(); ++n2) {
            this.controls.get(n2).update(this);
        }
    }

    public void clearKeyStates() {
        for (int i = 0; i < this.keyDown.length; ++i) {
            this.keyDown[i] = false;
            this.keyPressed[i] = false;
        }
        this.numKeysPressed = 0;
    }

    private static class Key {
        final int code;
        boolean pressed;

        public Key(int n) {
            this.code = n;
        }
    }

    private static final class Control {
        private ArrayList<Integer> keyCodes = new ArrayList();
        private boolean pressed;
        private boolean down;
        private boolean forcePressed;

        public Control() {
            this.clear();
        }

        public void update(GameInput gameInput) {
            this.pressed = this.forcePressed;
            this.down = false;
            for (int i = 0; i < this.keyCodes.size(); ++i) {
                int n = this.keyCodes.get(i);
                if (gameInput.keyDown[n]) {
                    this.down = true;
                }
                if (!gameInput.keyPressed[n]) continue;
                this.pressed = true;
            }
            this.forcePressed = false;
        }

        public void addKey(int n) {
            if (!this.keyCodes.contains(n)) {
                this.keyCodes.add(n);
            }
        }

        public void clear() {
            this.keyCodes.clear();
            this.pressed = false;
            this.down = false;
            this.forcePressed = false;
        }
    }
}

