/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.view;

import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.MuleImage;
import com.turborilla.mule.view.Strobe;
import com.turborilla.mule.view.ViewProperties;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;

public class ArrowPainter {
    private ArrayList<Arrow> arrows;

    public ArrowPainter() throws SlickException {
        SpriteSheet spriteSheet = new SpriteSheet(new MuleImage("images/arrows.png", Color.magenta), 32, 32);
        this.arrows = new ArrayList();
        this.arrows.add(new Arrow(ActorSprite.Direction.South, spriteSheet.getSprite(0, 0)));
        this.arrows.add(new Arrow(ActorSprite.Direction.East, spriteSheet.getSprite(2, 0)));
        this.arrows.add(new Arrow(ActorSprite.Direction.West, spriteSheet.getSprite(1, 0)));
        this.arrows.add(new Arrow(ActorSprite.Direction.North, spriteSheet.getSprite(3, 0)));
    }

    public void reset() {
        for (Arrow arrow : this.arrows) {
            arrow.reset();
        }
    }

    public void remove(ActorSprite.Direction direction) {
        for (Arrow arrow : this.arrows) {
            if (arrow.direction != direction) continue;
            arrow.remove();
        }
    }

    public void fadeAll() {
        for (Arrow arrow : this.arrows) {
            arrow.fade();
        }
    }

    public void update(float f) {
        for (Arrow arrow : this.arrows) {
            arrow.update(f);
        }
    }

    public void draw(Vec2 vec2) {
        float f = vec2.x + (float)ViewProperties.get().mapOffsetX;
        float f2 = vec2.y + (float)ViewProperties.get().mapOffsetY;
        for (Arrow arrow : this.arrows) {
            arrow.draw(f, f2);
        }
    }

    private static class Arrow {
        private Image image;
        private ActorSprite.Direction direction;
        private static float OFFSET_MIN = 32.0f;
        private static float OFFSET_NEAR = 42.0f;
        private Color color;
        private boolean fading;
        private boolean removed;
        private boolean visible;
        private Strobe strobe;
        private float pos;

        public Arrow(ActorSprite.Direction direction, Image image) {
            this.direction = direction;
            this.image = image;
            this.color = new Color(Color.white);
            this.strobe = new Strobe(OFFSET_MIN, OFFSET_NEAR, 18.0f);
            this.visible = false;
        }

        public void reset() {
            this.fading = false;
            this.removed = false;
            this.visible = true;
            this.color.a = 1.0f;
            this.strobe.setValue(OFFSET_MIN);
            this.pos = this.strobe.getValue();
        }

        public void remove() {
            this.removed = true;
            this.fading = true;
        }

        public void fade() {
            this.fading = true;
        }

        public void update(float f) {
            if (!this.visible) {
                return;
            }
            if (this.removed) {
                this.pos += 90.0f * f;
            } else {
                this.strobe.update();
                this.pos = this.strobe.getValue();
            }
            if (this.fading) {
                this.color.a -= 2.0f * f;
                if (this.color.a <= 0.0f) {
                    this.color.a = 0.0f;
                    this.visible = false;
                }
            }
        }

        public void draw(float f, float f2) {
            if (!this.visible) {
                return;
            }
            this.draw(f -= (float)(this.image.getWidth() / 2), f2 -= (float)(this.image.getHeight() / 2), this.pos);
        }

        private void draw(float f, float f2, float f3) {
            switch (this.direction) {
                case South: {
                    f2 += f3;
                    break;
                }
                case North: {
                    f2 -= f3;
                    break;
                }
                case East: {
                    f += f3;
                    break;
                }
                case West: {
                    f -= f3;
                }
            }
            f = Math.round(f);
            f2 = Math.round(f2);
            this.image.draw(f, f2, this.color);
        }
    }
}

