/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.network.MessageReceiver;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class Message {
    protected static Logger logger = Logger.getLogger("mule");
    protected int userNumber = 0;
    protected BroadcastType broadcastType = BroadcastType.TO_ALL;

    public int getUserNumber() {
        return this.userNumber;
    }

    public abstract void accept(MessageReceiver var1);

    protected static String getString(ByteBuffer byteBuffer) throws BufferUnderflowException {
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray);
    }

    protected static void putString(String string, ByteBuffer byteBuffer) throws BufferOverflowException {
        byte[] byArray = string.getBytes();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
    }

    protected static boolean getBoolean(ByteBuffer byteBuffer) {
        return byteBuffer.get() != 0;
    }

    protected static void putBoolean(boolean bl, ByteBuffer byteBuffer) {
        byteBuffer.put(bl ? (byte)1 : 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BroadcastType {
        TO_ALL,
        TO_OTHERS,
        TO_SERVER;


        public static BroadcastType get(byte by) {
            BroadcastType[] broadcastTypeArray = BroadcastType.values();
            if (by < 0 || by >= broadcastTypeArray.length) {
                logger.severe("Invalid broadcast type " + by);
                return null;
            }
            return broadcastTypeArray[by];
        }
    }
}

