/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.network;

import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.UserStatistics;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MasterResponse {
    private static Logger logger = Logger.getLogger("mule");
    private String result;
    private TreeMap<String, String> values = new TreeMap();
    private static Pattern pattern = Pattern.compile("\\s*(\\w+)\\s*=\\s*\"(.*?)\"\n", 32);
    private static SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat outputDateFormat = new SimpleDateFormat("EEE, HH:mm");

    public void read(HttpURLConnection httpURLConnection) throws IOException {
        this.values.clear();
        InputStream inputStream = httpURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        this.result = stringBuilder.toString();
        if (this.result.length() > 0) {
            Matcher matcher = pattern.matcher(this.result);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); i += 2) {
                    String string2 = matcher.group(i);
                    String string3 = matcher.group(i + 1);
                    this.values.put(string2, string3);
                }
            }
        }
        if (this.values.isEmpty() && !this.acceptsEmptyResult()) {
            throw new MasterResponseException("Master response has no values", this.result, null);
        }
        if (this.isError()) {
            throw new MasterResponseException(this.getError(), this.result, null);
        }
    }

    protected boolean acceptsEmptyResult() {
        return false;
    }

    public void logValues() {
        logger.warning(this.getClass().getSimpleName() + " values:");
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            logger.warning(" " + entry.getKey() + " = \"" + entry.getValue() + "\"");
        }
    }

    void error(String string) {
        this.values.clear();
        this.values.put("error", string == null ? "unknown error" : string);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean isError() {
        return this.getString("error") != null;
    }

    public String getError() {
        return this.getString("error");
    }

    protected boolean hasValue(String string) {
        return this.values.get(string) != null;
    }

    protected String getString(String string) {
        return this.values.get(string);
    }

    protected int getInt(String string) {
        try {
            return Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.parseException(string, numberFormatException);
        }
    }

    protected long getLong(String string) {
        try {
            return Long.parseLong(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.parseException(string, numberFormatException);
        }
    }

    protected boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            throw this.parseException(string, "Boolean value is null");
        }
        return string2.equals("1") || string2.equalsIgnoreCase("true");
    }

    protected String getDate(String string) {
        try {
            Date date = inputDateFormat.parse(this.getString(string));
            return outputDateFormat.format(date);
        }
        catch (ParseException parseException) {
            throw this.parseException(string, parseException);
        }
    }

    private MasterResponseException parseException(String string, String string2) {
        return new MasterResponseException("Failed to read " + string + ": " + string2, this.result, null);
    }

    private MasterResponseException parseException(String string, Exception exception) {
        return new MasterResponseException("Failed to read " + string + ": " + exception.getMessage(), this.result, exception);
    }

    public String toString() {
        return this.result;
    }

    public abstract void accept(MasterClientListener var1);

    public static class AddChatMessage
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class EnterLobby
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            super.read(httpURLConnection);
        }

        public String getWelcomeText() {
            return this.getString("welcome_text");
        }

        public int getLastMessageId() {
            return this.getInt("last_message_id");
        }
    }

    public static class SaveChat
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class SaveLog
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class AvatarImage
    extends MasterResponse {
        private final long userId;
        private boolean exists;
        private InputStream in;

        public AvatarImage(long l) {
            this.userId = l;
            this.exists = false;
            this.in = null;
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            String string = httpURLConnection.getHeaderField("Content-type");
            if (string == null) {
                super.read(httpURLConnection);
            } else if (string.equals("image")) {
                logger.info("Master Response: Got avatar image for user ID " + this.userId);
                this.in = httpURLConnection.getInputStream();
                this.exists = true;
            } else if (string.equals("none")) {
                this.exists = false;
            } else {
                super.read(httpURLConnection);
            }
        }

        public long getUserId() {
            return this.userId;
        }

        public boolean hasImage() {
            return this.exists;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class UserInfo
    extends MasterResponse {
        private long userId;
        private int rank;
        private UserStatistics.GameModeStatistics statistics;

        public UserInfo(long l) {
            this.userId = l;
            this.rank = 0;
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            super.read(httpURLConnection);
            if (this.exists()) {
                this.rank = this.getInt("rank");
                if (this.getBoolean("user_statistics")) {
                    this.statistics = new UserStatistics.GameModeStatistics(this.getInt("games_finished"), this.getInt("games_won"), this.getInt("games_started"), this.getInt("games_abandoned"), this.getInt("personal_score"), this.getInt("colony_score"), this.getInt("total_score"));
                }
            }
        }

        public long getUserId() {
            return this.userId;
        }

        public int getRank() {
            return this.rank;
        }

        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public boolean exists() {
            return this.getBoolean("user_exists");
        }

        public UserStatistics.GameModeStatistics getStatistics() {
            return this.statistics;
        }

        public String getRace() {
            return this.getString("race");
        }

        public String getIpAddress() {
            return this.getString("ip");
        }
    }

    public static class Logout
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class ResumeGame
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class RefreshLobby
    extends MasterResponse {
        private User[] users;
        private Game[] games;
        private Message[] messages;
        private String updateTime;

        protected boolean acceptsEmptyResult() {
            return true;
        }

        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            int n;
            Object[] objectArray;
            int n2;
            super.read(httpURLConnection);
            this.updateTime = this.getString("update_time");
            if (this.hasValue("num_users")) {
                n2 = this.getInt("num_users");
                objectArray = new User[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = new User(this, n);
                }
                this.users = objectArray;
            }
            if (this.hasValue("num_games")) {
                n2 = this.getInt("num_games");
                objectArray = new Game[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = new Game(this, n);
                }
                this.games = objectArray;
            }
            if (this.hasValue("num_messages")) {
                n2 = this.getInt("num_messages");
                objectArray = new Message[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = new Message(this, n);
                }
                this.messages = objectArray;
            }
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public User[] getUsers() {
            return this.users;
        }

        public Game[] getGames() {
            return this.games;
        }

        public Message[] getMessages() {
            return this.messages;
        }

        public static class Message {
            private long id;
            private long userId;
            private String name;
            private String text;

            Message(RefreshLobby refreshLobby, int n) {
                this.id = refreshLobby.getLong("message_id" + n);
                this.userId = refreshLobby.getLong("message_user_id" + n);
                this.name = refreshLobby.getString("message_name" + n);
                this.text = refreshLobby.getString("message_text" + n);
            }

            public long getUserId() {
                return this.userId;
            }

            public long getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getText() {
                return this.text;
            }
        }

        public static class User {
            private long id;
            private String name;
            private String loginTime;
            private int rank;

            User(RefreshLobby refreshLobby, int n) {
                this.id = refreshLobby.getLong("user_id" + n);
                this.name = refreshLobby.getString("user_name" + n);
                this.loginTime = refreshLobby.getDate("user_login_time" + n);
                this.rank = refreshLobby.getInt("user_rank" + n);
            }

            public String getName() {
                return this.name;
            }

            public long getId() {
                return this.id;
            }

            public String getLoginTime() {
                return this.loginTime;
            }

            public int getRank() {
                return this.rank;
            }
        }

        public static class Game {
            private long id;
            private String name;
            private String nameAndCoordinate;
            private String address;
            private String status;
            private GameMode mode;
            private String users;
            private boolean allowSpectators;
            private int round;
            private int numRounds;
            private long[] userIds;
            private long hostUserId;
            private String hostName;
            private String reliability;
            private static final int RELIABILITY_UNKNOWN = -1;

            private Game(RefreshLobby refreshLobby, int n) {
                int n2;
                this.id = refreshLobby.getLong("game_id" + n);
                this.name = refreshLobby.getString("game_name" + n);
                this.address = refreshLobby.getString("game_address" + n);
                this.status = refreshLobby.getString("game_status" + n);
                this.mode = GameMode.get(refreshLobby.getString("game_mode" + n));
                this.allowSpectators = refreshLobby.getBoolean("game_spectators" + n);
                this.round = refreshLobby.getInt("game_round" + n);
                this.numRounds = refreshLobby.getInt("game_num_rounds" + n);
                this.hostUserId = refreshLobby.getLong("host_user_id" + n);
                this.hostName = refreshLobby.getString("host_name" + n);
                int n3 = refreshLobby.getInt("host_reliability" + n);
                String string = refreshLobby.getString("host_category" + n);
                this.reliability = n3 == -1 ? "Pending" : n3 + "% " + string;
                int n4 = refreshLobby.getInt("game_num_users" + n);
                StringBuilder stringBuilder = new StringBuilder();
                this.userIds = new long[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    this.userIds[n2] = refreshLobby.getLong("game_" + n + "_user_id" + n2);
                    if (this.userIds[n2] == this.hostUserId) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    String string2 = refreshLobby.getString("game_" + n + "_user_name" + n2);
                    stringBuilder.append(string2);
                }
                this.users = stringBuilder.toString();
                n2 = refreshLobby.getInt("game_coord" + n);
                this.nameAndCoordinate = GameInfo.validCoordinate(n2) ? this.name + " " + GameInfo.coordinateToString(n2) : this.name;
            }

            public String getName() {
                return this.name;
            }

            public String getNameAndCoordinate() {
                return this.nameAndCoordinate;
            }

            public String getAddress() {
                return this.address;
            }

            public String getStatus() {
                return this.status;
            }

            public GameMode getMode() {
                return this.mode;
            }

            public String getHostName() {
                return this.hostName;
            }

            public String getReliability() {
                return this.reliability;
            }

            public boolean isAllowSpectators() {
                return this.allowSpectators;
            }

            public long getId() {
                return this.id;
            }

            public String getUsers() {
                return this.users;
            }

            public long[] getUserIds() {
                return this.userIds;
            }

            public int getRound() {
                return this.round;
            }

            public int getNumRounds() {
                return this.numRounds;
            }

            public long getHostUserId() {
                return this.hostUserId;
            }
        }
    }

    public static class FinishGame
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class FinishRound
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class RoundResults
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class UserLeft
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class UserJoin
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class StartGame
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }

    public static class NewGame
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public long getGameID() {
            return this.getLong("game_id");
        }

        public int getCoordinate() {
            return this.getInt("coordinate");
        }

        public String getServerAddress() {
            return this.getString("server_address");
        }
    }

    public static class TestConnection
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public boolean isSuccess() {
            String string = this.getString("success");
            return string != null && string.equals("true");
        }

        public String getSocketError() {
            String string = this.getString("socket_error");
            if (string == null) {
                return this.getError();
            }
            return string;
        }
    }

    public static class RegisterUser
    extends MasterResponse {
        private long userId = 0L;

        public void accept(MasterClientListener masterClientListener) {
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            super.read(httpURLConnection);
            this.userId = this.getLong("user_id");
        }

        public long getUserId() {
            return this.userId;
        }
    }

    public static class Alive
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
        }
    }

    public static class Login
    extends MasterResponse {
        private long userId = 0L;
        private boolean wrongPassword = false;

        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }

        public void read(HttpURLConnection httpURLConnection) throws IOException {
            super.read(httpURLConnection);
            if (!"mule".equalsIgnoreCase(this.getString("magic_string"))) {
                this.error("Master server is invalid or not responding");
                return;
            }
            if (this.isMaintenance()) {
                return;
            }
            if (this.isWrongVersion()) {
                return;
            }
            if (this.isRaceUnknown()) {
                return;
            }
            String string = this.getString("wrong_password");
            if (string != null && string.equals("true")) {
                this.wrongPassword = true;
            } else {
                this.userId = this.getLong("user_id");
            }
        }

        public String getName() {
            return this.getString("name");
        }

        public long getUserId() {
            return this.userId;
        }

        public String getRace() {
            return this.getString("race");
        }

        public boolean isWrongPassword() {
            return this.wrongPassword;
        }

        public boolean isNoUsername() {
            return this.userId == 0L;
        }

        public boolean isMaintenance() {
            return this.getMaintenance() != null;
        }

        public boolean isWrongVersion() {
            return this.getVersion() != null;
        }

        public boolean isRaceUnknown() {
            String string = this.getString("unknown_race");
            return string != null && string.equals("true");
        }

        public String getMaintenance() {
            return this.getString("maintenance");
        }

        public String getVersion() {
            return this.getString("version");
        }
    }

    public static class Debug
    extends MasterResponse {
        public void accept(MasterClientListener masterClientListener) {
            masterClientListener.apply(this);
        }
    }
}

