/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.newdawn.slick.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile
implements Serializable {
    private static final long serialVersionUID = 2558093051454332717L;
    protected final String name;
    protected String identifier;
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected Tile parentTile;
    protected Color color = Color.white;
    private ArrayList<Tile> tileBits;

    public Tile(String string, String string2, int n, int n2) {
        this.name = string;
        this.identifier = string2;
        this.xOffset = n;
        this.yOffset = n2;
        this.parentTile = null;
        this.tileBits = new ArrayList();
    }

    public Tile(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public Tile(String string) {
        this(string, string);
    }

    public Tile addTileBit(String string, String string2, int n, int n2) {
        Tile tile = new Tile(string, string2, n, n2);
        this.tileBits.add(tile);
        tile.setParentTile(this);
        return tile;
    }

    public void removeTileBits(String string) {
        Iterator<Tile> iterator = this.tileBits.iterator();
        while (iterator.hasNext()) {
            Tile tile = iterator.next();
            if (!tile.getName().equals(string)) continue;
            iterator.remove();
        }
    }

    public void removeTileBit(Tile tile) {
        Iterator<Tile> iterator = this.tileBits.iterator();
        while (iterator.hasNext()) {
            Tile tile2 = iterator.next();
            if (tile2 != tile) continue;
            iterator.remove();
            return;
        }
    }

    public void clearTileBits() {
        this.tileBits.clear();
    }

    public Iterator<Tile> getTileBitIterator() {
        return this.tileBits.iterator();
    }

    public int numTileBits() {
        return this.tileBits.size();
    }

    public Tile getTileBit(int n) {
        return this.tileBits.get(n);
    }

    public Tile findFirstTileBit(String string) {
        for (Tile tile : this.tileBits) {
            if (!tile.name.equals(string)) continue;
            return tile;
        }
        return null;
    }

    public Tile findLastTileBit(String string) {
        for (int i = this.tileBits.size() - 1; i >= 0; --i) {
            Tile tile = this.tileBits.get(i);
            if (!tile.name.equals(string)) continue;
            return tile;
        }
        return null;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int n) {
        this.yOffset = n;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Tile getParentTile() {
        return this.parentTile;
    }

    void setParentTile(Tile tile) {
        this.parentTile = tile;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }
}

