/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.map.AbstractMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.MapSkin;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class PlanetMap
extends AbstractMap<PlanetTile>
implements Serializable {
    private static final long serialVersionUID = 1L;
    CollisionDetector.CollisionSet boundaryCollision = new CollisionDetector.CollisionSet();
    CollisionDetector.CollisionSet shopCollision = new CollisionDetector.CollisionSet();
    PlanetTile shopTile;
    private Vec2 shopCenter;
    private Vec2 northEnterance;
    private Vec2 southEnterance;
    private Vec2 eastEnterance;
    private Vec2 westEnterance;
    private transient MapSkin skin;
    private boolean river = false;
    private int width;
    private int height;

    public PlanetMap(int n, int n2) {
        super(n, n2);
        this.width = n * 64;
        this.height = n2 * 64;
        Geometry.Rectangle rectangle = new Geometry.Rectangle(n * 64 / 2, n2 * 64 / 2, true);
        this.boundaryCollision.add(new Collidable(n * 64 / 2, n2 * 64 / 2, rectangle));
        this.shopCenter = new Vec2(0.0f, 0.0f);
    }

    public PlanetTile addTile(PlanetTile.PlanetTileType planetTileType, int n, int n2, int n3) {
        PlanetTile planetTile;
        ((PlanetTile[][])this.tiles)[n2][n3] = planetTile = new PlanetTile(planetTileType, n, n2, n3);
        if (planetTileType == PlanetTile.PlanetTileType.Shop) {
            Geometry.Rectangle rectangle = new Geometry.Rectangle(32.0f, 32.0f, false);
            this.shopCenter.x = n2 * 64 + 32;
            this.shopCenter.y = n3 * 64 + 32;
            Collidable collidable = new Collidable(this.shopCenter.x, this.shopCenter.y, rectangle);
            this.shopCollision.add(collidable);
            this.shopTile = planetTile;
            float f = 32.0f + Avatar.outOfShopGeometry.getRadius() + 1.0f;
            float f2 = 32.0f + Avatar.outOfShopGeometry.getRadius() + 1.0f;
            this.eastEnterance = new Vec2(this.shopCenter.x + f, this.shopCenter.y);
            this.northEnterance = new Vec2(this.shopCenter.x, this.shopCenter.y - f2);
            this.westEnterance = new Vec2(this.shopCenter.x - f, this.shopCenter.y);
            this.southEnterance = new Vec2(this.shopCenter.x, this.shopCenter.y + f2);
        }
        return planetTile;
    }

    @Override
    protected void initTileArray(int n, int n2) {
        this.tiles = new PlanetTile[n][n2];
    }

    public PlanetTile getTileAtPosition(float f, float f2) {
        int n = (int)(f / 64.0f);
        int n2 = (int)(f2 / 64.0f);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.getXSize()) {
            n = this.getXSize() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.getYSize()) {
            n2 = this.getYSize() - 1;
        }
        return (PlanetTile)this.getTile(n, n2);
    }

    public boolean isInCollision(float f, float f2) {
        return this.getTileAtPosition(f, f2).isInCollision(f, f2);
    }

    public CollisionDetector.CollisionSet getShopCollision() {
        return this.shopCollision;
    }

    public CollisionDetector.CollisionSet getBoundaryCollision() {
        return this.boundaryCollision;
    }

    public Vec2 getShopCenter() {
        return this.shopCenter;
    }

    public PlanetTile getShopTile() {
        return this.shopTile;
    }

    public Vec2 getNorthEnterance() {
        return this.northEnterance;
    }

    public Vec2 getSouthEnterance() {
        return this.southEnterance;
    }

    public Vec2 getEastEnterance() {
        return this.eastEnterance;
    }

    public Vec2 getWestEnterance() {
        return this.westEnterance;
    }

    public void setSkin(MapSkin mapSkin) {
        this.skin = mapSkin;
    }

    public MapSkin getSkin() {
        return this.skin;
    }

    public boolean isRiver() {
        return this.river;
    }

    void setRiver(boolean bl) {
        this.river = bl;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int j = 0; j < this.getXSize(); ++j) {
                string = string + "[" + ((PlanetTile)this.getTile(j, i)).getIdentifier() + "]";
            }
            string = string + "\n";
        }
        return string;
    }
}

