/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model.map;

import com.turborilla.mule.model.map.Tile;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMap<E extends Tile>
implements Serializable {
    private static final long serialVersionUID = -2704313399895248210L;
    private int xSize;
    private int ySize;
    protected E[][] tiles;

    public AbstractMap(int n, int n2) {
        this.xSize = n;
        this.ySize = n2;
        this.initTileArray(n, n2);
    }

    protected abstract void initTileArray(int var1, int var2);

    public E getTile(int n, int n2) {
        if (n < 0 || n >= this.xSize) {
            return null;
        }
        if (n2 < 0 || n2 >= this.ySize) {
            return null;
        }
        return this.tiles[n][n2];
    }

    public E[] getTilesByName(String string, E[] EArray) {
        ArrayList<E> arrayList = new ArrayList<E>();
        if (string != null) {
            for (int i = 0; i < this.getXSize(); ++i) {
                for (int j = 0; j < this.getYSize(); ++j) {
                    E e = this.getTile(i, j);
                    if (e == null || !string.equals(((Tile)e).getName())) continue;
                    arrayList.add(e);
                }
            }
        }
        return (Tile[])arrayList.toArray(EArray);
    }

    public int getTileXPos(E e) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int j = 0; j < this.getXSize(); ++j) {
                if (this.getTile(j, i) != e) continue;
                n = j;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return n;
    }

    public int getTileYPos(E e) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int j = 0; j < this.getXSize(); ++j) {
                if (this.getTile(j, i) != e) continue;
                n = i;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return n;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }
}

