/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.map.Tile;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.sound.SoundPlayer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;

public strictfp class Wampus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private Vec2 pos = new Vec2(-100.0f, -100.0f);
    private boolean appeared;
    private boolean dead;
    private transient WeakReference<Player> caughtBy;
    private boolean visible;
    private float blinkTimer;
    private int numBlinks;
    private Random random;
    private ArrayList<Mountain> mountains = new ArrayList();
    private int mountainIndex;
    private int moneyReward;
    private int smithoreReward;
    private long updateCount;

    public Wampus(PlanetMap planetMap, Random random, int n) {
        for (int i = 0; i < planetMap.getYSize(); ++i) {
            for (int j = 0; j < planetMap.getXSize(); ++j) {
                PlanetTile.PlanetTileType planetTileType;
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(j, i);
                if (planetTile.getOwner() != null || (planetTileType = planetTile.getType()) != PlanetTile.PlanetTileType.Mountain1 && planetTileType != PlanetTile.PlanetTileType.Mountain2 && planetTileType != PlanetTile.PlanetTileType.Mountain3) continue;
                Iterator<Tile> iterator = planetTile.getTileBitIterator();
                while (iterator.hasNext()) {
                    Tile tile = iterator.next();
                    if (!tile.getName().endsWith("mountain")) continue;
                    this.mountains.add(new Mountain(planetTile, tile));
                }
            }
        }
        this.appeared = false;
        this.caughtBy = null;
        this.visible = false;
        this.dead = this.mountains.isEmpty();
        this.blinkTimer = Properties.mule.easyToCatchWampus ? 0.0f : 12.0f + 3.0f * random.nextFloat();
        this.numBlinks = 0;
        this.mountainIndex = -1;
        this.moneyReward = 100 * ((n + 4) / 4);
        this.random = new Random(random.nextLong());
        this.updateCount = -1L;
        logger.info("Wampus has " + this.mountains.size() + " mountains, reward is $" + this.moneyReward);
    }

    public void update(long l, SoundPlayer soundPlayer) {
        if (l <= this.updateCount) {
            return;
        }
        this.updateCount = l;
        if (this.dead) {
            return;
        }
        this.blinkTimer -= Properties.mule.delta;
        if (this.blinkTimer <= 0.0f) {
            if (this.visible) {
                this.blinkTimer = Properties.mule.easyToCatchWampus ? (this.blinkTimer += 0.2f) : (this.blinkTimer += 4.25f);
            } else {
                if (this.numBlinks == 0) {
                    this.randomMountain();
                    this.numBlinks = 2;
                }
                this.blinkTimer = Properties.mule.easyToCatchWampus ? (this.blinkTimer += 3.45f) : (this.blinkTimer += 0.75f);
                --this.numBlinks;
            }
            this.visible = !this.visible;
            this.appeared = true;
            if (this.visible && soundPlayer != null) {
                soundPlayer.playWampusAppeared(this.pos.y);
            }
        }
    }

    public void die() {
        this.visible = false;
        this.dead = true;
    }

    public boolean canBeCaughtAt(float f, float f2) {
        if (!this.appeared || this.dead) {
            return false;
        }
        float f3 = this.pos.distance(f, f2);
        return f3 < 5.0f;
    }

    public boolean setCaughtBy(Player player) {
        if (this.dead) {
            return false;
        }
        this.caughtBy = new WeakReference<Player>(player);
        this.die();
        return true;
    }

    public final Vec2 getPos() {
        return this.pos;
    }

    public boolean hasAppeared() {
        return this.appeared;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasMountains() {
        return !this.mountains.isEmpty();
    }

    private void randomMountain() {
        if (this.mountains.isEmpty()) {
            if (!this.dead) {
                this.die();
                logger.info("Wampus has no more mountains and dies");
            }
            return;
        }
        int n = this.random.nextInt(this.mountains.size());
        if (n == this.mountainIndex) {
            n = (n + 1) % this.mountains.size();
        }
        this.mountainIndex = n;
        Tile tile = this.mountains.get((int)n).mountain;
        PlanetTile planetTile = this.mountains.get((int)n).tile;
        this.pos.set(planetTile.getPosX() * 64 + tile.getXOffset() + 14, planetTile.getPosY() * 64 + tile.getYOffset() + 14);
    }

    public boolean isCaughtBy(Player player) {
        if (this.caughtBy == null) {
            return false;
        }
        return this.caughtBy.get() == player;
    }

    public int getMoneyReward() {
        return this.moneyReward;
    }

    public int getSmithoreReward() {
        return this.smithoreReward;
    }

    public void landClaimed(PlanetTile planetTile) {
        boolean bl = false;
        Iterator<Mountain> iterator = this.mountains.iterator();
        while (iterator.hasNext()) {
            Mountain mountain = iterator.next();
            if (mountain.tile != planetTile) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            this.randomMountain();
        }
    }

    public boolean isDead() {
        return this.dead;
    }

    private strictfp static class Mountain
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Tile mountain;
        public PlanetTile tile;

        public Mountain(PlanetTile planetTile, Tile tile) {
            this.tile = planetTile;
            this.mountain = tile;
        }
    }
}

