/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.UserStatistics;
import com.turborilla.mule.network.Client;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.view.ViewProperties;
import java.io.Serializable;
import org.newdawn.slick.Color;

public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NO_ID = 0L;
    public static final int NO_USER_NUMBER = 0;
    private String name;
    private String hudName;
    private long userId;
    private int userNumber;
    private boolean accepted;
    private boolean pressedContinue;
    private boolean ready;
    private String defaultRace;
    private UserStatistics statistics;
    private String ipAddress;

    public User(String string, long l, int n, String string2) {
        if (string == null) {
            string = "Unknown";
        }
        this.name = string;
        this.hudName = string.length() > 10 ? string.substring(0, 10) : new String(string);
        this.userId = l;
        this.userNumber = n;
        this.accepted = false;
        this.pressedContinue = false;
        this.ready = false;
        this.defaultRace = string2;
    }

    public User(User user) {
        this.name = user.name;
        this.hudName = user.hudName;
        this.userId = user.userId;
        this.userNumber = user.userNumber;
        this.accepted = user.accepted;
        this.pressedContinue = user.pressedContinue;
        this.ready = user.ready;
        this.defaultRace = user.defaultRace;
        this.statistics = user.statistics;
        this.ipAddress = user.ipAddress;
    }

    public int getUserNumber() {
        return this.userNumber;
    }

    public final boolean isAccepted() {
        return this.accepted;
    }

    public final void setAccepted(boolean bl) {
        this.accepted = bl;
    }

    public boolean isContinue() {
        return this.pressedContinue;
    }

    public void setContinue(boolean bl) {
        this.pressedContinue = bl;
    }

    public final boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultRace() {
        return this.defaultRace;
    }

    public String getHudName() {
        return this.hudName;
    }

    public long getUserId() {
        return this.userId;
    }

    public final Color getColor() {
        return ViewProperties.get().getAvatarMainColor(this.getColorIndex());
    }

    public void setStatistics(UserStatistics userStatistics) {
        this.statistics = userStatistics;
    }

    public UserStatistics getStatistics() {
        return this.statistics;
    }

    public void send(Client client, TCPMessage tCPMessage) {
        client.sendTCP(this.userNumber, tCPMessage);
    }

    public void sendUnordered(Client client, TCPMessage tCPMessage) {
        client.sendTcpUnordered(this.userNumber, tCPMessage);
    }

    public void sendToOthers(Client client, TCPMessage tCPMessage) {
        client.sendTcpToOthers(this.userNumber, tCPMessage);
    }

    public void sendToServer(Client client, TCPMessage tCPMessage) {
        client.sendTcpToServer(this.userNumber, tCPMessage);
    }

    public void send(Client client, UDPMessage uDPMessage) {
        client.sendUDP(this.userNumber, uDPMessage);
    }

    public void sendToOthers(Client client, UDPMessage uDPMessage) {
        client.sendUDPToOthers(this.userNumber, uDPMessage);
    }

    public void sendToServer(Client client, UDPMessage uDPMessage) {
        client.sendUDPToServer(this.userNumber, uDPMessage);
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isAiPlayer() {
        return false;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getColorIndex() {
        return -1;
    }
}

