/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Geometry;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.ResourcePrices;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.Vec2;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Shop
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private int numMules;
    private int food;
    private int energy;
    private int smithore;
    private int crystite;
    private ResourcePrices foodPrices;
    private ResourcePrices energyPrices;
    private ResourcePrices smithorePrices;
    private ResourcePrices crystitePrices;
    private int mulePrice;
    private CollisionDetector.CollisionSet walls;
    private CollisionDetector.CollisionSet exits;
    private Collidable muleStore;
    private Collidable foodStore;
    private Collidable energyStore;
    private Collidable smithoreStore;
    private Collidable crystiteStore;
    private Collidable pub;
    private Collidable assay;
    private Collidable plant;
    private Collidable plantDoor;
    private CollisionDetector.CollisionSet allStores;
    private Collidable northExit;
    private Collidable southExit;
    private Collidable eastExit;
    private Collidable westExit;
    private static final Vec2 northEnterance = new Vec2(219.0f, 18.0f);
    private static final Vec2 southEnterance = new Vec2(219.0f, 332.0f);
    private static final Vec2 eastEnterance = new Vec2(425.0f, 180.0f);
    private static final Vec2 westEnterance = new Vec2(16.0f, 180.0f);
    private static final Vec2 startLocation = new Vec2(219.0f, 183.0f);

    public Shop() {
        this.numMules = Properties.mule.shopStartNumMules;
        this.food = Properties.mule.shopStartFood;
        this.energy = Properties.mule.shopStartEnergy;
        this.smithore = Properties.mule.shopStartSmithore;
        this.crystite = Properties.mule.shopStartCrystite;
        this.mulePrice = Properties.mule.shopMuleInitialPrice;
        this.foodPrices = new ResourcePrices();
        this.energyPrices = new ResourcePrices();
        this.smithorePrices = new ResourcePrices();
        this.crystitePrices = new ResourcePrices();
        this.foodPrices.setFoodPrice(Properties.mule.shopFoodInitialPrice);
        this.energyPrices.setEnergyPrice(Properties.mule.shopEnergyInitialPrice);
        this.smithorePrices.setSmithorePrice(Properties.mule.shopSmithoreInitialPrice);
        this.crystitePrices.setCrystitePrice(Properties.mule.shopCrystiteInitialPrice);
        this.walls = new CollisionDetector.CollisionSet();
        this.exits = new CollisionDetector.CollisionSet();
        this.crystiteStore = Geometry.Rectangle.createCollidable(21.0f, 58.0f, 63.0f, 50.0f);
        this.smithoreStore = Geometry.Rectangle.createCollidable(120.0f, 58.0f, 63.0f, 50.0f);
        this.energyStore = Geometry.Rectangle.createCollidable(257.0f, 58.0f, 63.0f, 50.0f);
        this.foodStore = Geometry.Rectangle.createCollidable(355.0f, 58.0f, 63.0f, 50.0f);
        this.assay = Geometry.Rectangle.createCollidable(8.0f, 250.0f, 88.0f, 76.0f);
        this.plant = Geometry.Rectangle.createCollidable(108.0f, 250.0f, 88.0f, 76.0f);
        this.plantDoor = Geometry.Rectangle.createCollidable(111.0f, 206.0f, 81.0f, 33.0f);
        this.pub = Geometry.Rectangle.createCollidable(244.0f, 250.0f, 88.0f, 76.0f);
        this.muleStore = Geometry.Rectangle.createCollidable(345.0f, 245.0f, 88.0f, 76.0f);
        this.allStores = new CollisionDetector.CollisionSet();
        this.allStores.add(this.muleStore);
        this.allStores.add(this.foodStore);
        this.allStores.add(this.energyStore);
        this.allStores.add(this.smithoreStore);
        this.allStores.add(this.crystiteStore);
        this.allStores.add(this.pub);
        this.allStores.add(this.assay);
        this.allStores.add(this.plant);
        this.northExit = Geometry.Rectangle.createCollidable(200.0f, -17.0f, 41.0f, 24.0f);
        this.southExit = Geometry.Rectangle.createCollidable(200.0f, 342.0f, 41.0f, 24.0f);
        this.eastExit = Geometry.Rectangle.createCollidable(435.0f, 138.0f, 25.0f, 68.0f);
        this.westExit = Geometry.Rectangle.createCollidable(-19.0f, 138.0f, 25.0f, 68.0f);
        this.exits.add(this.northExit);
        this.exits.add(this.southExit);
        this.exits.add(this.eastExit);
        this.exits.add(this.westExit);
        this.walls.add(Geometry.Rectangle.createCollidable(0.0f, 0.0f, 174.0f, 69.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(266.0f, 0.0f, 174.0f, 69.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(0.0f, 70.0f, 32.0f, 70.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(72.0f, 69.0f, 60.0f, 71.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(172.0f, 0.0f, 29.0f, 138.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(240.0f, 0.0f, 28.0f, 140.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(308.0f, 69.0f, 60.0f, 71.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(408.0f, 0.0f, 31.0f, 140.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(308.0f, 206.0f, 60.0f, 33.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(308.0f, 240.0f, 42.0f, 71.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(240.0f, 311.0f, 199.0f, 36.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(408.0f, 206.0f, 32.0f, 33.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(428.0f, 239.0f, 11.0f, 72.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(72.0f, 206.0f, 61.0f, 104.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(0.0f, 300.0f, 200.0f, 48.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(172.0f, 206.0f, 28.0f, 33.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(192.0f, 238.0f, 8.0f, 73.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(240.0f, 206.0f, 28.0f, 105.0f));
        this.walls.add(Geometry.Rectangle.createCollidable(4.0f, 206.0f, 28.0f, 103.0f));
    }

    public int numMules() {
        return this.numMules;
    }

    public boolean decreaseMules() {
        if (this.numMules == 0) {
            return false;
        }
        --this.numMules;
        return true;
    }

    public CollisionDetector.CollisionSet getWalls() {
        return this.walls;
    }

    public CollisionDetector.CollisionSet getExits() {
        return this.exits;
    }

    public CollisionDetector.CollisionSet getAllStores() {
        return this.allStores;
    }

    public Collidable getMuleStore() {
        return this.muleStore;
    }

    public Collidable getFoodStore() {
        return this.foodStore;
    }

    public Collidable getEnergyStore() {
        return this.energyStore;
    }

    public Collidable getSmithoreStore() {
        return this.smithoreStore;
    }

    public Collidable getCrystiteStore() {
        return this.crystiteStore;
    }

    public Collidable getPub() {
        return this.pub;
    }

    public Collidable getAssay() {
        return this.assay;
    }

    public Collidable getLand() {
        return this.plant;
    }

    public Collidable getLab() {
        return this.plant;
    }

    public Collidable getNorthExit() {
        return this.northExit;
    }

    public Collidable getSouthExit() {
        return this.southExit;
    }

    public Collidable getEastExit() {
        return this.eastExit;
    }

    public Collidable getWestExit() {
        return this.westExit;
    }

    public int getMuleCost() {
        return this.mulePrice;
    }

    public void increaseMules() {
        if (this.numMules < Properties.mule.shopMaxBuildMules) {
            ++this.numMules;
        }
    }

    public int getFood() {
        return this.food;
    }

    public void setFood(int n) {
        this.food = Math.min(n, Properties.mule.maxShopUnits);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int n) {
        this.energy = Math.min(n, Properties.mule.maxShopUnits);
    }

    public int getSmithore() {
        return this.smithore;
    }

    public void setSmithore(int n) {
        this.smithore = Math.min(n, Properties.mule.maxShopUnits);
    }

    public int getCrystite() {
        return this.crystite;
    }

    public void setCrystite(int n) {
        this.crystite = Math.min(n, Properties.mule.maxShopUnits);
    }

    public int getResource(Resource resource) {
        switch (resource) {
            case Food: {
                return this.food;
            }
            case Energy: {
                return this.energy;
            }
            case Crystite: {
                return this.crystite;
            }
            case Smithore: {
                return this.smithore;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public void setResource(Resource resource, int n) {
        switch (resource) {
            case Food: {
                this.setFood(n);
                return;
            }
            case Energy: {
                this.setEnergy(n);
                return;
            }
            case Crystite: {
                this.setCrystite(n);
                return;
            }
            case Smithore: {
                this.setSmithore(n);
                return;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public void calcBuySellPrice(Random random, PlanetMap planetMap, Collection<Player> collection, Resource resource, int n) {
        logger.info("Current " + (Object)((Object)resource) + " price $" + this.getPrice(resource));
        switch (resource) {
            case Crystite: {
                int n2 = random.nextInt(Properties.mule.shopCrystitePriceDeviance);
                this.crystitePrices.calcCrystitePrice(n2);
                logger.info(resource.getName() + " buy price $" + this.crystitePrices.buyPrice + " sell price $" + this.crystitePrices.sellPrice);
                break;
            }
            case Smithore: {
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                for (n4 = 0; n4 < planetMap.getXSize(); ++n4) {
                    for (n3 = 0; n3 < planetMap.getYSize(); ++n3) {
                        PlanetTile planetTile = (PlanetTile)planetMap.getTile(n4, n3);
                        if (planetTile.getOwner() == null) {
                            ++n5;
                            continue;
                        }
                        if (planetTile.getFactory() != null) continue;
                        ++n6;
                    }
                }
                n4 = Math.min(n5, collection.size()) + n6;
                if (n4 > 8) {
                    n4 = 8;
                }
                n3 = this.numMules() + this.smithore / 2;
                int n7 = Math.round(1.0f * MuleMath.normalDistributed(random) * 7.0f);
                logger.info("Smithore random variation $" + n7);
                float f = this.smithorePrices.calcSmithorePrice(n3, n4, n7);
                this.printPriceFactor(resource, n3, n4, f, this.smithorePrices);
                break;
            }
            case Food: {
                int n8 = collection.size() * Properties.mule.foodRequirements[Math.min(n + 1, 12)];
                int n9 = this.food;
                for (Player player : collection) {
                    n9 += player.getFood() + player.calcProduction(Resource.Food) - player.calcSpoilage(Resource.Food);
                }
                float f = this.foodPrices.calcFoodPrice(n9, n8);
                this.printPriceFactor(resource, n9, n8, f, this.foodPrices);
                break;
            }
            case Energy: {
                int n10 = this.energy;
                int n11 = 0;
                for (Player player : collection) {
                    n10 += player.getEnergy() + player.calcProduction(Resource.Energy) - player.calcSpoilage(Resource.Energy);
                    n11 += player.getEnergyRequirement() + 1;
                }
                float f = this.energyPrices.calcEnergyPrice(n10, n11);
                this.printPriceFactor(resource, n10, n11, f, this.energyPrices);
                break;
            }
        }
    }

    public int getFoodNeed(GameModel gameModel) {
        return gameModel.getPlayers().size() * Properties.mule.foodRequirements[gameModel.getRound() + 1];
    }

    public int getEnergyNeed(GameModel gameModel) {
        int n = 0;
        for (Player player : gameModel.getPlayers()) {
            n += player.getEnergyRequirement() + 1;
        }
        return n;
    }

    public int getMuleNeed(GameModel gameModel) {
        int n;
        int n2 = 0;
        int n3 = 0;
        PlanetMap planetMap = gameModel.getMap();
        for (n = 0; n < planetMap.getXSize(); ++n) {
            for (int i = 0; i < planetMap.getYSize(); ++i) {
                PlanetTile planetTile = (PlanetTile)planetMap.getTile(n, i);
                if (planetTile.getOwner() == null) {
                    ++n2;
                    continue;
                }
                if (planetTile.getFactory() != null) continue;
                ++n3;
            }
        }
        n = Math.min(n2, gameModel.getPlayers().size()) + n3;
        if (n > 8) {
            n = 8;
        }
        return n;
    }

    private void printPriceFactor(Resource resource, int n, int n2, float f, ResourcePrices resourcePrices) {
        if (resource == Resource.Smithore) {
            logger.info(resource.name() + " shop: " + this.getResource(resource) + ", mules potentially available: " + n + ", mules needed: " + n2);
        } else {
            logger.info(resource.name() + " shop: " + this.getResource(resource) + ", total: " + n + ", needed: " + n2);
        }
        if (f >= 1.0f) {
            logger.info(resource.getName() + " is increased to " + Math.round(100.0f * f) + "%");
        } else {
            logger.info(resource.getName() + " is decreased to " + Math.round(100.0f * f) + "%");
        }
        logger.info(resource.getName() + " buy price $" + resourcePrices.buyPrice + " sell price $" + resourcePrices.sellPrice);
    }

    public int getPrice(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrices.price;
            }
            case Energy: {
                return this.energyPrices.price;
            }
            case Crystite: {
                return this.crystitePrices.price;
            }
            case Smithore: {
                return this.smithorePrices.price;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int getBuyPrice(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrices.buyPrice;
            }
            case Energy: {
                return this.energyPrices.buyPrice;
            }
            case Crystite: {
                return this.crystitePrices.buyPrice;
            }
            case Smithore: {
                return this.smithorePrices.buyPrice;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int getSellPrice(Resource resource) {
        switch (resource) {
            case Food: {
                return this.foodPrices.sellPrice;
            }
            case Energy: {
                return this.energyPrices.sellPrice;
            }
            case Crystite: {
                return this.crystitePrices.sellPrice;
            }
            case Smithore: {
                return this.smithorePrices.sellPrice;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public int getPriceRange(Resource resource) {
        switch (resource) {
            case Food: {
                return Properties.mule.shopFoodPriceRange;
            }
            case Energy: {
                return Properties.mule.shopEnergyPriceRange;
            }
            case Crystite: {
                return Properties.mule.shopCrystitePriceRange;
            }
            case Smithore: {
                return Properties.mule.shopSmithorePriceRange;
            }
        }
        throw new RuntimeException("Resource " + (Object)((Object)resource) + " doesn't exist.");
    }

    public void buildMules() {
        int n = 2;
        int n2 = Properties.mule.shopStartNumMules - this.numMules;
        int n3 = (n2 = Math.min(n2, Properties.mule.shopMaxBuildMules)) * n;
        if (n3 > this.smithore) {
            n3 = this.smithore - this.smithore % n;
        }
        this.smithore -= n3;
        int n4 = n3 / 2;
        this.numMules += n4;
        this.mulePrice = this.smithorePrices.price * 2;
        this.mulePrice -= this.mulePrice % 10;
        logger.info("Shop built " + n4 + " mules for " + n3 + " smithore and now has " + this.numMules + " mules");
        logger.info("A mule now costs $" + this.mulePrice);
    }

    public Vec2 getNorthEnterance() {
        return northEnterance;
    }

    public Vec2 getSouthEnterance() {
        return southEnterance;
    }

    public Vec2 getEastEnterance() {
        return eastEnterance;
    }

    public Vec2 getWestEnterance() {
        return westEnterance;
    }

    public Vec2 getStartLocation() {
        return startLocation;
    }

    public int getWidth() {
        return 440;
    }

    public int getHeight() {
        return 348;
    }

    public void setAveragePrice(Resource resource, int n, int n2) {
        if (n2 > 0) {
            int n3 = n / n2;
            switch (resource) {
                case Food: {
                    this.foodPrices.setFoodPrice(n3);
                    break;
                }
                case Energy: {
                    this.energyPrices.setEnergyPrice(n3);
                    break;
                }
                case Crystite: {
                    this.crystitePrices.setCrystitePrice(n3);
                    break;
                }
                case Smithore: {
                    this.smithorePrices.setSmithorePrice(n3);
                }
            }
        }
        logger.info((Object)((Object)resource) + " price set to average $" + this.getPrice(resource) + " (" + n2 + " units for $" + n + ")");
    }
}

