/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.logging.Logger;

public class PlotSeller
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private static float[] colonyAuctionProbabilities = new float[]{0.691462f, 0.446211f, 0.216528f};
    private Queue<PlanetTile> playerLandAuctions = new LinkedList<PlanetTile>();
    private PlanetTile colonyAuctionTile = null;
    private int colonyAuctionIndex = -1;
    private int landPrice;
    private int landPriceAccumulator;
    private int auctionSetSize;
    private int landSellPrice;
    private boolean startingAuctionSet;
    private PlanetTile lastBoughtLand;
    private int lastRoundGenerated;
    private Random random;

    public PlotSeller(Random random) {
        this.landPrice = Properties.mule.landAuctionPrice;
        this.landPriceAccumulator = 0;
        this.auctionSetSize = 0;
        this.landSellPrice = 0;
        this.startingAuctionSet = true;
        this.lastRoundGenerated = -1;
        this.random = random;
    }

    public boolean hasAuction() {
        return this.getAuctionTile() != null;
    }

    public int numPlayerAuctions() {
        return this.playerLandAuctions.size();
    }

    public PlanetTile getAuctionTile() {
        if (!this.playerLandAuctions.isEmpty()) {
            return this.playerLandAuctions.peek();
        }
        return this.colonyAuctionTile;
    }

    public int getAuctionPrice() {
        return this.landPrice;
    }

    public boolean hasGeneratedColonyAuctions(int n) {
        return n <= this.lastRoundGenerated;
    }

    public boolean generateNextColonyAuction(PlanetMap planetMap, int n) {
        if (n != this.lastRoundGenerated) {
            this.lastRoundGenerated = n;
            this.colonyAuctionIndex = 0;
            this.startingAuctionSet = true;
        } else {
            ++this.colonyAuctionIndex;
        }
        boolean bl = false;
        Properties.mule.getClass();
        if (this.colonyAuctionIndex < colonyAuctionProbabilities.length) {
            float f = colonyAuctionProbabilities[this.colonyAuctionIndex];
            float f2 = this.random.nextFloat();
            boolean bl2 = bl = f2 <= f;
        }
        if (Properties.mule.testLandAuction) {
            // empty if block
        }
        if (bl) {
            int n2;
            ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>(planetMap.getXSize() * planetMap.getYSize());
            PlanetTile planetTile = planetMap.getShopTile();
            for (n2 = Properties.mule.debugTutorial; n2 < planetMap.getXSize(); ++n2) {
                for (int i = 0; i < planetMap.getYSize(); ++i) {
                    PlanetTile planetTile2 = (PlanetTile)planetMap.getTile(n2, i);
                    if (planetTile2.getOwner() != null || planetTile2 == planetTile) continue;
                    arrayList.add(planetTile2);
                }
            }
            if (arrayList.size() > 0) {
                n2 = this.random.nextInt(arrayList.size());
                this.colonyAuctionTile = (PlanetTile)arrayList.get(n2);
            } else {
                bl = false;
            }
        }
        if (bl) {
            logger.info("Colony sells plot #" + (this.colonyAuctionIndex + 1));
        } else {
            logger.info("Colony doesn't sell a plot");
        }
        return bl;
    }

    public boolean beginAuction(GameModel gameModel) {
        if (!this.hasAuction()) {
            return false;
        }
        if (this.startingAuctionSet) {
            logger.info("Starting auction set");
            if (this.auctionSetSize > 0) {
                this.landPrice = this.landPriceAccumulator / this.auctionSetSize - 60;
                this.landPriceAccumulator = 0;
                this.auctionSetSize = 0;
            }
        } else {
            this.landPrice = this.landSellPrice - 60;
        }
        this.landPrice = Math.max(this.landPrice, 80);
        this.landPrice = MuleMath.closest(this.landPrice, 4);
        logger.info("Land auction price: $" + this.landPrice);
        return true;
    }

    public boolean finishAuction(Player player, int n, PlanetMap planetMap) {
        boolean bl;
        PlanetTile planetTile;
        PlanetTile planetTile2 = planetTile = this.playerLandAuctions.isEmpty() ? this.colonyAuctionTile : this.playerLandAuctions.poll();
        if (player != null && player.getMoney() >= n) {
            player.setMoney(player.getMoney() - n);
            Player player2 = planetTile.getOwner();
            if (player2 != null) {
                player2.setMoney(player2.getMoney() + n);
            }
            planetTile.setOwner(planetMap, player);
            this.landSellPrice = n;
            this.lastBoughtLand = planetTile;
            bl = true;
        } else {
            this.landSellPrice = this.landPrice / 2 + 52;
            bl = false;
        }
        ++this.auctionSetSize;
        this.landPriceAccumulator += this.landSellPrice;
        this.startingAuctionSet = false;
        planetTile.setForSale(false);
        return bl;
    }

    public boolean sellLand(Player player, PlanetTile planetTile) {
        if (planetTile == null) {
            return false;
        }
        if (planetTile.isForSale()) {
            return false;
        }
        if (planetTile.getOwner() != player) {
            return false;
        }
        planetTile.setForSale(true);
        this.playerLandAuctions.add(planetTile);
        this.startingAuctionSet = true;
        planetTile.getOwner().setSellLand(false);
        return true;
    }

    public PlanetTile getLastBoughtLand() {
        return this.lastBoughtLand;
    }

    public void clearAuctions() {
        this.playerLandAuctions.clear();
        this.colonyAuctionTile = null;
    }
}

