/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.FollowActor;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.MuleEquipment;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.view.ActorSprite;
import com.turborilla.mule.view.ViewProperties;
import java.util.logging.Logger;

public class Mule
extends FollowActor {
    private static final long serialVersionUID = 1656293308021819801L;
    private static Logger logger = Logger.getLogger("mule");
    private Player owner;
    private MuleEquipment equipment;
    private float outfitTime;
    private boolean drawEquipment;
    private float outfitStartY;
    private static float outfitRangeY = 50.0f;

    Mule(Player player) {
        super(player.getAvatar(), 22);
        this.owner = player;
        this.equipment = null;
        this.outfitTime = 0.0f;
        this.drawEquipment = false;
        this.createSprites();
        this.clearPositions();
    }

    Mule(Player player, Factory factory) {
        this(player);
        Avatar avatar = player.getAvatar();
        LabItem labItem = factory.getLabItem();
        this.setEquipment(new MuleEquipment(this, avatar.getColorIndex(), factory.getResource(), labItem));
    }

    public void createSprites() {
        this.setSmallSprite(ActorSprite.createMule(false));
        this.setBigSprite(ActorSprite.createMule(true));
        this.setDirection(ActorSprite.Direction.South);
    }

    public strictfp void update() {
        if (this.followedAvatar == null) {
            this.position.set(this.position.x + this.getDirection().vector.x * Properties.mule.landMovingSpeed * Properties.mule.delta, this.position.y + this.getDirection().vector.y * Properties.mule.landMovingSpeed * Properties.mule.delta);
        } else if (this.outfitTime > 0.0f) {
            float f = 1.0f - this.outfitTime / Properties.mule.outfitMuleTime;
            this.position.y = this.outfitStartY - 2.0f * outfitRangeY * (f - 2.0f * Math.max(0.0f, f - 0.5f));
            if (f > 0.5f && !this.drawEquipment) {
                this.drawEquipment = true;
            }
            this.outfitTime -= Properties.mule.delta;
            if (this.outfitTime < 0.0f) {
                this.outfitTime = 0.0f;
            }
        } else {
            this.updateFollow();
        }
    }

    public Resource getResource() {
        return this.equipment == null ? null : this.equipment.getResource();
    }

    public MuleEquipment getEquipment() {
        return this.equipment;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setInShop(boolean bl) {
        this.inShop = bl;
    }

    public void runAway() {
        logger.info("Mule runs away for " + this.owner);
        this.owner.getAvatar().setMule(null);
        this.followedAvatar = null;
        this.getSprite().setIdle(false);
        if (this.isInShop()) {
            this.inShop = false;
        }
        if (this.position.x > (float)(ViewProperties.get().screenWidth / 2)) {
            this.setDirection(ActorSprite.Direction.East);
        } else {
            this.setDirection(ActorSprite.Direction.West);
        }
    }

    public boolean isRunningAway() {
        return this.followedAvatar == null;
    }

    public boolean isOutsideMap() {
        if (!this.isInShop()) {
            ViewProperties viewProperties = ViewProperties.get();
            float f = this.position.x + (float)viewProperties.mapOffsetX;
            if (f < -8.0f || f > (float)(viewProperties.screenWidth + 8)) {
                return true;
            }
        }
        return false;
    }

    public void setEquipment(MuleEquipment muleEquipment) {
        this.equipment = muleEquipment;
        if (this.equipment == null) {
            this.outfitTime = 0.0f;
            this.drawEquipment = false;
        } else {
            this.drawEquipment = true;
        }
    }

    public void outfit(MuleEquipment muleEquipment) {
        this.equipment = muleEquipment;
        this.outfitTime = Properties.mule.outfitMuleTime;
        this.position.x = this.followedAvatar.getPosition().x;
        this.outfitStartY = Math.max(this.position.y, this.followedAvatar.getPosition().y + outfitRangeY);
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i].x = this.position.x;
        }
        this.setDirection(ActorSprite.Direction.North);
        this.getSprite().setIdle(false);
        this.drawEquipment = false;
    }

    public boolean isEquipmentVisible() {
        return this.drawEquipment;
    }

    public boolean isOutfitting() {
        return this.outfitTime > 0.0f;
    }

    public Building createBuilding(PlanetTile planetTile) {
        if (this.equipment == null) {
            return null;
        }
        Resource resource = this.equipment.getResource();
        LabItem labItem = this.equipment.getLabItem();
        Factory factory = new Factory(resource, planetTile, labItem);
        return factory;
    }
}

