/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LabItem {
    NONE(0, 0, 0, "Cancel"),
    DEPOT(Properties.mule.depotPrice, Properties.mule.depotRound, Properties.mule.depotRank, "Depot"),
    WATER_TANK(Properties.mule.waterTankPrice, Properties.mule.waterTankRound, Properties.mule.waterTankRank, "Water Tank"),
    POWER_PLANT(Properties.mule.powerPlantPrice, Properties.mule.powerPlantRound, Properties.mule.powerPlantRank, "Power Plant"),
    MINING_TOWER(Properties.mule.miningTowerPrice, Properties.mule.miningTowerRound, Properties.mule.miningTowerRank, "Mining Tower");

    public final int price;
    public final String menuName;
    public final int round;
    public final int rank;

    private LabItem(int n2, int n3, int n4, String string2) {
        this.price = n2;
        this.round = n3;
        this.rank = n4;
        this.menuName = string2;
    }

    public boolean isAvailableFor(Player player, int n, int n2) {
        if (player.getMoney() < this.price) {
            return false;
        }
        int n3 = player.getRank() + Properties.mule.maxNumPlayers - n2;
        if (n3 < this.rank) {
            return false;
        }
        if (n < this.round) {
            return false;
        }
        switch (this) {
            case DEPOT: {
                return !player.hasDepot();
            }
            case NONE: {
                return true;
            }
        }
        return true;
    }

    public static LabItem get(int n) {
        if (n < 0 || n > LabItem.values().length) {
            return NONE;
        }
        return LabItem.values()[n];
    }

    public static String getDescription() {
        return "No description";
    }

    public String getMenuName() {
        return this.menuName;
    }
}

