/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.TargetPlayerController;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Hireling;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Race;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.map.Building;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HirelingManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private ArrayList<Hireling> hirelings;
    private int selection;
    private Resource humanoidBonusResource;
    private Random random;
    private ArrayList<TargetPlayerController> targetControllers;

    public HirelingManager(Random random) {
        this.random = random;
        this.hirelings = new ArrayList();
        for (Race race : Race.races) {
            this.hirelings.add(new Hireling(race));
        }
        this.targetControllers = new ArrayList();
    }

    public void reset() {
        this.selection = this.hirelings.size() / 2;
        for (int i = 0; i < this.hirelings.size(); ++i) {
            Hireling hireling = this.hirelings.get(i);
            hireling.setHired(false);
            Avatar avatar = hireling.getAvatar();
            avatar.setPosition(80 + 40 * i, 165.0f);
            avatar.setInShop(true);
            avatar.getSprite().setAlwaysIdleSouth(true);
        }
    }

    public ArrayList<Hireling> getHirelings() {
        return this.hirelings;
    }

    public void moveSelection(ActorSprite.Direction direction) {
        int n = 0;
        if (direction == ActorSprite.Direction.East) {
            n = 1;
        } else if (direction == ActorSprite.Direction.West) {
            n = -1;
        }
        if (n == 0) {
            return;
        }
        do {
            this.selection = (this.selection + n + this.hirelings.size()) % this.hirelings.size();
        } while (this.hirelings.get(this.selection).isHired());
    }

    public Hireling getSelectedHireling() {
        return this.hirelings.get(this.selection);
    }

    public ArrayList<TargetPlayerController> getTargetControllers() {
        return this.targetControllers;
    }

    public strictfp void hireSelected(Player player, PlanetMap planetMap) {
        Hireling hireling = this.getSelectedHireling();
        hireling.setHired(true);
        Race race = hireling.getAvatar().getRace();
        Avatar avatar = player.getAvatar();
        avatar.setRace(race);
        avatar.setPosition(hireling.getAvatar().getPosition());
        avatar.setInShop(true);
        if (race.equals("humanoid")) {
            float f = (float)Properties.mule.humanoidBonusProbability * 0.01f;
            this.humanoidBonusResource = this.random.nextFloat() <= f ? Resource.get(this.random.nextInt(4)) : null;
            logger.info("Humanoid bonus resource: " + (Object)((Object)this.humanoidBonusResource));
        }
        TargetPlayerController targetPlayerController = new TargetPlayerController(avatar);
        Vec2 vec2 = new Vec2(avatar.getPosition());
        vec2.y += 25.0f;
        targetPlayerController.addTarget(vec2);
        this.targetControllers.add(targetPlayerController);
        Building.calcBonuses(player, planetMap, this);
        this.moveSelection(ActorSprite.Direction.East);
    }

    public void clearTargetControllers() {
        this.targetControllers.clear();
    }

    public void walkToPub() {
        Vec2 vec2 = new Vec2(284.0f, 165.0f);
        Vec2 vec22 = new Vec2(284.0f, 237.0f);
        Vec2[] vec2Array = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(16.0f, 0.0f), new Vec2(0.0f, 13.0f), new Vec2(16.0f, 13.0f), new Vec2(0.0f, 26.0f), new Vec2(16.0f, 26.0f), new Vec2(0.0f, 39.0f), new Vec2(16.0f, 39.0f)};
        int n = 0;
        for (Hireling hireling : this.hirelings) {
            if (hireling.isHired()) continue;
            TargetPlayerController targetPlayerController = new TargetPlayerController(hireling.getAvatar());
            targetPlayerController.addTarget(vec2).add(vec2Array[n].x, 0.0f);
            targetPlayerController.addTarget(vec22).add(vec2Array[n]);
            this.targetControllers.add(targetPlayerController);
            ++n;
        }
    }

    public boolean hasHumanoidBonusResource() {
        return this.humanoidBonusResource != null;
    }

    public Resource getHumanoidBonusResource() {
        return this.humanoidBonusResource;
    }
}

