/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.util.Vec2;
import java.io.Serializable;

public strictfp abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract GeometryType getType();

    public abstract boolean contains(Vec2 var1, float var2, float var3);

    public boolean intersects(Vec2 vec2, float f, float f2, Geometry geometry) {
        Geometry geometry2 = this;
        Geometry geometry3 = geometry;
        if (geometry2.getType().ordinal() > geometry3.getType().ordinal()) {
            geometry2 = geometry;
            geometry3 = this;
        }
        if (geometry2.getType() == GeometryType.Circle && geometry3.getType() == GeometryType.Rectangle) {
            Circle circle = (Circle)geometry2;
            Rectangle rectangle = (Rectangle)geometry3;
            float f3 = rectangle.halfWidth + circle.radius;
            float f4 = rectangle.halfHeight + circle.radius;
            if (vec2.x < f - f3) {
                return false;
            }
            if (vec2.x > f + f3) {
                return false;
            }
            if (vec2.y < f2 - f4) {
                return false;
            }
            return !(vec2.y > f2 + f4);
        }
        throw new RuntimeException("Geometry intersection not implemented yet");
    }

    public strictfp static class Rectangle
    extends Geometry {
        private static final long serialVersionUID = 1L;
        float halfWidth;
        float halfHeight;
        boolean hollow;

        public static Collidable createCollidable(float f, float f2, float f3, float f4) {
            return new Collidable(f + f3 / 2.0f, f2 + f4 / 2.0f, new Rectangle(f3 / 2.0f, f4 / 2.0f, false));
        }

        public Rectangle(float f, float f2, boolean bl) {
            this.halfWidth = f;
            this.halfHeight = f2;
            this.hollow = bl;
        }

        public GeometryType getType() {
            return GeometryType.Rectangle;
        }

        public float getHalfWidth() {
            return this.halfWidth;
        }

        public void setHalfWidth(float f) {
            this.halfWidth = f;
        }

        public float getHalfHeight() {
            return this.halfHeight;
        }

        public void setHalfHeight(float f) {
            this.halfHeight = f;
        }

        public boolean isHollow() {
            return this.hollow;
        }

        public float getWidth() {
            return 2.0f * this.halfWidth;
        }

        public float getHeight() {
            return 2.0f * this.halfHeight;
        }

        public boolean contains(Vec2 vec2, float f, float f2) {
            if (vec2.x < f - this.halfWidth) {
                return false;
            }
            if (vec2.x > f + this.halfWidth) {
                return false;
            }
            if (vec2.y < f2 - this.halfHeight) {
                return false;
            }
            return !(vec2.y > f2 + this.halfHeight);
        }
    }

    public strictfp static class Circle
    extends Geometry {
        private static final long serialVersionUID = 1L;
        float radius;

        public Circle(float f) {
            this.radius = f;
        }

        public GeometryType getType() {
            return GeometryType.Circle;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float f) {
            this.radius = f;
        }

        public boolean contains(Vec2 vec2, float f, float f2) {
            float f3 = vec2.x - f;
            float f4 = vec2.y - f2;
            return f3 * f3 + f4 * f4 <= this.radius * this.radius;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum GeometryType {
        Circle,
        Rectangle;

    }
}

