/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.ActorSprite;

public abstract class FollowActor
extends Actor {
    private static final long serialVersionUID = 1L;
    protected Avatar followedAvatar;
    protected Vec2[] positions;
    private int circularIndex;
    private Vec2 oldPosition = new Vec2();
    private Vec2 newPosition = new Vec2();
    private Vec2 velocity = new Vec2();
    protected boolean inShop;

    public FollowActor(Avatar avatar, int n) {
        if (avatar != null) {
            this.followedAvatar = avatar;
            this.inShop = avatar.isInShop();
        }
        this.positions = new Vec2[n];
        for (int i = 0; i < n; ++i) {
            this.positions[i] = new Vec2();
        }
    }

    protected void updateFollow() {
        if (this.followedAvatar == null) {
            return;
        }
        if (this.inShop != this.followedAvatar.isInShop()) {
            this.clearPositions();
            this.inShop = this.followedAvatar.isInShop();
        }
        if (this.followedAvatar.isIdle()) {
            this.getSprite().setIdle(true);
        } else {
            this.oldPosition.set(this.position);
            if (this.positions.length > 0) {
                this.setPosition(this.positions[this.circularIndex]);
                int n = this.circularIndex - 1;
                if (n < 0) {
                    n = this.positions.length - 1;
                }
                if (this.positions[n].equals(this.followedAvatar.getPosition())) {
                    this.getSprite().setIdle(true);
                } else {
                    this.positions[this.circularIndex].set(this.followedAvatar.getPosition());
                    ++this.circularIndex;
                    if (this.circularIndex >= this.positions.length) {
                        this.circularIndex = 0;
                    }
                    this.newPosition.set(this.position);
                    this.velocity.set(this.newPosition);
                    this.velocity.sub(this.oldPosition);
                    if (this.velocity.lengthSquared() > Float.MIN_VALUE) {
                        this.setDirection(ActorSprite.Direction.get(this.velocity.x, this.velocity.y));
                        this.getSprite().setIdle(false);
                    } else {
                        this.getSprite().setIdle(true);
                    }
                }
            } else {
                this.setPosition(this.followedAvatar.getPosition());
                this.setDirection(this.followedAvatar.getDirection());
            }
        }
    }

    protected void clearPositions() {
        this.circularIndex = 0;
        if (this.followedAvatar != null) {
            this.setPosition(this.followedAvatar.getPosition());
            this.setDirection(this.followedAvatar.getDirection());
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i].set(this.followedAvatar.getPosition());
            }
        }
    }

    public boolean isInShop() {
        return this.inShop;
    }
}

