/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Timer;
import java.io.Serializable;
import java.util.logging.Logger;

public class Development
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private GameModel model;
    private int playerIndex;
    private int order;
    private Timer developmentTimer;

    Development(GameModel gameModel) {
        this.model = gameModel;
        this.playerIndex = -1;
        this.order = 1;
        this.developmentTimer = new DevelopmentTimer();
    }

    public void setPlayerOrder() {
        int n = this.model.getShop().numMules();
        if (this.model.getShop().numMules() <= 7) {
            this.playerIndex = this.model.getPlayers().size();
            this.order = -1;
            logger.info("Reverse development order. " + n + " mules.");
        } else {
            this.playerIndex = -1;
            this.order = 1;
            logger.info("Normal development order. " + n + " mules.");
        }
    }

    public Player nextPlayer() {
        int n = this.model.getPlayers().size();
        this.playerIndex += this.order;
        if (this.playerIndex < 0) {
            this.playerIndex = n - 1;
        }
        if (this.playerIndex >= n) {
            this.playerIndex = 0;
        }
        logger.info("Development moving to next player: " + this.playerIndex);
        return this.getCurrentPlayer();
    }

    public boolean hasCurrentPlayer() {
        return this.playerIndex >= 0 && this.playerIndex < this.model.getPlayersInRankOrder().size();
    }

    public Player getCurrentPlayer() {
        return this.model.getPlayersInRankOrder().get(this.playerIndex);
    }

    public boolean isLastPlayer() {
        if (this.order > 0) {
            int n = this.model.getPlayers().size();
            return this.playerIndex == n - 1;
        }
        return this.playerIndex == 0;
    }

    public int numPlayersLeft() {
        int n = this.model.getPlayers().size();
        if (!this.hasCurrentPlayer()) {
            return n;
        }
        if (this.order > 0) {
            return n - this.playerIndex;
        }
        return this.playerIndex + 1;
    }

    public Timer getDevelopmentTimer() {
        return this.developmentTimer;
    }

    public float getTimeLeft() {
        return this.developmentTimer.getTime();
    }

    private static class DevelopmentTimer
    extends Timer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private DevelopmentTimer() {
        }
    }
}

