/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.Properties;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.GameModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyEventGenerator
implements Serializable {
    private static final long serialVersionUID = -7046956227365301012L;
    private ArrayList<ColonyEvent.Type> events;
    private ColonyEvent current;

    public ColonyEvent.Type getEventType(GameModel gameModel) {
        return this.events.get(gameModel.getRound());
    }

    public ColonyEvent createEvent(GameModel gameModel) {
        ColonyEvent.Type type = this.getEventType(gameModel);
        this.current = new ColonyEvent(type, gameModel);
        return this.current;
    }

    public ColonyEvent getCurrentEvent() {
        return this.current;
    }

    public void generate(GameModel gameModel) {
        int n;
        ArrayList<ColonyEvent.Type> arrayList = new ArrayList<ColonyEvent.Type>(20);
        this.add(arrayList, ColonyEvent.Type.PIRATE_SHIP, 2);
        this.add(arrayList, ColonyEvent.Type.ACID_RAIN_STORM, 3);
        this.add(arrayList, ColonyEvent.Type.SUNSPOT_ACTIVITY, 3);
        this.add(arrayList, ColonyEvent.Type.FIRE_IN_STORE, 2);
        Collections.shuffle(arrayList, gameModel.getRandom());
        Collections.shuffle(arrayList, gameModel.getRandom());
        this.events = new ArrayList(20);
        this.events.add(null);
        int n2 = 2;
        for (int i = 0; i < n2; ++i) {
            this.events.add(arrayList.get(i));
        }
        ArrayList<ColonyEvent.Type> arrayList2 = new ArrayList<ColonyEvent.Type>(20);
        for (n = n2; n < arrayList.size(); ++n) {
            arrayList2.add(arrayList.get(n));
        }
        arrayList = null;
        this.add(arrayList2, ColonyEvent.Type.PEST_ATTACK, 3);
        this.add(arrayList2, ColonyEvent.Type.PLANET_QUAKE, 3);
        this.add(arrayList2, ColonyEvent.Type.METEORITE_STRIKE, 2);
        this.add(arrayList2, ColonyEvent.Type.RADIATION, 2);
        Collections.shuffle(arrayList2, gameModel.getRandom());
        Collections.shuffle(arrayList2, gameModel.getRandom());
        for (n = 0; n < arrayList2.size(); ++n) {
            this.events.add(arrayList2.get(n));
        }
        this.events.set(gameModel.getGameInfo().getLastRound(), ColonyEvent.Type.SHIP_RETURNS);
        Properties.mule.getClass();
    }

    private void add(ArrayList<ColonyEvent.Type> arrayList, ColonyEvent.Type type, int n) {
        for (int i = 0; i < n; ++i) {
            arrayList.add(type);
        }
    }

    public void debugSetAllEvents(ColonyEvent.Type type) {
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.set(i, type);
        }
    }
}

