/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.HirelingManager;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Logger;

public strictfp final class ColonyEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    public final Type type;
    public final int round;
    public final PlanetTile tile;
    private PlanetTile secondaryTile;
    private boolean applicable;

    public ColonyEvent(Type type, GameModel gameModel) {
        this.type = type;
        this.round = gameModel.getRound();
        this.applicable = true;
        Random random = gameModel.getRandom();
        block0 : switch (type) {
            case PEST_ATTACK: {
                int n;
                ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>();
                ArrayList<Player> arrayList2 = gameModel.getPlayersInRankOrder();
                for (n = 0; n < Math.min(1, arrayList2.size()); ++n) {
                    for (PlanetTile planetTile : arrayList2.get(n).getOwnedTiles()) {
                        Factory factory = planetTile.getFactoryWithResource(Resource.Food);
                        if (factory == null || factory.getProduction() <= 0) continue;
                        arrayList.add(planetTile);
                    }
                }
                if (arrayList.size() == 0) {
                    this.tile = null;
                    this.applicable = false;
                    break;
                }
                n = random.nextInt(arrayList.size());
                this.tile = (PlanetTile)arrayList.get(n);
                break;
            }
            case RADIATION: {
                int n;
                ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>();
                ArrayList<Player> arrayList3 = gameModel.getPlayersInRankOrder();
                for (n = 0; n < Math.min(1, arrayList3.size()); ++n) {
                    for (PlanetTile planetTile : arrayList3.get(n).getOwnedTiles()) {
                        if (planetTile.getFactory() == null) continue;
                        arrayList.add(planetTile);
                    }
                }
                if (arrayList.size() == 0) {
                    this.tile = null;
                    this.applicable = false;
                    break;
                }
                n = random.nextInt(arrayList.size());
                this.tile = (PlanetTile)arrayList.get(n);
                break;
            }
            case ACID_RAIN_STORM: {
                PlanetMap planetMap = gameModel.getMap();
                int n = random.nextInt(planetMap.getXSize());
                int n2 = random.nextInt(planetMap.getYSize());
                this.tile = (PlanetTile)planetMap.getTile(n, n2);
                break;
            }
            case METEORITE_STRIKE: {
                int n;
                int n3;
                PlanetTile planetTile;
                PlanetMap planetMap = gameModel.getMap();
                while ((planetTile = (PlanetTile)planetMap.getTile(n3 = random.nextInt(planetMap.getXSize()), n = random.nextInt(planetMap.getYSize()))).getCrystite() > 2 || planetTile.getType() == PlanetTile.PlanetTileType.Shop || planetTile.getType() == PlanetTile.PlanetTileType.River) {
                }
                this.tile = planetTile;
                break;
            }
            case PLANET_QUAKE: {
                if (random.nextFloat() < 0.5f) {
                    ArrayList<PlanetTile> arrayList = new ArrayList<PlanetTile>();
                    PlanetMap planetMap = gameModel.getMap();
                    for (int i = 0; i < planetMap.getYSize(); ++i) {
                        for (int j = 0; j < planetMap.getXSize(); ++j) {
                            PlanetTile planetTile = (PlanetTile)planetMap.getTile(j, i);
                            if (planetTile.findLastTileBit("1mountain") == null || planetTile.getOwner() != null && planetTile.getOwner().getRank() != 1) continue;
                            arrayList.add(planetTile);
                        }
                    }
                    Collections.shuffle(arrayList, gameModel.getRandom());
                    PlanetTile planetTile = null;
                    PlanetTile planetTile2 = null;
                    boolean bl = false;
                    PlanetTile[] planetTileArray = new PlanetTile[2];
                    for (PlanetTile planetTile3 : arrayList) {
                        int n = planetTile3.getPosX();
                        int n4 = planetTile3.getPosY();
                        int n5 = random.nextFloat() < 0.5f ? -1 : 1;
                        planetTileArray[0] = (PlanetTile)planetMap.getTile(n - n5, n4);
                        planetTileArray[1] = (PlanetTile)planetMap.getTile(n + n5, n4);
                        for (PlanetTile planetTile4 : planetTileArray) {
                            if (planetTile4 == null || planetTile4.getType() != PlanetTile.PlanetTileType.Plain) continue;
                            planetTile = planetTile3;
                            planetTile2 = planetTile4;
                            if (planetTile4.getOwner() != null) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        break;
                    }
                    this.tile = planetTile;
                    this.secondaryTile = planetTile2;
                    break;
                }
                this.tile = null;
                this.secondaryTile = null;
                break;
            }
            case SUNSPOT_ACTIVITY: {
                this.tile = null;
                this.secondaryTile = null;
                this.applicable = false;
                for (Player player : gameModel.getPlayers()) {
                    for (PlanetTile planetTile : player.getOwnedTiles()) {
                        Factory factory = planetTile.getFactoryWithResource(Resource.Energy);
                        if (factory == null || factory.getYieldPotential() == 0) continue;
                        this.applicable = true;
                        break;
                    }
                    if (!this.applicable) continue;
                    break block0;
                }
                break;
            }
            case SHIP_RETURNS: {
                this.tile = null;
                this.secondaryTile = null;
                break;
            }
            default: {
                this.tile = null;
                this.secondaryTile = null;
            }
        }
    }

    public void applyEvent(GameModel gameModel) {
        Shop shop = gameModel.getShop();
        PlanetMap planetMap = gameModel.getMap();
        HirelingManager hirelingManager = gameModel.getHirelingManager();
        switch (this.type) {
            case PIRATE_SHIP: {
                for (Player player : gameModel.getPlayers()) {
                    if (!player.hasDepot()) {
                        player.setCrystite(0);
                    }
                    for (PlanetTile planetTile : player.getOwnedTiles()) {
                        Factory factory = planetTile.getFactoryWithResource(Resource.Crystite);
                        if (factory == null) continue;
                        factory.setProduction(0);
                    }
                }
                break;
            }
            case FIRE_IN_STORE: {
                shop.setFood(0);
                shop.setEnergy(0);
                shop.setSmithore(0);
                break;
            }
            case METEORITE_STRIKE: {
                this.tile.removeBuildings(planetMap, hirelingManager);
                this.tile.setCrystite(4);
                this.tile.getCollisionSet().clear();
                this.tile.clearTileBits();
                this.tile.setType(PlanetTile.PlanetTileType.Crater);
                this.tile.setIdentifier(PlanetTile.PlanetTileType.Crater.identifier, 0);
                for (AbstractAI abstractAI : gameModel.getAiSystem().getAIs()) {
                    abstractAI.meteoriteStrike(this.tile);
                }
                break;
            }
            case RADIATION: {
                if (this.tile == null) break;
                logger.info("Radiation strikes " + this.tile.getOwner() + " " + this.tile);
                this.tile.removeBuildings(planetMap, hirelingManager);
                break;
            }
            case SUNSPOT_ACTIVITY: {
                for (Player player : gameModel.getPlayers()) {
                    for (PlanetTile planetTile : player.getOwnedTiles()) {
                        Factory factory = planetTile.getFactoryWithResource(Resource.Energy);
                        if (factory == null || factory.getYieldPotential() == 0) continue;
                        factory.setTemporaryBonus(factory.getTemporaryBonus() + 3);
                    }
                }
                break;
            }
            case ACID_RAIN_STORM: {
                int n = this.tile.getPosY();
                for (int i = 0; i < planetMap.getYSize(); ++i) {
                    for (int j = 0; j < planetMap.getXSize(); ++j) {
                        Factory factory = ((PlanetTile)planetMap.getTile(j, i)).getFactory();
                        if (factory == null || factory.getYieldPotential() == 0) continue;
                        if (factory.getResource() == Resource.Food) {
                            if (i == n) {
                                factory.setTemporaryBonus(factory.getTemporaryBonus() + 4);
                                continue;
                            }
                            factory.setTemporaryBonus(factory.getTemporaryBonus() + 1);
                            continue;
                        }
                        if (factory.getResource() != Resource.Energy) continue;
                        if (i == n) {
                            factory.setTemporaryBonus(factory.getTemporaryBonus() - 2);
                            continue;
                        }
                        factory.setTemporaryBonus(factory.getTemporaryBonus() - 1);
                    }
                }
                break;
            }
            case PEST_ATTACK: {
                if (this.tile == null) break;
                this.tile.getFactory().setProduction(0);
                break;
            }
            case PLANET_QUAKE: {
                for (Player player : gameModel.getPlayers()) {
                    for (PlanetTile planetTile : player.getOwnedTiles()) {
                        Factory factory = planetTile.getFactoryWithResource(Resource.Smithore, Resource.Crystite);
                        if (factory == null) continue;
                        factory.setProduction(factory.getProduction() / 2);
                    }
                }
                if (this.tile == null) break;
                this.tile.removeBuildings(planetMap, hirelingManager);
                this.secondaryTile.removeBuildings(planetMap, hirelingManager);
                if (this.tile.getType() == PlanetTile.PlanetTileType.Mountain1) {
                    this.tile.setType(PlanetTile.PlanetTileType.Plain);
                } else if (this.tile.getType() == PlanetTile.PlanetTileType.Mountain2) {
                    this.tile.setType(PlanetTile.PlanetTileType.Mountain1);
                } else if (this.tile.getType() == PlanetTile.PlanetTileType.Mountain3) {
                    this.tile.setType(PlanetTile.PlanetTileType.Mountain2);
                }
                this.secondaryTile.setType(PlanetTile.PlanetTileType.Mountain1);
                this.tile.getCollisionSet().clear();
                this.secondaryTile.getCollisionSet().clear();
                this.tile.constructCollidables(planetMap.getSkin());
                this.secondaryTile.constructCollidables(planetMap.getSkin());
                break;
            }
            case SHIP_RETURNS: {
                break;
            }
            default: {
                logger.severe("Random event effect not implemented yet: " + (Object)((Object)this.type));
            }
        }
    }

    public boolean isCategoryA() {
        return this.type.categoryA;
    }

    public String getEventName() {
        return this.type.name;
    }

    public String getEventDescription() {
        return this.type.description;
    }

    public PlanetTile getSecondaryTile() {
        return this.secondaryTile;
    }

    public Type getType() {
        return this.type;
    }

    public PlanetTile getTile() {
        return this.tile;
    }

    public boolean isApplicable() {
        return this.applicable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum Type {
        PEST_ATTACK(false, "Planetary Pest", " - Eats all Food at one Plot"),
        PIRATE_SHIP(false, "Space Pirates", " - Steal all the Colony's Crystite"),
        ACID_RAIN_STORM(true, "Acid Rain", " - Increases Food but decreases Energy production"),
        PLANET_QUAKE(false, "Planetquake", " - Halves all production of Crystite and Smithore"),
        SUNSPOT_ACTIVITY(true, "Sunspot Activity", " - Increases all Energy production"),
        METEORITE_STRIKE(true, "Meteorite Strike", " - Enriches a Plot with Crystite"),
        RADIATION(true, "Radiation", " - Causes a M.U.L.E. to Go Crazy"),
        FIRE_IN_STORE(false, "Fire in Store", " - The whole Stock is Burned"),
        SHIP_RETURNS(false, "Return of the Colonial Ship", "");

        public final boolean categoryA;
        public final String name;
        public final String description;

        private Type(boolean bl, String string2, String string3) {
            this.categoryA = bl;
            this.name = string2;
            this.description = string2 + string3;
        }
    }
}

