/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.network.TCPMessage;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.Logger;

public class AvatarCommandStream
extends PlayerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private static final int BUFFER_FRAMES = 10;
    private long endUpdate;
    private boolean buffering;
    private boolean finished = false;
    private LinkedList<TCPMessage.AvatarActionMessage> actions = new LinkedList();
    private PlayerControllerState state;

    public AvatarCommandStream(PlayerControllerState playerControllerState) {
        this.state = playerControllerState;
        this.endUpdate = -1L;
        this.buffering = true;
        this.state.clear();
    }

    public void add(TCPMessage.AvatarActionMessage avatarActionMessage) {
        if (avatarActionMessage.update < this.endUpdate) {
            logger.severe("New update older than last update");
        } else {
            this.actions.add(avatarActionMessage);
            this.endUpdate = avatarActionMessage.update;
        }
    }

    public void add(TCPMessage.AvatarPassiveMessage avatarPassiveMessage) {
        if (avatarPassiveMessage.update < this.endUpdate) {
            logger.severe("New update older than last update");
        } else {
            this.endUpdate = avatarPassiveMessage.update;
        }
    }

    public void add(TCPMessage.AvatarFinishMessage avatarFinishMessage) {
        if (avatarFinishMessage.update < this.endUpdate) {
            logger.severe("Finish update older than last update");
        }
        this.endUpdate = avatarFinishMessage.update;
        this.buffering = false;
        this.finished = true;
    }

    public boolean update(long l) {
        if (this.buffering) {
            if (this.finished) {
                logger.info("Finished and not allowed to buffer more frames. Update: " + l + ". End Update: " + this.endUpdate + ". We should never get here.");
                this.buffering = false;
            } else {
                if (this.endUpdate - l < 10L) {
                    return false;
                }
                this.buffering = false;
            }
        }
        if (l > this.endUpdate) {
            logger.info("Needs to buffer more frames. Update: " + l + ". End Update: " + this.endUpdate);
            if (this.finished) {
                logger.info("Finished but passed end update. We should never get here.");
            } else {
                this.buffering = true;
                return false;
            }
        }
        this.state.setActionButtonPressed(false);
        if (!this.actions.isEmpty()) {
            TCPMessage.AvatarActionMessage avatarActionMessage = this.actions.getFirst();
            if (avatarActionMessage.update == l) {
                this.state.setUp(avatarActionMessage.up);
                this.state.setDown(avatarActionMessage.down);
                this.state.setLeft(avatarActionMessage.left);
                this.state.setRight(avatarActionMessage.right);
                this.state.setActionButtonPressed(avatarActionMessage.action);
                this.actions.removeFirst();
            }
        }
        return true;
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    public void stopBuffering() {
        this.buffering = false;
    }

    public long getEndUpdate() {
        return this.endUpdate;
    }

    public boolean isActionButtonPressed() {
        return this.state.isActionButtonPressed();
    }

    public boolean isActionButtonDown() {
        return false;
    }

    public boolean isDown() {
        return this.state.isDown();
    }

    public boolean isDownPressed() {
        return false;
    }

    public boolean isLeft() {
        return this.state.isLeft();
    }

    public boolean isLeftPressed() {
        return false;
    }

    public boolean isRight() {
        return this.state.isRight();
    }

    public boolean isRightPressed() {
        return false;
    }

    public boolean isUp() {
        return this.state.isUp();
    }

    public boolean isUpPressed() {
        return false;
    }

    public boolean isRemote() {
        return true;
    }

    public void finish(long l) {
        this.endUpdate = l;
        this.buffering = false;
    }
}

