/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import java.io.Serializable;
import java.util.logging.Logger;

public final class AuctionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private int auctionTick = 0;
    private boolean inAuction = false;
    private boolean walking = false;

    public void setState(boolean bl, int n) {
        this.inAuction = bl;
        this.auctionTick = n;
    }

    public void setState(boolean bl, int n, AuctionLimits auctionLimits, Resource resource, Player player) {
        this.inAuction = bl;
        this.setTick(n, auctionLimits, resource, player);
    }

    public void setTick(int n, AuctionLimits auctionLimits, Resource resource, Player player) {
        if (player.isBuyer()) {
            int n2;
            int n3 = n2 = resource == null ? auctionLimits.getStartMinTick() : auctionLimits.minTick;
            if (this.inAuction) {
                if (n > auctionLimits.auctionSellTick) {
                    n = auctionLimits.auctionSellTick;
                }
                if (auctionLimits.tickToPrice(n) > player.getMoney() && (n = auctionLimits.priceToMaxTick(player.getMoney())) < n2) {
                    n = n2 - 1;
                }
                if (n < n2) {
                    this.inAuction = false;
                    this.setTick(-1, auctionLimits, resource, player);
                    return;
                }
            } else {
                if (n >= 0) {
                    this.inAuction = true;
                    this.setTick(n2 + n, auctionLimits, resource, player);
                    return;
                }
                if (n < -auctionLimits.getMaxOutOfAuctionTicks()) {
                    n = -auctionLimits.getMaxOutOfAuctionTicks();
                }
            }
        } else if (this.isInAuction()) {
            if (n < auctionLimits.auctionBuyTick) {
                n = auctionLimits.auctionBuyTick;
            }
            if (n < auctionLimits.minTick) {
                n = auctionLimits.minTick;
            }
            if (n > auctionLimits.maxTick) {
                this.inAuction = false;
                this.setTick(n - auctionLimits.maxTick, auctionLimits, resource, player);
                return;
            }
        } else {
            if (n <= 0) {
                try {
                    if (player.getResource(resource) == 0) {
                        n = 1;
                        return;
                    }
                }
                catch (RuntimeException runtimeException) {
                    logger.severe("Error" + runtimeException.getMessage());
                }
                this.inAuction = true;
                this.setTick(auctionLimits.maxTick + n, auctionLimits, resource, player);
                return;
            }
            if (n > auctionLimits.getMaxOutOfAuctionTicks()) {
                n = auctionLimits.getMaxOutOfAuctionTicks();
            }
        }
        this.auctionTick = n;
    }

    public boolean moveTowards(AuctionState auctionState, AuctionLimits auctionLimits, Resource resource, Player player) {
        int n;
        if (this.equals(auctionState)) {
            return false;
        }
        if (player.isBuyer()) {
            n = 1;
            if (auctionState.inAuction) {
                int n2;
                int n3 = n2 = resource == null ? auctionLimits.getStartMinTick() : auctionLimits.minTick;
                if (auctionState.auctionTick < n2) {
                    auctionState.inAuction = false;
                    auctionState.auctionTick = -1;
                }
            }
        } else {
            n = -1;
        }
        if (this.inAuction) {
            if (auctionState.inAuction) {
                this.move(auctionState);
            } else {
                this.auctionTick -= n;
            }
        } else if (auctionState.inAuction) {
            this.auctionTick += n;
        } else {
            this.move(auctionState);
        }
        this.setTick(this.auctionTick, auctionLimits, resource, player);
        return true;
    }

    private boolean move(AuctionState auctionState) {
        if (this.auctionTick < auctionState.auctionTick) {
            ++this.auctionTick;
            return true;
        }
        if (this.auctionTick > auctionState.auctionTick) {
            --this.auctionTick;
            return true;
        }
        return false;
    }

    public int getTick() {
        return this.auctionTick;
    }

    public boolean isInAuction() {
        return this.inAuction;
    }

    public int getPrice(AuctionLimits auctionLimits) {
        if (!this.inAuction) {
            return 0;
        }
        return auctionLimits.tickToPrice(this.auctionTick);
    }

    public void copy(AuctionState auctionState) {
        this.inAuction = auctionState.inAuction;
        this.auctionTick = auctionState.auctionTick;
    }

    public boolean isWalking() {
        return this.walking;
    }

    public void setWalking(boolean bl) {
        this.walking = bl;
    }

    public boolean equals(AuctionState auctionState) {
        return this.auctionTick == auctionState.auctionTick && this.inAuction == auctionState.inAuction;
    }

    public int distance(AuctionState auctionState, AuctionLimits auctionLimits, Resource resource) {
        if (this.inAuction) {
            if (auctionState.inAuction) {
                return Math.abs(this.auctionTick - auctionState.auctionTick);
            }
            int n = auctionLimits.getMinTickInAuction(resource);
            return Math.abs(auctionState.auctionTick) + (this.auctionTick - n);
        }
        if (auctionState.inAuction) {
            int n = auctionLimits.getMinTickInAuction(resource);
            return Math.abs(this.auctionTick) + (auctionState.auctionTick - n);
        }
        return Math.abs(this.auctionTick - auctionState.auctionTick);
    }
}

