/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.model;

import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.model.AuctionLimits;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Auction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private AuctionLimits currentLimits;
    private AuctionLimits targetLimits;
    private ArrayList<Player> buyers = new ArrayList(4);
    private ArrayList<Player> sellers = new ArrayList(4);
    private ArrayList<Player> remoteBuyers = new ArrayList(4);
    private ArrayList<Player> remoteSellers = new ArrayList(4);
    private AuctionLimits.TickSetup tickSetupLow = new AuctionLimits.TickSetup(2, 10, 40, 1);
    private AuctionLimits.TickSetup tickSetupHigh = new AuctionLimits.TickSetup(2, 10, 40, 4);

    public void beginAuction(Resource resource, int n, int n2) {
        AuctionLimits.TickSetup tickSetup = resource == Resource.Crystite ? this.tickSetupHigh : this.tickSetupLow;
        this.begin(tickSetup, n, n2);
    }

    public void beginLandAuction(GameModel gameModel, int n, int n2) {
        this.begin(this.tickSetupHigh, n, n2);
        for (AbstractAI abstractAI : gameModel.getAiSystem().getAIs()) {
            abstractAI.beginLandAuction(gameModel);
        }
    }

    private void begin(AuctionLimits.TickSetup tickSetup, int n, int n2) {
        this.currentLimits = new AuctionLimits(n, n2, tickSetup);
        this.targetLimits = new AuctionLimits(n, n2, tickSetup);
        this.buyers.clear();
        this.sellers.clear();
        this.remoteBuyers.clear();
        this.remoteSellers.clear();
    }

    public AuctionLimits getCurrentLimits() {
        return this.currentLimits;
    }

    public AuctionLimits getTargetLimits() {
        return this.targetLimits;
    }

    public ArrayList<Player> getBuyers() {
        return this.buyers;
    }

    public ArrayList<Player> getSellers() {
        return this.sellers;
    }

    public ArrayList<Player> getRemoteBuyers() {
        return this.remoteBuyers;
    }

    public ArrayList<Player> getRemoteSellers() {
        return this.remoteSellers;
    }

    public void setBuyersAndSellers(GameModel gameModel) {
        this.buyers.clear();
        this.sellers.clear();
        this.remoteBuyers.clear();
        this.remoteSellers.clear();
        StringBuilder stringBuilder = new StringBuilder("Auction buyers: ");
        StringBuilder stringBuilder2 = new StringBuilder("Auction sellers: ");
        for (Player player : gameModel.getLocalPlayers()) {
            if (player.isBuyer()) {
                this.buyers.add(player);
                stringBuilder.append(player.toString());
                stringBuilder.append(" ");
                continue;
            }
            this.sellers.add(player);
            stringBuilder2.append(player.toString());
            stringBuilder2.append(" ");
        }
        for (Player player : gameModel.getRemotePlayers()) {
            if (player.isBuyer()) {
                this.buyers.add(player);
                this.remoteBuyers.add(player);
                stringBuilder.append(player.toString());
                stringBuilder.append(" ");
                continue;
            }
            this.sellers.add(player);
            this.remoteSellers.add(player);
            stringBuilder2.append(player.toString());
            stringBuilder2.append(" ");
        }
        logger.info(stringBuilder.toString());
        logger.info(stringBuilder2.toString());
    }

    void removeRemotePlayer(Player player) {
        this.remoteBuyers.remove(player);
        this.remoteSellers.remove(player);
    }
}

