/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.network.MasterResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class UserTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2772411510750952383L;
    private static final String[] columnNames = new String[]{"Player", "Rank"};
    public static final int[] columnWidths = new int[]{200, 85};
    private MasterResponse.RefreshLobby.User[] users;
    private ArrayList<MasterResponse.RefreshLobby.User> waitingUsers;
    private ArrayList<MasterResponse.RefreshLobby.User> playingUsers;
    private HashMap<Long, Boolean> usersPlaying;
    private Comparator<MasterResponse.RefreshLobby.User> userComparator = new Comparator<MasterResponse.RefreshLobby.User>(){

        @Override
        public int compare(MasterResponse.RefreshLobby.User user, MasterResponse.RefreshLobby.User user2) {
            return user.getName().compareToIgnoreCase(user2.getName());
        }
    };

    public UserTableModel() {
        this.users = new MasterResponse.RefreshLobby.User[0];
        this.usersPlaying = new HashMap();
        this.waitingUsers = new ArrayList();
        this.playingUsers = new ArrayList();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this.users.length == 0 ? 0 : this.users.length + 2;
    }

    public Object getValueAt(int n, int n2) {
        if (n == 0) {
            return n2 == 0 ? "Waiting" : "";
        }
        if (--n == this.waitingUsers.size()) {
            return n2 == 0 ? "Playing" : "";
        }
        MasterResponse.RefreshLobby.User user = null;
        if (n < this.waitingUsers.size()) {
            user = this.waitingUsers.get(n);
        } else {
            n -= this.waitingUsers.size();
            user = this.playingUsers.get(--n);
        }
        switch (n2) {
            case 0: {
                return user.getName();
            }
            case 1: {
                int n3 = user.getRank();
                return n3 == 0 ? "-" : " " + n3;
            }
        }
        return "";
    }

    public void setUsers(MasterResponse.RefreshLobby.User[] userArray) {
        this.users = userArray;
        this.waitingUsers.clear();
        this.playingUsers.clear();
        for (MasterResponse.RefreshLobby.User object : userArray) {
            if (this.isPlaying(object)) {
                this.playingUsers.add(object);
                continue;
            }
            this.waitingUsers.add(object);
        }
        Collections.sort(this.waitingUsers, this.userComparator);
        Collections.sort(this.playingUsers, this.userComparator);
        for (TableModelListener tableModelListener : this.getTableModelListeners()) {
            tableModelListener.tableChanged(new TableModelEvent(this));
        }
    }

    public void setGames(MasterResponse.RefreshLobby.Game[] gameArray) {
        this.usersPlaying.clear();
        for (MasterResponse.RefreshLobby.Game game : gameArray) {
            for (long l : game.getUserIds()) {
                this.usersPlaying.put(l, true);
            }
        }
        this.setUsers(this.users);
    }

    private boolean isPlaying(MasterResponse.RefreshLobby.User user) {
        Boolean bl = this.usersPlaying.get(user.getId());
        return bl != null && bl != false;
    }

    public int numWaiting() {
        return this.waitingUsers.size();
    }
}

