/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.MuleUtil;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.GameModelObserver;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Spectator;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.UserStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class UserListModel
implements ListModel,
GameModelObserver {
    private static final long serialVersionUID = 1L;
    private ArrayList<UserItem> users = new ArrayList(10);
    private ArrayList<ListDataListener> listeners = new ArrayList();
    private boolean showRanks = false;

    public void clear() {
        this.showRanks = false;
        this.users.clear();
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.intervalRemoved(new ListDataEvent(this, 2, 0, this.users.size()));
        }
    }

    public Object getElementAt(int n) {
        return this.users.get(n);
    }

    public int getSize() {
        return this.users.size();
    }

    public UserItem getUser(int n) {
        if (n != 0) {
            for (UserItem userItem : this.users) {
                if (userItem.number != n) continue;
                return userItem;
            }
        }
        return null;
    }

    public void notifyEvent(GameModelObserver.Event event, Object ... objectArray) {
        if (event == GameModelObserver.Event.USER_ADDED) {
            User user = (User)objectArray[0];
            UserStatistics userStatistics = user.getStatistics();
            final String string = user.getName();
            final int n = user.getUserNumber();
            final int n2 = user.getColorIndex();
            final boolean bl = user.isSpectator();
            final boolean bl2 = this.isAiPlayer(user);
            final int n3 = userStatistics == null ? 0 : userStatistics.getRank();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserListModel.this.users.add(new UserItem(string, n, n2, bl, bl2, n3));
                    Collections.sort(UserListModel.this.users);
                    for (ListDataListener listDataListener : UserListModel.this.listeners) {
                        listDataListener.intervalAdded(new ListDataEvent(this, 1, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.SET_AI_PLAYER) {
            Player player = (Player)objectArray[0];
            final int n = player.getUserNumber();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Object object : UserListModel.this.users) {
                        if (((UserItem)object).number != n) continue;
                        ((UserItem)object).setAi(true);
                    }
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.USER_REMOVED) {
            User user = (User)objectArray[0];
            final int n = user.getUserNumber();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator iterator = UserListModel.this.users.iterator();
                    while (iterator.hasNext()) {
                        Object object = (UserItem)iterator.next();
                        if (((UserItem)object).number != n) continue;
                        iterator.remove();
                    }
                    Collections.sort(UserListModel.this.users);
                    for (Object object : UserListModel.this.listeners) {
                        object.intervalRemoved(new ListDataEvent(this, 2, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.MY_USER) {
            User user = (User)objectArray[0];
            final int n = user.getUserNumber();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (UserItem userItem : UserListModel.this.users) {
                        if (userItem.number == n) {
                            userItem.myUser = true;
                        }
                        for (ListDataListener listDataListener : UserListModel.this.listeners) {
                            listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                        }
                    }
                }
            });
        } else if (event == GameModelObserver.Event.SERVER_USER) {
            User user = (User)objectArray[0];
            if (user == null) {
                return;
            }
            final int n = user.getUserNumber();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Object object : UserListModel.this.users) {
                        if (((UserItem)object).number == n) {
                            ((UserItem)object).setServer(true);
                            continue;
                        }
                        ((UserItem)object).setServer(false);
                    }
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.PLAYERS_RANK_ORDER_UPDATED) {
            final ArrayList arrayList = (ArrayList)objectArray[0];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!UserListModel.this.showRanks) {
                        return;
                    }
                    for (Object object : arrayList) {
                        UserItem userItem = UserListModel.this.getUser(((User)object).getUserNumber());
                        if (userItem == null) continue;
                        userItem.setRank(((Player)object).getRank());
                    }
                    Collections.sort(UserListModel.this.users);
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.USER_READY) {
            User user = (User)objectArray[0];
            if (user == null) {
                return;
            }
            final int n = user.getUserNumber();
            final boolean bl = (Boolean)objectArray[1];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Object object : UserListModel.this.users) {
                        if (((UserItem)object).number != n) continue;
                        ((UserItem)object).setReady(bl);
                    }
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.GAME_STARTED) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserListModel.this.showRanks = true;
                    for (Object object : UserListModel.this.users) {
                        ((UserItem)object).setReady(false);
                    }
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        } else if (event == GameModelObserver.Event.USER_STATISTICS) {
            User user = (User)objectArray[0];
            if (user == null) {
                return;
            }
            final int n = user.getUserNumber();
            final int n4 = user.getStatistics().getRank();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Object object : UserListModel.this.users) {
                        if (((UserItem)object).number != n) continue;
                        ((UserItem)object).setWebsiteRank(n4);
                    }
                    for (Object object : UserListModel.this.listeners) {
                        object.contentsChanged(new ListDataEvent(this, 0, 0, UserListModel.this.users.size()));
                    }
                }
            });
        }
    }

    private boolean isAiPlayer(User user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            return player.isAiPlayer();
        }
        return false;
    }

    public void observe(GameModel gameModel) {
        this.users.clear();
        UserItem userItem = new UserItem("Players", false);
        userItem.setRank(-1);
        UserItem userItem2 = new UserItem("Visitors", true);
        userItem2.setRank(-1);
        this.users.add(userItem);
        this.users.add(userItem2);
        for (Player user : gameModel.getPlayers()) {
            this.notifyEvent(GameModelObserver.Event.USER_ADDED, user);
        }
        for (Spectator spectator : gameModel.getSpectators()) {
            this.notifyEvent(GameModelObserver.Event.USER_ADDED, spectator);
        }
        User user = gameModel.getMyUser();
        if (user != null) {
            this.notifyEvent(GameModelObserver.Event.MY_USER, user);
        }
        this.notifyEvent(GameModelObserver.Event.SERVER_USER, gameModel.getServerUser());
        this.notifyEvent(GameModelObserver.Event.PLAYERS_RANK_ORDER_UPDATED, gameModel.getPlayersInRankOrder());
        gameModel.addObserver(this);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserItem
    implements Comparable<UserItem> {
        public String text;
        public String name;
        public int number;
        public int colorIndex;
        public boolean myUser;
        private boolean ai;
        private boolean server;
        private int rank;
        private int websiteRank;
        private boolean spectator;
        private boolean ready;

        public UserItem(String string, boolean bl) {
            this.text = string;
            this.name = string;
            this.number = 0;
            this.rank = 0;
            this.spectator = bl;
        }

        public UserItem(String string, int n, int n2, boolean bl, boolean bl2, int n3) {
            this.name = string;
            this.number = n;
            this.colorIndex = n2;
            this.myUser = false;
            this.rank = 0;
            this.websiteRank = n3;
            this.spectator = bl;
            this.ai = bl2;
            this.ready = false;
            this.createText();
        }

        public void setWebsiteRank(int n) {
            this.websiteRank = n;
            this.createText();
        }

        public void setAi(boolean bl) {
            this.ai = bl;
            this.createText();
        }

        public void setReady(boolean bl) {
            this.ready = bl;
            this.createText();
        }

        public boolean isServer() {
            return this.server;
        }

        public void setServer(boolean bl) {
            if (this.server == bl) {
                return;
            }
            this.server = bl;
            this.createText();
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int n) {
            if (this.rank == n) {
                return;
            }
            this.rank = n;
            this.createText();
        }

        private void createText() {
            if (this.number == 0) {
                this.text = " " + this.name;
                return;
            }
            this.text = "  ";
            this.text = this.rank > 0 ? this.text + this.rank + ". " + this.name : this.text + this.name;
            if (this.websiteRank > 0) {
                this.text = this.text + " [" + MuleUtil.ordinalString(this.websiteRank) + "]";
            }
            if (this.spectator && this.ready) {
                this.text = this.text + " (Ready)";
            }
            if (this.server) {
                this.text = this.text + " (Host)";
            }
            if (this.ai) {
                this.text = this.text + " (A.I.)";
            }
        }

        public String toString() {
            return this.text;
        }

        @Override
        public int compareTo(UserItem userItem) {
            if (!this.spectator && userItem.spectator) {
                return -1;
            }
            if (this.spectator && !userItem.spectator) {
                return 1;
            }
            if (this.rank < userItem.rank) {
                return -1;
            }
            if (this.rank > userItem.rank) {
                return 1;
            }
            if (this.number > userItem.number) {
                return -1;
            }
            if (this.number < userItem.number) {
                return 1;
            }
            return 0;
        }
    }
}

