/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.frame.GameKeyMap;
import com.turborilla.mule.frame.SpringUtilities;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MapSkinParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private JButton ok;
    private JButton cancel;
    private JComboBox mapSkins;
    private JComboBox windowSkins;
    private ArrayList<KeyField> keyFields;
    private GameKeyMap keyMap;
    private GameInput input;
    private JCheckBox showAiDevelopment;
    private Color keyFieldBackground;
    private Color keyFieldForeground;
    private ArrayList<SettingsDialogListener> listeners = new ArrayList();

    public SettingsDialog(JFrame jFrame) {
        super(jFrame, "Settings", true);
        this.keyMap = new GameKeyMap();
        ArrayList<String> arrayList = MapSkinParser.findSkins();
        this.keyFields = new ArrayList();
        this.keyFields.add(new KeyField("Button", 4));
        this.keyFields.add(new KeyField("Up", 0));
        this.keyFields.add(new KeyField("Down", 1));
        this.keyFields.add(new KeyField("Left", 2));
        this.keyFields.add(new KeyField("Right", 3));
        this.keyFields.add(new KeyField("Fullscreen", 5));
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(new JLabel("Key"));
        jPanel.add(new JLabel("Primary"));
        jPanel.add(new JLabel("Secondary"));
        for (KeyField object2 : this.keyFields) {
            jPanel.add(object2.getLabel());
            jPanel.add(object2.getTextField(0));
            jPanel.add(object2.getTextField(1));
        }
        jPanel.add(new JLabel("Chat"));
        jPanel.add(new JLabel("Enter"));
        jPanel.add(Box.createHorizontalStrut(1));
        SpringUtilities.makeCompactGrid(jPanel, this.keyFields.size() + 2, 3, 12, 6, 12, 6);
        this.keyFieldBackground = this.keyFields.get(0).getTextField(0).getBackground();
        this.keyFieldForeground = this.keyFields.get(0).getTextField(0).getForeground();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Controls"));
        jPanel2.add(jPanel);
        this.showAiDevelopment = new JCheckBox("Show computer player development (host option)");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new SpringLayout());
        jPanel3.add(this.showAiDevelopment);
        jPanel3.add(Box.createHorizontalGlue());
        SpringUtilities.makeCompactGrid(jPanel3, 1, 2, 12, 6, 12, 6);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Game"));
        jPanel4.add(jPanel3);
        this.mapSkins = new JComboBox<Object>(arrayList.toArray());
        this.windowSkins = new JComboBox<String>(Properties.mule.windowSkins);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new SpringLayout());
        jPanel5.add(new JLabel("Window Skin"));
        jPanel5.add(this.windowSkins);
        jPanel5.add(new JLabel("Map Skin"));
        jPanel5.add(this.mapSkins);
        SpringUtilities.makeCompactGrid(jPanel5, 2, 2, 12, 6, 12, 6);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder("Visual"));
        jPanel6.add(jPanel5);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.ok);
        jPanel7.add(this.cancel);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(jPanel2);
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        this.add(jPanel8);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.applySettings();
                SettingsDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.cancel.requestFocusInWindow();
    }

    public void setInput(GameInput gameInput) {
        this.input = gameInput;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SettingsDialog.this.loadSettings();
                    SettingsDialog.this.applySettings();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.log(Level.SEVERE, invocationTargetException.getTargetException().toString(), invocationTargetException.getTargetException());
            logger.log(Level.SEVERE, invocationTargetException.toString(), invocationTargetException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.toString(), exception);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SettingsDialog.this.loadSettings();
                    SettingsDialog.super.setVisible(true);
                }
            });
        } else {
            super.setVisible(false);
        }
    }

    private void loadSettings() {
        int n;
        Settings settings = Settings.get();
        for (n = 0; n < this.mapSkins.getItemCount(); ++n) {
            String object2 = (String)this.mapSkins.getItemAt(n);
            if (!settings.mapSkin.equalsIgnoreCase(object2)) continue;
            this.mapSkins.setSelectedIndex(n);
        }
        for (n = 0; n < this.windowSkins.getItemCount(); ++n) {
            String string = (String)this.windowSkins.getItemAt(n);
            if (!settings.windowSkin.equalsIgnoreCase(string)) continue;
            this.windowSkins.setSelectedIndex(n);
        }
        for (KeyField keyField : this.keyFields) {
            int n2 = settings.primaryKeys[keyField.getControl()];
            int n3 = settings.secondaryKeys[keyField.getControl()];
            keyField.setKeyCode(0, n2);
            keyField.setKeyCode(1, n3);
        }
        this.showAiDevelopment.setSelected(!settings.fastAiDevelopment);
    }

    private void applySettings() {
        Settings settings = Settings.get();
        Settings settings2 = settings.clone();
        for (KeyField object2 : this.keyFields) {
            int n = object2.getControl();
            settings.primaryKeys[n] = object2.getKeyCode(0);
            settings.secondaryKeys[n] = object2.getKeyCode(1);
        }
        settings.fastAiDevelopment = !this.showAiDevelopment.isSelected();
        String string = this.mapSkins.getSelectedItem().toString();
        String string2 = this.windowSkins.getSelectedItem().toString();
        if (!settings.mapSkin.equalsIgnoreCase(string)) {
            logger.info("Changing map skin to " + (String)string);
            settings.mapSkin = string;
        }
        if (!settings.windowSkin.equals(string2)) {
            JOptionPane.showMessageDialog(this, "Window skin settings will be applied the next time you start the game.");
            settings.windowSkin = string2;
        }
        for (KeyField keyField : this.keyFields) {
            this.input.clearKeys(keyField.getControl());
            for (int i = 0; i < 2; ++i) {
                ArrayList<Integer> arrayList = this.keyMap.getSlickKeys(keyField.getKeyCode(i));
                if (arrayList == null) continue;
                for (Integer n : arrayList) {
                    this.input.setKey(keyField.getControl(), n);
                }
            }
        }
        for (SettingsDialogListener settingsDialogListener : this.listeners) {
            settingsDialogListener.settingsApplied(settings2, settings);
        }
    }

    public void addListener(SettingsDialogListener settingsDialogListener) {
        this.listeners.add(settingsDialogListener);
    }

    public void removeListener(SettingsDialogListener settingsDialogListener) {
        this.listeners.remove(settingsDialogListener);
    }

    public static interface SettingsDialogListener {
        public void settingsApplied(Settings var1, Settings var2);
    }

    private class KeyField {
        private JLabel label;
        private int control;
        private JTextField[] fields;
        private int[] keyCodes;

        public KeyField(String string, int n) {
            this.control = n;
            this.label = new JLabel(string);
            this.fields = new JTextField[2];
            this.keyCodes = new int[2];
            for (int i = 0; i < this.fields.length; ++i) {
                final int n2 = i;
                final JTextField jTextField = this.fields[i] = new JTextField("None");
                jTextField.setPreferredSize(new Dimension(80, 18));
                jTextField.setEditable(true);
                jTextField.setFocusable(true);
                jTextField.setCaret(new DefaultCaret(){
                    private static final long serialVersionUID = 1L;

                    public boolean isSelectionVisible() {
                        return false;
                    }

                    public boolean isVisible() {
                        return false;
                    }

                    public int getDot() {
                        return 0;
                    }

                    public int getMark() {
                        return 0;
                    }
                });
                jTextField.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        jTextField.setBackground(jTextField.getSelectionColor());
                        jTextField.setForeground(jTextField.getSelectedTextColor());
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        jTextField.setBackground(SettingsDialog.this.keyFieldBackground);
                        jTextField.setForeground(SettingsDialog.this.keyFieldForeground);
                    }
                });
                jTextField.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        KeyField.this.setKeyCode(n2, keyEvent.getKeyCode());
                        keyEvent.consume();
                    }

                    public void keyTyped(KeyEvent keyEvent) {
                        keyEvent.consume();
                    }
                });
            }
        }

        public void setKeyCode(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            String string = KeyEvent.getKeyText(n2);
            if (SettingsDialog.this.keyMap.hasSlickKey(n2)) {
                if (string.length() > 0) {
                    string = string.substring(0, 1).toUpperCase() + string.substring(1);
                }
                this.fields[n].setText(string);
                this.keyCodes[n] = n2;
            } else {
                logger.info("Key " + string + " " + n2 + " is not available in slick");
            }
        }

        public int getControl() {
            return this.control;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public JTextField getTextField(int n) {
            return this.fields[n];
        }

        public int getKeyCode(int n) {
            return this.keyCodes[n];
        }
    }
}

