/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.model.GameMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EnumMap;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NewGameDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private static int MAX_GAME_NAME_LENGTH = 30;
    private String codeName;
    private JLabel nameLabel;
    private JTextField name;
    private JCheckBox allowSpectators;
    private EnumMap<GameMode, JRadioButton> modes;
    private JButton ok;
    private JButton cancel;
    private boolean nameChanged;
    private boolean startGame;
    private Random random = new Random(System.currentTimeMillis());
    private JTextArea modeDescription;
    private JRadioButton roundsA = new JRadioButton("6");
    private JRadioButton roundsB = new JRadioButton("9");
    private JRadioButton roundsC = new JRadioButton("12");

    public NewGameDialog(JFrame jFrame) {
        super(jFrame, "New Game", true);
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nameLabel = new JLabel("Game Name");
        this.nameLabel.setAlignmentX(0.5f);
        this.name = new JTextField(20);
        this.modes = new EnumMap(GameMode.class);
        ButtonGroup buttonGroup = new ButtonGroup();
        GameMode[] gameModeArray = new GameMode[]{GameMode.TRAINING, GameMode.TOURNAMENT};
        for (GameMode object2 : gameModeArray) {
            jComponent = new JRadioButton(object2.toString());
            buttonGroup.add((AbstractButton)jComponent);
            this.modes.put(object2, (JRadioButton)jComponent);
        }
        JPanel jPanel2 = new JPanel();
        for (JRadioButton jRadioButton : this.modes.values()) {
            jPanel2.add(jRadioButton);
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText("To host a game behind a NAT router you\nmust forward both UDP and TCP traffic on\nport 6260. See www.portforward.com for\nmore information.");
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        this.modeDescription = new JTextArea();
        this.modeDescription.setEditable(false);
        this.modeDescription.setFocusable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Options"));
        JPanel jPanel4 = new JPanel();
        jComponent = new JLabel("Rounds");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.roundsC);
        buttonGroup2.add(this.roundsB);
        buttonGroup2.add(this.roundsA);
        jPanel4.add(jComponent);
        jPanel4.add(this.roundsC);
        jPanel4.add(this.roundsB);
        jPanel4.add(this.roundsA);
        JPanel jPanel5 = new JPanel();
        this.allowSpectators = new JCheckBox("Allow visitors after game start", false);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        jPanel6.add(this.ok);
        jPanel6.add(this.cancel);
        this.ok.setEnabled(false);
        jPanel.add(this.nameLabel);
        jPanel.add(this.name);
        jPanel.add(jPanel2);
        jPanel.add(this.modeDescription);
        jPanel.add(jPanel3);
        jPanel.add(jTextArea);
        jPanel.add(jPanel6);
        this.add(jPanel);
        this.setResizable(false);
        this.pack();
        this.name.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                NewGameDialog.this.nameChanged = true;
                if (NewGameDialog.this.name.getText().length() == 0) {
                    NewGameDialog.this.ok.setEnabled(false);
                } else {
                    NewGameDialog.this.ok.setEnabled(true);
                    if (keyEvent.getKeyCode() == 10) {
                        NewGameDialog.this.ok.doClick();
                    }
                }
            }
        });
        this.modes.get((Object)GameMode.TOURNAMENT).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!NewGameDialog.this.nameChanged) {
                    NewGameDialog.this.createGameName();
                }
                NewGameDialog.this.selectMode(GameMode.TOURNAMENT);
            }
        });
        this.modes.get((Object)GameMode.TRAINING).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!NewGameDialog.this.nameChanged) {
                    NewGameDialog.this.createGameName();
                }
                NewGameDialog.this.selectMode(GameMode.TRAINING);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGameDialog.this.startGame = true;
                NewGameDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGameDialog.this.startGame = false;
                NewGameDialog.this.setVisible(false);
            }
        });
        this.modes.get((Object)GameMode.TOURNAMENT).setSelected(true);
        this.selectMode(GameMode.TOURNAMENT);
    }

    private void selectMode(GameMode gameMode) {
        boolean bl = true;
        this.modeDescription.setText(gameMode.getDescription());
        if (gameMode == GameMode.TOURNAMENT) {
            this.roundsC.setSelected(true);
            bl = false;
        }
        this.roundsA.setEnabled(bl);
        this.roundsB.setEnabled(bl);
        this.roundsC.setEnabled(bl);
    }

    public String getGameName() {
        String string = this.name.getText();
        if (string.length() > MAX_GAME_NAME_LENGTH) {
            return string.substring(0, MAX_GAME_NAME_LENGTH);
        }
        return string;
    }

    public GameMode getGameMode() {
        for (GameMode gameMode : GameMode.values()) {
            if (!this.modes.get((Object)gameMode).isSelected()) continue;
            return gameMode;
        }
        return null;
    }

    public boolean isSingleDevelopment() {
        return true;
    }

    public boolean isDeserts() {
        return true;
    }

    public boolean isRiver() {
        return true;
    }

    public int numRounds() {
        if (this.roundsA.isSelected()) {
            return 6;
        }
        if (this.roundsB.isSelected()) {
            return 9;
        }
        return 12;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public boolean isAllowSpectators() {
        return this.allowSpectators.isSelected();
    }

    public void setGameName(String string) {
        this.name.setText(string);
    }

    public boolean showDialog(JComponent jComponent) {
        this.createGameName();
        this.ok.setEnabled(true);
        this.setLocationRelativeTo(jComponent);
        this.setVisible(true);
        return this.startGame;
    }

    private void createGameName() {
        this.nameChanged = false;
        GameMode gameMode = this.getGameMode();
        StringBuffer stringBuffer = new StringBuffer(20);
        if (gameMode == GameMode.TOURNAMENT) {
            int n;
            for (n = 0; n < 3; ++n) {
                stringBuffer.append((char)(65 + this.random.nextInt(26)));
            }
            stringBuffer.append("-");
            for (n = 0; n < 4; ++n) {
                stringBuffer.append((char)(48 + this.random.nextInt(10)));
            }
        } else {
            stringBuffer.append("TRAINING-");
            for (int i = 0; i < 5; ++i) {
                stringBuffer.append((char)(48 + this.random.nextInt(10)));
            }
        }
        this.codeName = stringBuffer.toString();
        this.name.setText(this.codeName);
    }
}

