/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.LogHandler;
import com.turborilla.mule.Properties;
import com.turborilla.mule.Settings;
import com.turborilla.mule.controller.GameControllerListener;
import com.turborilla.mule.frame.AboutDialog;
import com.turborilla.mule.frame.GameChat;
import com.turborilla.mule.frame.LobbyChat;
import com.turborilla.mule.frame.MasterServerPane;
import com.turborilla.mule.frame.NewGameDialog;
import com.turborilla.mule.frame.SettingsDialog;
import com.turborilla.mule.frame.StatusBar;
import com.turborilla.mule.frame.UserListModel;
import com.turborilla.mule.model.GameInfo;
import com.turborilla.mule.model.GameMode;
import com.turborilla.mule.model.GameModel;
import com.turborilla.mule.model.UserInfo;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.view.MuleGameContainer;
import com.turborilla.mule.view.ViewProperties;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.newdawn.slick.util.ResourceLoader;

public class MetaFrame
implements GameControllerListener,
MasterServerPane.Listener,
SettingsDialog.SettingsDialogListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    private JFrame frame;
    private MasterClient masterClient;
    private MasterListener masterClientListener;
    private UserInfo userInfo;
    private MuleGameContainer muleContainer;
    private boolean done;
    private boolean doStartGame;
    private boolean closing;
    private int numGamesStarted;
    private JToolBar toolBar;
    private JButton create;
    private JButton join;
    private JButton manualJoin;
    private JButton disconnect;
    private JButton settings;
    private JButton about;
    private JButton sound;
    private JButton reconnect;
    private SettingsDialog settingsDialog;
    private AboutDialog aboutDialog;
    private NewGameDialog newGameDialog;
    private MasterServerPane masterServerPane;
    private Canvas gameCanvas;
    private LobbyChat lobbyChat;
    private GameChat gameChat;
    private JTabbedPane tabbedPane;
    private JPanel gameTab;
    private JSplitPane lobbyTab;
    private long lastLobbyRefreshTime = 0L;
    private String lastLobbyUpdate = "";
    private boolean enteredLobby = false;
    private StatusBar statusBar;
    private Point location;
    private Dimension minSize;
    private String disconnectString;

    public MetaFrame(final MasterClient masterClient, UserInfo userInfo) {
        Component component;
        logger.info("Creating Meta Frame");
        this.masterClient = masterClient;
        this.userInfo = userInfo;
        this.frame = new JFrame("Planet M.U.L.E. v.1.3.6");
        this.frame.setDefaultCloseOperation(0);
        ImageIcon imageIcon = new ImageIcon(ResourceLoader.getResource("frame/mule-icon.gif"));
        this.frame.setIconImage(imageIcon.getImage());
        this.done = false;
        this.doStartGame = false;
        this.closing = false;
        this.numGamesStarted = 0;
        this.masterClientListener = new MasterListener();
        masterClient.addObserver(this.masterClientListener);
        if (Settings.get().useAWTGLCanvas) {
            try {
                component = new AWTGLCanvas();
                this.gameCanvas = component;
            }
            catch (LWJGLException lWJGLException) {
                logger.severe(lWJGLException.toString());
            }
        } else {
            this.gameCanvas = new NoPaintCanvas();
            this.gameCanvas.setBackground(Color.black);
        }
        this.gameCanvas.setSize(new Dimension(ViewProperties.get().screenWidth, ViewProperties.get().screenHeight));
        this.gameCanvas.setIgnoreRepaint(Settings.get().ignoreRepaint);
        this.gameCanvas.setFocusable(true);
        this.gameCanvas.createBufferStrategy(Settings.get().bufferStrategy);
        this.gameCanvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.create = new JButton("New Game");
        this.join = new JButton("Join Game");
        this.manualJoin = new JButton("Join Address");
        this.disconnect = new JButton("Disconnect");
        this.settings = new JButton("Settings");
        this.about = new JButton("About");
        this.sound = new JButton(Settings.get().soundOn ? "Sound On" : "Sound Off");
        this.reconnect = new JButton("Reconnect");
        this.create.setFocusable(false);
        this.join.setFocusable(false);
        this.manualJoin.setFocusable(false);
        this.disconnect.setFocusable(false);
        this.settings.setFocusable(false);
        this.about.setFocusable(false);
        this.sound.setFocusable(false);
        this.reconnect.setFocusable(false);
        this.toolBar.add(this.create);
        this.toolBar.add(this.join);
        this.toolBar.add(this.manualJoin);
        this.toolBar.add(this.disconnect);
        this.toolBar.add(this.settings);
        this.toolBar.add(this.about);
        this.toolBar.add(this.sound);
        this.join.setEnabled(false);
        this.disconnect.setEnabled(false);
        this.reconnect.setEnabled(false);
        this.masterServerPane = new MasterServerPane();
        this.masterServerPane.addListener(this);
        this.gameChat = new GameChat(this);
        this.lobbyChat = new LobbyChat(this, masterClient, userInfo);
        this.lobbyTab = new JSplitPane(0, this.masterServerPane, this.lobbyChat.getSwingComponent());
        this.lobbyTab.setDividerLocation(0.8);
        this.lobbyTab.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        component = new JPanel();
        ((Container)component).setLayout(new FlowLayout(1, 0, 0));
        ((JComponent)component).setBackground(Color.black);
        component.setIgnoreRepaint(true);
        ((Container)component).add(this.gameCanvas);
        this.gameTab = new JPanel(new BorderLayout());
        this.gameTab.add(component, "North");
        this.gameTab.add((Component)this.gameChat.getSwingComponent(), "Center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Lobby", this.lobbyTab);
        this.tabbedPane.add("Game", this.gameTab);
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.gameTab), false);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MetaFrame.this.focusDefaultComponent();
            }
        });
        this.statusBar = new StatusBar();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.statusBar, "South");
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this.toolBar, "North");
        this.frame.add((Component)jPanel, "Center");
        this.showGame(false);
        this.settingsDialog = new SettingsDialog(this.frame);
        this.aboutDialog = new AboutDialog(this.frame);
        this.newGameDialog = new NewGameDialog(this.frame);
        this.settingsDialog.addListener(this);
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MetaFrame.this.newGameDialog.showDialog(MetaFrame.this.masterServerPane);
                if (!bl) {
                    return;
                }
                String string = MetaFrame.this.newGameDialog.getGameName();
                if (string.equals("")) {
                    return;
                }
                String string2 = MetaFrame.this.newGameDialog.getCodeName();
                GameMode gameMode = MetaFrame.this.newGameDialog.getGameMode();
                String string3 = Settings.get().mapSkin;
                GameInfo gameInfo = new GameInfo("127.0.0.1", string2, string, gameMode, MetaFrame.this.newGameDialog.isSingleDevelopment(), MetaFrame.this.newGameDialog.isRiver(), MetaFrame.this.newGameDialog.isDeserts(), MetaFrame.this.newGameDialog.numRounds(), MetaFrame.this.newGameDialog.isAllowSpectators(), string3);
                MetaFrame.this.startGame(true, gameInfo);
            }
        });
        this.join.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaFrame.this.joinSelectedGame();
            }
        });
        this.manualJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = JOptionPane.showInputDialog(MetaFrame.this.tabbedPane, "Type the host's IP address", "Join Address", -1, null, null, Settings.get().manualJoinAddress);
                if (object != null && !(string = object.toString()).equals("")) {
                    Settings.get().manualJoinAddress = string;
                    GameInfo gameInfo = new GameInfo(string, "");
                    MetaFrame.this.startGame(false, gameInfo);
                }
            }
        });
        this.disconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(MetaFrame.this.frame, MetaFrame.this.disconnectString, "Disconnect", 0);
                if (n == 0) {
                    logger.info("User chooses to disconnect");
                    MetaFrame.this.stopGame();
                }
            }
        });
        this.settings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaFrame.this.settingsDialog.setLocationRelativeTo(MetaFrame.this.frame);
                MetaFrame.this.settingsDialog.setVisible(true);
            }
        });
        this.about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaFrame.this.aboutDialog.setLocationRelativeTo(MetaFrame.this.frame);
                Point point = MetaFrame.this.aboutDialog.getLocation();
                MetaFrame.this.aboutDialog.setLocation(point.x, point.y - 50);
                MetaFrame.this.aboutDialog.setVisible(true);
            }
        });
        this.sound.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = !MetaFrame.this.muleContainer.isSoundOn();
                if (bl) {
                    MetaFrame.this.sound.setText("Sound On");
                } else {
                    MetaFrame.this.sound.setText("Sound Off");
                }
                MetaFrame.this.muleContainer.setSoundOn(bl);
                Settings.get().soundOn = bl;
                MetaFrame.this.focusDefaultComponent();
            }
        });
        this.reconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(MetaFrame.this.frame, "Do you want to reconnect to the last game you played?", "Reconnect", 0);
                if (n == 0) {
                    // empty if block
                }
            }
        });
        this.gameChat.getKickButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserListModel.UserItem userItem = (UserListModel.UserItem)MetaFrame.this.gameChat.getUserList().getSelectedValue();
                if (userItem == null) {
                    return;
                }
                if (userItem.number == 0) {
                    return;
                }
                if (userItem.myUser) {
                    JOptionPane.showMessageDialog(MetaFrame.this.frame, "You can't kick yourself", "Kick User", 2);
                    return;
                }
                int n = JOptionPane.showConfirmDialog(MetaFrame.this.frame, "Are you sure you want to kick " + userItem.name, "Kick user", 0);
                if (n == 0) {
                    MetaFrame.this.muleContainer.kick(userItem.number);
                }
                MetaFrame.this.focusDefaultComponent();
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (MetaFrame.this.minSize == null) {
                    return;
                }
                Dimension dimension = MetaFrame.this.frame.getSize();
                if (dimension.width < ((MetaFrame)MetaFrame.this).minSize.width || dimension.height < ((MetaFrame)MetaFrame.this).minSize.height) {
                    dimension.width = Math.max(dimension.width, ((MetaFrame)MetaFrame.this).minSize.width);
                    dimension.height = Math.max(dimension.height, ((MetaFrame)MetaFrame.this).minSize.height);
                    MetaFrame.this.frame.setSize(dimension);
                }
            }
        });
        this.gameCanvas.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    keyEvent.consume();
                }
            }
        });
        this.frame.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        this.frame.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getComponentAfter(Container container, Component component) {
                return MetaFrame.this.gameCanvas;
            }

            public Component getComponentBefore(Container container, Component component) {
                return MetaFrame.this.gameCanvas;
            }

            public Component getDefaultComponent(Container container) {
                return MetaFrame.this.gameCanvas;
            }

            public Component getFirstComponent(Container container) {
                return MetaFrame.this.gameCanvas;
            }

            public Component getLastComponent(Container container) {
                return MetaFrame.this.gameCanvas;
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (MetaFrame.this.closing) {
                    logger.info("User closes meta frame again.");
                    return;
                }
                logger.info("Meta frame closing");
                while (MetaFrame.this.doStartGame && !MetaFrame.this.muleContainer.isRunning()) {
                    Thread.yield();
                }
                int n = JOptionPane.showConfirmDialog(MetaFrame.this.frame, "Are you sure you want to quit?", "Exit Planet M.U.L.E.", 0, 3);
                if (n != 0) {
                    logger.info("User didn't want to close");
                    return;
                }
                masterClient.removeObserver(MetaFrame.this.masterClientListener);
                MetaFrame.this.muleContainer.stop();
                MetaFrame.this.doStartGame = false;
                MetaFrame.this.done = true;
                while (!MetaFrame.this.muleContainer.hasStopped()) {
                    Thread.yield();
                }
                MetaFrame.this.frame.setEnabled(false);
                logger.info("Meta frame closing done");
                MetaFrame.this.closing = true;
            }

            public void windowClosed(WindowEvent windowEvent) {
                logger.info("Meta frame closed");
            }
        });
        this.frame.pack();
        this.minSize = this.frame.getSize();
        this.frame.setMinimumSize(this.minSize);
        this.frame.setResizable(true);
        this.frame.setLocationRelativeTo(null);
        this.masterServerPane.setDividerLocation();
        this.lobbyChat.focusChatInput();
        this.frame.setVisible(true);
        masterClient.sendEnterLobby();
    }

    public void setMuleContainer(MuleGameContainer muleGameContainer) {
        this.muleContainer = muleGameContainer;
        this.settingsDialog.setInput(muleGameContainer.getGameInput());
    }

    public void debugStartGame(final boolean bl, final GameInfo gameInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.startGame(bl, gameInfo);
            }
        });
    }

    private void startGame(final boolean bl, final GameInfo gameInfo) {
        final UserInfo userInfo = new UserInfo(this.userInfo.getName(), this.userInfo.getUsername(), this.userInfo.getPassword(), this.userInfo.getUserId(), this.userInfo.getRace(), bl, false);
        while (this.doStartGame) {
            Thread.yield();
        }
        LogHandler.setLogFile("log.txt", "log_init.txt");
        logger.info("Starting game number " + this.numGamesStarted);
        logger.info("Entering Game - ID: " + gameInfo.getGameID() + ", Name: " + gameInfo.getGameName() + ", Address: " + gameInfo.getServerAddress() + ", Is Host: " + bl);
        ++this.numGamesStarted;
        this.create.setEnabled(false);
        this.join.setEnabled(false);
        this.manualJoin.setEnabled(false);
        this.reconnect.setEnabled(false);
        this.gameChat.clearChat();
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.gameTab), true);
        this.showGame(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MetaFrame.this.doStartGame) {
                    logger.info("Game is already started.");
                    return;
                }
                MetaFrame.this.muleContainer.setup(gameInfo, userInfo);
                MetaFrame.this.doStartGame = true;
                while (MetaFrame.this.doStartGame && !MetaFrame.this.muleContainer.isRunning()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.severe(interruptedException.toString());
                    }
                }
                MetaFrame.this.disconnectString = "If you leave all progress will be lost.\nAre you sure you want to leave the game?";
                MetaFrame.this.disconnect.setEnabled(true);
                if (bl) {
                    MetaFrame.this.gameChat.getKickButton().setEnabled(true);
                }
            }
        });
    }

    public void stopGame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.disconnect.setEnabled(false);
                MetaFrame.this.gameChat.getKickButton().setEnabled(false);
                MetaFrame.this.muleContainer.stop();
            }
        });
    }

    public void finishGame() {
        this.doStartGame = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.gameChat.getUserListModel().clear();
                MetaFrame.this.statusBar.clear();
                MetaFrame.this.create.setEnabled(true);
                MetaFrame.this.manualJoin.setEnabled(true);
                MetaFrame.this.reconnect.setEnabled(false);
                MetaFrame.this.showGame(false);
                MetaFrame.this.tabbedPane.setEnabledAt(MetaFrame.this.tabbedPane.indexOfComponent(MetaFrame.this.gameTab), false);
                MetaFrame.this.lobbyChat.focusChatInput();
            }
        });
    }

    public Canvas getGameCanvas() {
        return this.gameCanvas;
    }

    public UserListModel getUserListModel() {
        return this.gameChat.getUserListModel();
    }

    public void sendChatMessage(String string) {
        this.muleContainer.sendChatMessage(string);
    }

    public void focusDefaultComponent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doFocusDefaultComponent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MetaFrame.this.doFocusDefaultComponent();
                }
            });
        }
    }

    private void doFocusDefaultComponent() {
        if (this.tabbedPane.getSelectedComponent() == this.gameTab) {
            this.gameCanvas.requestFocus();
            this.gameCanvas.requestFocusInWindow();
        } else {
            this.lobbyChat.focusChatInput();
        }
    }

    public void gameStarted() {
    }

    public void gameEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.disconnectString = "Thank you for playing!\nDo you want to close the game\nand return to the lobby?";
            }
        });
    }

    public void startChat() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.gameChat.startChat();
            }
        });
    }

    public void chatMessageUser(final String string, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.gameChat.addUserMessage(string, n);
            }
        });
    }

    public void chatMessageSystem(final String string, final String string2, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.gameChat.addSystemMessage(string, string2, n);
            }
        });
    }

    public void sendChatLog(long l) {
        String string = new String(this.gameChat.getChatHistory());
        this.masterClient.sendChatLog(l, string);
    }

    public void setGameModel(GameModel gameModel) {
        this.getUserListModel().observe(gameModel);
        this.statusBar.observe(gameModel);
    }

    public void phaseEnded() {
        this.muleContainer.logSkippedFrames();
    }

    public void setFpsCounter(int n) {
        this.statusBar.setFpsCounter(n);
    }

    public void setPing(int n) {
        this.statusBar.setPing(n);
    }

    public void storeLocation() {
        this.location = this.frame.getLocation();
    }

    public void restoreLocation() {
        this.frame.setLocation(this.location);
    }

    public void center() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MetaFrame.this.frame.setLocationRelativeTo(null);
            }
        });
    }

    public void doubleClickedGame() {
        if (this.doStartGame) {
            JOptionPane.showMessageDialog(this.tabbedPane, "You must disconnect from your current game to join another game.", "Join Game", 1);
        } else {
            this.joinSelectedGame();
        }
    }

    private void joinSelectedGame() {
        if (this.doStartGame) {
            return;
        }
        MasterResponse.RefreshLobby.Game game = this.masterServerPane.getSelectedGame();
        if (game == null) {
            return;
        }
        if (game.getStatus().equals("running")) {
            JOptionPane.showMessageDialog(this.tabbedPane, "You can't join a started game.");
            return;
        }
        GameInfo gameInfo = new GameInfo(game.getAddress(), game.getName());
        this.startGame(false, gameInfo);
    }

    public void selectedGame(MasterResponse.RefreshLobby.Game game) {
        if (!this.doStartGame && game != null) {
            this.join.setEnabled(true);
        } else {
            this.join.setEnabled(false);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isStartGame() {
        return this.doStartGame;
    }

    private void showGame(boolean bl) {
        if (bl) {
            this.tabbedPane.setSelectedComponent(this.gameTab);
        } else {
            this.tabbedPane.setSelectedComponent(this.lobbyTab);
        }
    }

    public void refreshLobby() {
        if (this.tabbedPane.getSelectedComponent() == this.lobbyTab) {
            long l = Properties.mule.masterRefreshLobbyTime + this.lastLobbyRefreshTime;
            if (System.currentTimeMillis() > l && !this.masterClient.isClosed() && this.enteredLobby) {
                this.masterClient.sendRefreshLobby(this.lastLobbyUpdate, this.lobbyChat.getLastLobbyMessageId());
                this.lastLobbyRefreshTime = System.currentTimeMillis();
            }
        }
    }

    public void settingsApplied(Settings settings, Settings settings2) {
        if (this.muleContainer.isRunning()) {
            this.muleContainer.settingsChanged(settings, settings2);
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void dispose() {
        try {
            logger.info("Disposing meta frame");
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    MetaFrame.this.frame.setVisible(false);
                    MetaFrame.this.frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, throwable.toString(), throwable);
        }
    }

    private class MasterListener
    extends MasterClientListener {
        private MasterListener() {
        }

        public void apply(final MasterResponse.EnterLobby enterLobby) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    logger.info("Entered master server game lobby");
                    MetaFrame.this.lobbyChat.setLastLobbyMessageId(enterLobby.getLastMessageId());
                    MetaFrame.this.lobbyChat.addSystemMessage(enterLobby.getWelcomeText());
                    MetaFrame.this.enteredLobby = true;
                }
            });
        }

        public void apply(final MasterResponse.RefreshLobby refreshLobby) {
            if (!refreshLobby.isEmpty() && !refreshLobby.isError()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MetaFrame.this.lastLobbyUpdate = refreshLobby.getUpdateTime();
                        if (refreshLobby.getUsers() != null) {
                            MetaFrame.this.masterServerPane.setUsers(refreshLobby.getUsers());
                            MetaFrame.this.lobbyChat.setUsers(refreshLobby.getUsers());
                        }
                        if (refreshLobby.getMessages() != null) {
                            MetaFrame.this.lobbyChat.addLobbyMessages(refreshLobby.getMessages());
                        }
                        if (refreshLobby.getGames() != null) {
                            long l = 0L;
                            if (MetaFrame.this.userInfo != null) {
                                l = MetaFrame.this.userInfo.getUserId();
                            }
                            MetaFrame.this.masterServerPane.setGames(refreshLobby.getGames(), l);
                        }
                    }
                });
            }
        }
    }

    private static class NoPaintCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;

        private NoPaintCanvas() {
        }

        public void paint(Graphics graphics) {
        }

        public void paintAll(Graphics graphics) {
        }
    }
}

