/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.MuleException;
import com.turborilla.mule.frame.Animation;
import com.turborilla.mule.frame.Sprite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.newdawn.slick.util.ResourceLoader;

public class LoginAnimation
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("mule");
    private ArrayList<Animation> animations;
    private int currentAnimation;
    private BufferedImage background;
    private BufferedImage titleSrc;
    private BufferedImage title;
    private Sprite acidRain;
    private ArrayList<Sprite> avatars;
    private Sprite mule;
    private Thread thread;
    private Animator animator;
    private int width = 550;
    private int height = 220;
    ColorConvertOp convert;

    public LoginAnimation() throws MuleException {
        this.setDoubleBuffered(true);
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(this.width - 2, this.height));
        try {
            this.background = ImageIO.read(ResourceLoader.getResource("frame/login_background.png"));
            this.title = ImageIO.read(ResourceLoader.getResource("frame/planet_mule.png"));
            this.acidRain = new Sprite("images/events/acidrain.png", 54, 44);
            this.acidRain.setPos(-2000, 80);
            this.avatars = new ArrayList();
            for (int i = 0; i < 8; ++i) {
                this.avatars.add(new Sprite("images/races/race" + i + ".png", 32, 48));
            }
            for (Sprite sprite : this.avatars) {
                sprite.swapColors(0);
            }
            Collections.shuffle(this.avatars);
            this.mule = new Sprite("images/followers/sprite-mule.png", 64, 80);
        }
        catch (IOException iOException) {
            throw new MuleException(iOException);
        }
        this.animations = new ArrayList();
        this.animations.add(new Animation.WalkingMule(this.mule));
        this.animations.add(new Animation.Parade(this.avatars));
        this.animations.add(new Animation.ChaseMule(this.avatars, this.mule));
        this.currentAnimation = 0;
        this.animations.get(this.currentAnimation).begin();
        this.animator = new Animator();
        this.thread = new Thread(this.animator);
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.animator.stop = true;
        try {
            if (this.thread.isAlive()) {
                this.thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.background, 0, 0, null);
        this.animations.get(this.currentAnimation).draw(graphics);
        graphics.drawImage(this.title, 121, 14, null);
    }

    private class Animator
    implements Runnable {
        public boolean stop = false;
        private long frame;

        private Animator() {
        }

        public void run() {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.frame = 0L;
            int n = 16;
            while (!this.stop) {
                Animation animation = (Animation)LoginAnimation.this.animations.get(LoginAnimation.this.currentAnimation);
                while (animation.isCompleted()) {
                    LoginAnimation.this.currentAnimation++;
                    if (LoginAnimation.this.currentAnimation >= LoginAnimation.this.animations.size()) {
                        Collections.shuffle(LoginAnimation.this.animations);
                        Collections.shuffle(LoginAnimation.this.avatars);
                        if (animation == LoginAnimation.this.animations.get(0)) {
                            Collections.swap(LoginAnimation.this.animations, 0, LoginAnimation.this.animations.size() - 1);
                        }
                        LoginAnimation.this.currentAnimation = 0;
                    }
                    animation = (Animation)LoginAnimation.this.animations.get(LoginAnimation.this.currentAnimation);
                    animation.begin();
                }
                animation.update(n);
                ++this.frame;
                LoginAnimation.this.repaint();
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

