/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.frame;

import com.turborilla.mule.HTMLEncode;
import com.turborilla.mule.frame.FrameUtil;
import com.turborilla.mule.frame.MetaFrame;
import com.turborilla.mule.view.ViewProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public abstract class Chat {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("mule");
    protected JPanel chatPanel;
    protected JTextField chatInput;
    private JButton chatSend;
    private JPanel chatSendPanel;
    private JScrollPane chatScroll;
    private JEditorPane chatMessages = new JEditorPane("text/html", "");
    private String emptyDocument;
    private HTMLDocument htmlDocument;
    private Element htmlBody;
    private static final int MAX_CHAT_MESSAGE_LENGTH = 300;

    public Chat(final MetaFrame metaFrame) {
        this.chatMessages.setEditable(false);
        this.chatMessages.setFocusable(true);
        String string = FrameUtil.toHexRGB(this.chatMessages.getForeground());
        this.emptyDocument = this.createHTMLDocument(string);
        this.chatScroll = new JScrollPane(this.chatMessages, 22, 31);
        this.chatSend = new JButton("Send");
        this.chatSend.setEnabled(false);
        this.chatInput = new JTextField();
        this.chatSendPanel = new JPanel(new BorderLayout());
        this.chatSendPanel.add((Component)this.chatInput, "Center");
        this.chatPanel = new JPanel();
        this.chatPanel.setLayout(new BorderLayout());
        this.chatPanel.add((Component)this.chatScroll, "Center");
        this.chatPanel.add((Component)this.chatSendPanel, "South");
        this.chatInput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Chat.this.chatInputKeyPressed(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (Chat.this.chatInput.getText().length() >= 300) {
                    keyEvent.consume();
                }
            }
        });
        this.chatInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                Chat.this.focusLost();
            }
        });
        this.chatInput.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Chat.this.mouseClicked();
            }
        });
        this.chatMessages.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 27: {
                        metaFrame.focusDefaultComponent();
                    }
                }
            }
        });
        this.clearChat();
    }

    protected Color getTextColor() {
        return this.chatMessages.getForeground();
    }

    public abstract JComponent getSwingComponent();

    protected boolean isValidChatText(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return true;
        }
        return false;
    }

    void clearChat() {
        this.chatMessages.setText(this.emptyDocument);
        this.htmlDocument = (HTMLDocument)this.chatMessages.getDocument();
        this.htmlBody = this.htmlDocument.getElement("content");
        this.chatCleared();
    }

    protected void addSystemMessage(String string, String string2, int n) {
        string = HTMLEncode.encode(string);
        string2 = HTMLEncode.encode(string2);
        string = string.replaceFirst("&#37;s", "<font color=\"" + this.getColor(n) + "\">" + string2 + "</font>");
        this.addMessage("<p><b>" + string + "</b></p>");
    }

    protected void addSystemMessage(String string) {
        this.addMessage("<p><b>" + HTMLEncode.encode(string) + "</b></p>");
    }

    protected void addMessage(String string) {
        try {
            this.htmlDocument.insertBeforeStart(this.htmlBody, string);
            this.chatMessages.setCaretPosition(this.htmlDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.SEVERE, badLocationException.toString(), badLocationException);
            logger.severe("Messages was: " + string);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.toString(), iOException);
            logger.severe("Messages was: " + string);
        }
    }

    public String getChatHistory() {
        return this.chatMessages.getText();
    }

    protected String getColor(int n) {
        return ViewProperties.get().metaFrameColors[n];
    }

    public void focusChatInput() {
        this.chatInput.requestFocusInWindow();
    }

    protected abstract void chatInputKeyPressed(KeyEvent var1);

    protected abstract void focusLost();

    protected abstract void mouseClicked();

    protected abstract void chatCleared();

    private String createHTMLDocument(String string) {
        return "<html><head><style type=\"text/css\"><!--body { \tfont-family: verdana, arial, sans-serif;\tfont-size: 11 pt;\tcolor: #" + string + ";" + "\tpadding: 0;" + "\tmargin: 0;" + "}" + "p {" + "\tmargin: 0;" + "}" + "#content {" + "\tfont-size: 0 pt;" + "}" + "--></style>" + "</head>" + "<body><p id=\"content\">&nbsp;</p>" + "</body></html>";
    }
}

