/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.MuleMath;
import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.MasterClient;
import com.turborilla.mule.network.MasterClientListener;
import com.turborilla.mule.network.MasterResponse;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.MessagePainter;
import com.turborilla.mule.view.SummaryPainter3;
import com.turborilla.mule.view.Transition;
import com.turborilla.mule.view.Transitionable;
import java.util.logging.Logger;

public class SummaryPhase2
extends PhaseController {
    private static final Logger logger = Logger.getLogger("mule");
    private int colonyTotal;
    private boolean allPlayersContinue;
    SummaryListener summaryListener = new SummaryListener();
    private MasterListener masterClientListener = new MasterListener();
    private BlobbyTransition transition;
    private Transitionable prevView;
    private Transitionable currentView;
    private String shortageMessage;
    private boolean colonyFailed;
    private int summaryRound;
    private Transitionable summaryPainter = new Transitionable(){

        public void draw() {
            SummaryPhase2.this.view.getSummaryPainter().draw(SummaryPhase2.this.colonyTotal, SummaryPhase2.this.summaryRound);
        }
    };
    private Transitionable mapPainter = new Transitionable(){

        public void draw() {
            SummaryPhase2.this.view.getMapPainter().draw(SummaryPhase2.this.model.getMap(), SummaryPhase2.this.model.getPlayers(), SummaryPhase2.this.model.getMyPlayer());
        }
    };
    private final String[] colonyMessages = new String[]{"Overall, the Colony failed... Dismally. The Federation debtors' prison is your next home!", "Overall, the Colony failed... The Federation will no longer send trade ships. You are on your own!", "Overall, the Colony survived... Barely. You will be living in tents. Few trading ships will come your way!", "Overall, the Colony was a success. You have met the minimum standards set by the Federation, but your life will not be easy!", "Overall, the Colony succeeded. The Federation is pleased by your efforts. You will live comfortably!", "Overall, the Colony succeeded... Extremely well. You can now retire in elegant estates!", "Overall, the Colony delighted the Federation with your exceptional achievement. Your retirement will be luxurious!"};

    public void begin() {
        this.summaryRound = this.model.getRound();
        this.controller.checkClientSynchronization();
        this.model.updatePlayerRankOrder();
        logger.info("Total Memory: " + Runtime.getRuntime().totalMemory());
        logger.info("Free Memory: " + Runtime.getRuntime().freeMemory());
        for (Player object2 : this.model.getPlayersInRankOrder()) {
            object2.setContinue(false);
            logger.info(object2 + " Money: $" + object2.getMoney() + " Plots: " + object2.getOwnedTiles().size() + " Assets: " + object2.getGoodsPoints() + " Total: " + object2.getPoints());
            logger.info(object2 + " Food: " + object2.getFood() + " Energy: " + object2.getEnergy() + " Smithore: " + object2.getSmithore() + " Crystite: " + object2.getCrystite());
        }
        Shop shop = this.model.getShop();
        shop.buildMules();
        for (Resource resource : Resource.values()) {
            logger.info("Shop " + (Object)((Object)resource) + ": " + shop.getResource(resource) + " units $" + shop.getPrice(resource));
        }
        logger.info("Shop mules: " + shop.numMules() + " $" + shop.getMuleCost());
        this.colonyTotal = this.model.calcColonyTotal();
        logger.info("Colony total: " + this.colonyTotal);
        this.allPlayersContinue = false;
        this.view.fadeTitle();
        this.view.fadeTerminalMessage();
        this.checkShortageMessage();
        MasterClient masterClient = this.controller.getMasterClient();
        if (this.controller.isServer()) {
            masterClient.addObserver(this.masterClientListener);
            for (Player player : this.model.getPlayers()) {
                masterClient.sendRoundResults(player.getUserNumber(), this.model.getRound(), player.getMoney(), player.getGoodsPoints() + player.getLandPoints(), player.getOwnedTiles().size());
            }
            masterClient.sendFinishRound();
            if (this.model.isLastRound() || this.colonyFailed) {
                masterClient.sendFinishGame(this.colonyFailed);
            }
            this.controller.sendChatLog();
        }
        masterClient.sendLog(this.model.getGameInfo().getGameID(), "normal", "log.txt");
        if (this.model.isLastRound() || this.colonyFailed) {
            this.model.setGameOver();
            if (!this.colonyFailed) {
                this.controller.sendSystemChatMessage("Game Over");
            }
            if (masterClient.isClosed()) {
                this.controller.gameEnded();
            } else {
                this.controller.sendSystemChatMessage("Saving score, please wait...");
            }
        }
        this.view.getHUDPainter().setLightsAlwaysVisible(true);
        this.view.getSummaryPainter().addListener(this.summaryListener);
        SoundPlayer.get().playTheme();
        this.prevView = this.mapPainter;
        this.currentView = this.summaryPainter;
        System.gc();
    }

    private void checkShortageMessage() {
        if (this.model.isLastRound()) {
            this.shortageMessage = null;
            return;
        }
        Shop shop = this.model.getShop();
        this.colonyFailed = false;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = shop.getFood();
        int n2 = shop.getEnergy();
        int n3 = shop.numMules() + shop.getSmithore() / 2;
        for (Player player : this.model.getPlayers()) {
            n += player.getFood();
            n2 += player.getEnergy();
        }
        if (n == 0 && this.checkNoProduction(Resource.Food)) {
            this.colonyFailed = true;
            this.shortageMessage = "The Colony Failed because of a Total Lack of Food!";
            return;
        }
        if (n2 == 0 && this.checkNoProduction(Resource.Energy)) {
            this.colonyFailed = true;
            this.shortageMessage = "The Colony Failed because of a Total Lack of Energy!";
            return;
        }
        if (n < shop.getFoodNeed(this.model)) {
            bl = true;
        }
        if (n2 < shop.getEnergyNeed(this.model)) {
            bl2 = true;
        }
        if (n3 < shop.getMuleNeed(this.model)) {
            bl3 = true;
        }
        this.shortageMessage = bl && bl2 ? "The Colony has a Shortage of Food and Energy!" : (bl ? "The Colony has a Shortage of Food!" : (bl2 ? "The Colony has a Shortage of Energy!" : (bl3 ? "The Store has a Shortage of Smithore for M.U.L.E.s!" : null)));
    }

    private boolean checkNoProduction(Resource resource) {
        boolean bl = true;
        for (Player player : this.model.getPlayers()) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                Factory factory = planetTile.getFactory();
                if (factory == null || factory.getResource() != Resource.Food) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            break;
        }
        return bl;
    }

    public void beginTransitionComplete() {
        this.view.getSummaryPainter().start(this.model.getPlayersInRankOrder());
    }

    public void draw() {
        this.view.drawTransition(this.transition, this.prevView, this.currentView);
    }

    protected final void toggleMap() {
        if (this.currentView == this.summaryPainter) {
            this.prevView = this.summaryPainter;
            this.currentView = this.mapPainter;
        } else {
            this.prevView = this.mapPainter;
            this.currentView = this.summaryPainter;
        }
        this.transition = BlobbyTransition.createPlayAreaTransition();
    }

    public Transition end() {
        this.view.getSummaryPainter().removeListener(this.summaryListener);
        if (this.controller.isServer()) {
            MasterClient masterClient = this.controller.getMasterClient();
            masterClient.removeObserver(this.masterClientListener);
        }
        this.model.beginNextRound();
        this.controller.sendSystemChatMessage("Round " + this.model.getRound() + " of " + this.model.getGameInfo().getLastRound());
        return BlobbyTransition.createPlayAreaTransition();
    }

    public void endTransitionComplete() {
        this.view.getSummaryPainter().stop();
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        if (this.transition != null) {
            this.transition.update(Properties.mule.delta);
        }
        SummaryPainter3 summaryPainter3 = this.view.getSummaryPainter();
        summaryPainter3.update();
        if (summaryPainter3.isSummaryFinished()) {
            for (Player player : this.model.getLocalPlayers()) {
                PlayerController playerController = player.getController();
                if (!playerController.isActionButtonPressed()) continue;
                if (this.model.isGameOver()) {
                    if (player != this.model.getMyPlayer()) continue;
                    this.toggleMap();
                    continue;
                }
                if (player.isContinue()) continue;
                player.sendUnordered(this.controller.getClient(), new TCPMessage.ContinueMessage());
            }
        }
    }

    public void apply(TCPMessage.ContinueMessage continueMessage) {
        if (this.model.isGameOver()) {
            this.controller.gameEnded();
            this.controller.sendSystemChatMessage("Score saved");
            logger.info("Score saved");
        } else {
            Player player = this.model.getPlayer(continueMessage.getUserNumber());
            if (player == null) {
                return;
            }
            player.setContinue(true);
            SoundPlayer.get().playButtonPress(player.getPlayerIndex());
            if (!this.checkContinue() && player == this.model.getMyPlayer()) {
                this.view.setTerminalMessage("Waiting for other Players");
            }
        }
    }

    public boolean checkContinue() {
        if (this.allPlayersContinue) {
            return true;
        }
        this.allPlayersContinue = this.model.allPlayersContinue();
        if (this.allPlayersContinue) {
            this.view.fadeTerminalMessage();
            this.view.fadeTitle();
            SoundPlayer.get().fadeTheme(2000);
            if (this.model.getRound() == 0) {
                this.model.setNextPhase(Phase.INTRO);
            } else {
                this.model.setNextPhase(Phase.LAND_GRANT);
            }
            for (User user : this.model.getLocalUsers()) {
                user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
            }
        }
        return this.allPlayersContinue;
    }

    public void userRemoved(User user) {
        if (user == this.model.getServerUser()) {
            this.controller.getClient().close();
            this.controller.sendSystemChatMessage("Chat closed");
        }
    }

    private String getColonyMessage() {
        int n = this.model.getGameInfo().getLastRound();
        int n2 = 20000 * n / 12;
        int n3 = MuleMath.clamp(this.colonyTotal / n2, 0, this.colonyMessages.length - 1);
        logger.info("Colony rating: " + n3);
        logger.info(this.colonyMessages[n3]);
        return this.colonyMessages[n3];
    }

    private class SummaryListener
    extends SummaryPainter3.SummaryListener {
        private SummaryListener() {
        }

        public void summaryFinished() {
            if (SummaryPhase2.this.colonyFailed) {
                SummaryPhase2.this.controller.sendSystemChatMessage(SummaryPhase2.this.shortageMessage);
                SummaryPhase2.this.view.getSummaryPainter().showToggleMap();
                SummaryPhase2.this.view.setScrollingTerminalMessage(SummaryPhase2.this.shortageMessage, new MessagePainter.ScrollingTerminalMessageListener(){

                    public void finished() {
                        SummaryPhase2.this.view.setScrollingTerminalMessage(SummaryPhase2.this.shortageMessage, this);
                    }
                });
            } else if (SummaryPhase2.this.model.isGameOver()) {
                Player player = SummaryPhase2.this.model.getPlayersInRankOrder().get(0);
                SummaryPhase2.this.view.getSummaryPainter().setWinner(player, player.getHudName() + " is the First Founder");
                SummaryPhase2.this.view.getSummaryPainter().showToggleMap();
                final String string = SummaryPhase2.this.getColonyMessage();
                SummaryPhase2.this.view.setScrollingTerminalMessage(string, new MessagePainter.ScrollingTerminalMessageListener(){

                    public void finished() {
                        SummaryPhase2.this.view.setScrollingTerminalMessage(string, this);
                    }
                });
            } else {
                SummaryPhase2.this.view.getSummaryPainter().setShortageMessage(SummaryPhase2.this.shortageMessage);
                SummaryPhase2.this.view.getHUDPainter().setLightsAlwaysVisible(false);
                SummaryPhase2.this.view.getGlobalBlinker().setVisible(true);
                SummaryPhase2.this.view.setTerminalMessage("Press your Button to Continue");
            }
        }
    }

    private class MasterListener
    extends MasterClientListener {
        private MasterListener() {
        }

        public void apply(MasterResponse.FinishGame finishGame) {
            User user = SummaryPhase2.this.model.getMyUser();
            user.sendUnordered(SummaryPhase2.this.controller.getClient(), new TCPMessage.ContinueMessage());
        }
    }
}

