/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Logger;

public class ProductionPhase
extends PhaseController {
    private static Logger logger = Logger.getLogger("mule");
    private float powerTimer;
    private float produceTimer;
    private float skipTimer;
    private float outroTimer;
    private boolean powerFinished;
    private boolean productionFinished;
    private int productionClicks;
    private ArrayList<Factory> factories;
    private Random random;

    public void begin() {
        this.controller.checkClientSynchronization();
        this.random = new Random(this.model.getRandom().nextLong());
        this.powerTimer = Properties.mule.productionPowerTime;
        this.produceTimer = Properties.mule.productionStartProduceTime;
        this.skipTimer = 5.0f;
        this.outroTimer = Properties.mule.productionResultTime;
        this.powerFinished = false;
        this.productionFinished = false;
        this.productionClicks = 0;
        this.factories = new ArrayList();
        for (Player player : this.model.getPlayers()) {
            player.setContinue(false);
        }
        this.view.getHUDPainter().setInvertLights(true);
        this.view.setTitle("Production #" + this.model.getRound());
        SoundPlayer.get().playBeginPhase();
        this.model.showFactoryYield();
    }

    public void draw() {
        ColonyEvent colonyEvent = this.model.getColonyEventGenerator().getCurrentEvent();
        this.view.getMapPainter().draw(this.model.getMap(), this.model.getPlayers(), this.model.getMyPlayer(), null, this.powerFinished);
        if (this.powerFinished) {
            this.view.getMapPainter().drawProduction(this.model.getPlayers());
        }
        this.view.drawColonyEvent(colonyEvent, this.model.getRound());
    }

    public Transition end() {
        return null;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        block15: {
            block16: {
                block14: {
                    if (this.isAllPlayersAi()) {
                        if (gameInput.isDown(4)) {
                            for (Player user : this.model.getLocalPlayers()) {
                                user.sendUnordered(this.controller.getClient(), new TCPMessage.ContinueMessage());
                            }
                        }
                    } else {
                        for (Player f2 : this.model.getLocalPlayers()) {
                            if (f2.isContinue() || !f2.getController().isActionButtonPressed()) continue;
                            f2.sendUnordered(this.controller.getClient(), new TCPMessage.ContinueMessage());
                        }
                    }
                    if (this.powerFinished) break block14;
                    this.powerTimer -= Properties.mule.delta;
                    if (this.powerTimer <= 0.0f) {
                        this.powerTimer = 0.0f;
                        this.finishPower();
                    }
                    break block15;
                }
                if (this.productionFinished) break block16;
                this.produceTimer -= Properties.mule.delta;
                if (this.produceTimer <= 0.0f) {
                    float f = Properties.mule.produceTimeMin;
                    float f2 = Properties.mule.produceTimeMax;
                    float f3 = this.random.nextFloat();
                    this.produceTimer += f + f3 * (f2 - f);
                    this.productionFinished = true;
                    if (this.factories.size() > 0) {
                        Collections.shuffle(this.factories, this.random);
                        for (int i = 0; i < this.factories.size(); ++i) {
                            Factory factory = this.factories.get(i);
                            if (factory.getProduction() >= factory.getCapacity()) continue;
                            factory.setProduction(factory.getProduction() + 1);
                            this.productionFinished = false;
                            break;
                        }
                    }
                    if (!this.productionFinished) {
                        ++this.productionClicks;
                        SoundPlayer.get().playProduction();
                    } else {
                        this.view.fadeTerminalMessage();
                        this.setAllContinue();
                    }
                }
                if (!(this.skipTimer > 0.0f)) break block15;
                this.skipTimer -= Properties.mule.delta;
                if (!(this.skipTimer <= 0.0f)) break block15;
                this.skipTimer = 0.0f;
                this.view.setTerminalMessage("Press your Button to Skip");
                break block15;
            }
            if (this.outroTimer > 0.0f) {
                this.outroTimer -= Properties.mule.delta;
                if (this.outroTimer <= 0.0f) {
                    this.outroTimer = 0.0f;
                    this.logProduction(false);
                    this.view.fadeTerminalMessage();
                    this.model.setNextPhase(Phase.COLONY_EVENT_B);
                    for (User user : this.model.getLocalUsers()) {
                        user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
                    }
                }
            }
        }
    }

    private boolean isAllPlayersAi() {
        for (Player player : this.model.getPlayers()) {
            if (player.isAiPlayer()) continue;
            return false;
        }
        return true;
    }

    public void apply(TCPMessage.ContinueMessage continueMessage) {
        Player player = this.model.getPlayer(continueMessage.getUserNumber());
        if (!player.isContinue()) {
            if (!player.isAiPlayer()) {
                SoundPlayer.get().playButtonPress(player.getPlayerIndex());
            }
            player.setContinue(true);
            if (this.model.allPlayersContinue()) {
                logger.info("Skipping production");
                this.finishPower();
                this.finishProduction();
                this.setAllContinue();
                this.view.fadeTerminalMessage();
            } else if (player == this.model.getMyPlayer()) {
                this.view.setTerminalMessage("Waiting for other Players");
                this.skipTimer = 0.0f;
            }
        }
    }

    private void finishPower() {
        if (this.powerFinished) {
            return;
        }
        Player player = this.model.getMyPlayer();
        boolean bl = false;
        for (PlanetTile comparable : player.getOwnedTiles()) {
            if (comparable.getFactory() == null) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n = player.getEnergy();
            int n2 = player.getEnergyRequirement();
            int n3 = 100;
            if (n < n2) {
                float f = n2 == 0 ? 1.0f : (float)n / (float)n2;
                n3 = (int)(100.0f * f);
                SoundPlayer.get().playPowerDown();
            } else {
                SoundPlayer.get().playPowerUp();
            }
            this.view.setTerminalMessage("Energy at " + n3 + "%");
        }
        this.factories.clear();
        for (Player player2 : this.model.getPlayers()) {
            logger.info(player2.toString() + " has " + player2.getEnergy() + " energy and needs " + player2.getEnergyRequirement() + " energy");
            player2.useEnergy(this.model.getRandom());
            for (PlanetTile planetTile : player2.getOwnedTiles()) {
                Factory factory = planetTile.getFactory();
                if (factory == null || factory.getCapacity() <= 0) continue;
                this.factories.add(factory);
            }
        }
        this.logProduction(true);
        this.powerFinished = true;
    }

    private void finishProduction() {
        for (int i = 0; i < this.factories.size(); ++i) {
            Factory factory = this.factories.get(i);
            factory.setProduction(factory.getCapacity());
        }
        this.productionFinished = true;
    }

    private void setAllContinue() {
        for (Player player : this.model.getPlayers()) {
            player.setContinue(true);
        }
        this.view.getHUDPainter().setInvertLights(false);
    }

    private void logProduction(boolean bl) {
        for (Player player : this.model.getPlayers()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                Factory factory = planetTile.getFactory();
                if (factory == null) continue;
                int n5 = 0;
                n5 = bl ? factory.getExpectedProduction() : factory.getProduction();
                switch (factory.getResource()) {
                    case Food: {
                        n += n5;
                        break;
                    }
                    case Energy: {
                        n2 += n5;
                        break;
                    }
                    case Smithore: {
                        n3 += n5;
                        break;
                    }
                    case Crystite: {
                        n4 += n5;
                    }
                }
            }
            Object object = null;
            object = bl ? "expects" : "produced";
            logger.info(player.toString() + " " + (String)object + " " + n + " food, " + n2 + " energy, " + n3 + " smithore, " + n4 + " crystite");
        }
    }
}

