/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.ai.AbstractAI;
import com.turborilla.mule.ai.DevelopmentAction;
import com.turborilla.mule.controller.DevelopmentMessenger;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.AssayBot;
import com.turborilla.mule.model.Development;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastDevelopmentPhase
extends PhaseController {
    private static Logger logger = Logger.getLogger("mule");
    private Player player;
    private AbstractAI playerAi;
    private Resource resource;
    private int tileX;
    private int tileY;
    private DevelopmentMessenger developmentMessenger = new DevelopmentMessenger();
    private AssayBot assayBot;
    private ArrayList<Actor> actors = new ArrayList();
    private DevelopmentAction nextAction;
    Timer actionTimer = new Timer(){

        public void finished() {
            if (FastDevelopmentPhase.this.controller.isServer() && !FastDevelopmentPhase.this.player.hasGambled()) {
                float f = FastDevelopmentPhase.this.nextAction();
                FastDevelopmentPhase.this.actionTimer.start(f);
            }
        }
    };
    Timer assayTimer = new Timer(){

        public void finished() {
            SoundPlayer.get().playAssayFinding();
        }
    };
    Timer outroTimer = new Timer(){

        public void finished() {
            if (FastDevelopmentPhase.this.model.getDevelopment().isLastPlayer()) {
                FastDevelopmentPhase.this.model.setNextPhase(Phase.COLONY_EVENT_A);
            } else {
                FastDevelopmentPhase.this.model.setNextPhase(Phase.PLAYER_EVENT);
            }
            for (User user : FastDevelopmentPhase.this.model.getLocalUsers()) {
                user.send(FastDevelopmentPhase.this.controller.getClient(), new TCPMessage.ReadyMessage(FastDevelopmentPhase.this.controller.getFrame()));
            }
        }
    };

    @Override
    public void begin() {
        Development development = this.model.getDevelopment();
        if (!development.hasCurrentPlayer()) {
            development.nextPlayer();
        }
        this.player = development.getCurrentPlayer();
        this.player.setGambled(false);
        this.player.setEnteredShop(false);
        if (this.controller.isServer()) {
            AIPlayerController aIPlayerController = (AIPlayerController)this.player.getController();
            this.playerAi = aIPlayerController.getAi();
        }
        this.nextAction = null;
        this.resource = null;
        this.tileX = -1;
        this.tileY = -1;
        this.model.getDevelopment().getDevelopmentTimer().start(this.player.getDevelopmentTime());
        this.model.createWampus();
        this.player.setContinue(true);
        this.view.getMapPainter().setBlinkingPlayer(null);
        this.view.setTitle("Development #" + this.model.getRound());
        this.view.fadeTerminalMessage();
        this.actionTimer.start(1.0f);
    }

    @Override
    public void draw() {
        this.view.getMapPainter().draw(this.model.getMap(), this.model.getPlayers(), this.model.getMyPlayer());
        this.actors.add(this.assayBot);
        this.view.getActorPainter().draw(this.actors);
        this.actors.clear();
        this.view.getEffectPainter().draw();
        this.view.getMessagePainter().drawSimpleTitle();
        this.view.drawTimer(this.model.getDevelopment().getTimeLeft());
    }

    @Override
    public Transition end() {
        this.player = null;
        this.playerAi = null;
        this.nextAction = null;
        return null;
    }

    @Override
    public void timerFinished(NetworkTimer networkTimer) {
    }

    @Override
    public strictfp void apply(TCPMessage.FastDevelopmentMessage fastDevelopmentMessage) {
        switch (fastDevelopmentMessage.action) {
            case PICKUP: {
                PlanetTile planetTile = (PlanetTile)this.model.getMap().getTile(fastDevelopmentMessage.tileX, fastDevelopmentMessage.tileY);
                this.resource = planetTile.getFactory().getResource();
                this.model.developLand(this.player, planetTile);
                this.model.sellMule(this.player, false);
                SoundPlayer.get().playUnbuild();
                break;
            }
            case DEVELOP: {
                PlanetTile planetTile = (PlanetTile)this.model.getMap().getTile(fastDevelopmentMessage.tileX, fastDevelopmentMessage.tileY);
                this.model.buyMule(this.player, false);
                this.model.equipMule(this.player, fastDevelopmentMessage.resource, false);
                this.model.developLand(this.player, planetTile);
                SoundPlayer.get().playBuild();
                break;
            }
            case ASSAY: {
                final PlanetTile planetTile = (PlanetTile)this.model.getMap().getTile(fastDevelopmentMessage.tileX, fastDevelopmentMessage.tileY);
                this.model.buyAssay(this.player, false);
                Vec2 vec2 = planetTile.getCenter();
                this.assayBot = new AssayBot(null);
                this.assayBot.setPosition(vec2.x - 25.0f, vec2.y + 25.0f);
                this.assayBot.assay(planetTile, new AssayBot.AssayListener(){

                    public void finished() {
                        int n = FastDevelopmentPhase.this.model.assay(FastDevelopmentPhase.this.player, planetTile, false);
                        if (n > 0) {
                            SoundPlayer.get().playAssayFinding();
                        }
                        FastDevelopmentPhase.this.developmentMessenger.assay(FastDevelopmentPhase.this.view, FastDevelopmentPhase.this.controller, FastDevelopmentPhase.this.player, n);
                        FastDevelopmentPhase.this.assayBot = null;
                        FastDevelopmentPhase.this.actionCompleted();
                    }
                });
                SoundPlayer.get().playAssay();
                return;
            }
            case CATCH_WAMPUS: {
                this.model.getWampus().setCaughtBy(this.player);
                int n = this.model.wampusReward(this.player, 0);
                SoundPlayer.get().playCatchWampus();
                this.developmentMessenger.wampusCaught(this.view, this.controller, this.player, n);
                break;
            }
            case GAMBLE: {
                float f = 0.5f * this.player.getDevelopmentTime();
                int n = this.model.gamble(this.player, f, false);
                SoundPlayer.get().playPub();
                this.developmentMessenger.gamble(this.view, this.controller, this.player, n);
                this.model.getDevelopment().getDevelopmentTimer().stop();
                this.outroTimer.start(6.0f);
                break;
            }
        }
        this.actionCompleted();
    }

    @Override
    public void update(GameInput gameInput) {
        if (this.assayBot != null) {
            this.assayBot.update();
        }
        this.model.getDevelopment().getDevelopmentTimer().tick(Properties.mule.delta);
        this.actionTimer.tick(Properties.mule.delta);
        this.outroTimer.tick(Properties.mule.delta);
    }

    public <T> boolean actionEquals(String string, Class<T> clazz) {
        return this.getAction(clazz).equals(string);
    }

    public <T> String getAction(Class<T> clazz) {
        return clazz.getSimpleName();
    }

    private float nextAction() {
        Object object;
        if (this.nextAction != null) {
            return 0.0f;
        }
        this.nextAction = this.playerAi.nextDevelopmentAction(this.model);
        if (this.nextAction == null) {
            return 0.0f;
        }
        TCPMessage.FastDevelopmentMessage.Action action = null;
        float f = 0.0f;
        logger.info("Next action: " + this.nextAction);
        if (!(this.nextAction instanceof DevelopmentAction.GoToMuleStore)) {
            if (this.nextAction instanceof DevelopmentAction.GoToOutfitStore) {
                object = (DevelopmentAction.GoToOutfitStore)this.nextAction;
                this.resource = ((DevelopmentAction.GoToOutfitStore)object).getResource();
            } else if (this.nextAction instanceof DevelopmentAction.PlaceMule) {
                object = (DevelopmentAction.PlaceMule)this.nextAction;
                this.tileX = ((DevelopmentAction.PlaceMule)object).getTile().getPosX();
                this.tileY = ((DevelopmentAction.PlaceMule)object).getTile().getPosY();
                TCPMessage.FastDevelopmentMessage.Action action2 = action = ((DevelopmentAction.PlaceMule)object).targetResource == null ? TCPMessage.FastDevelopmentMessage.Action.PICKUP : TCPMessage.FastDevelopmentMessage.Action.DEVELOP;
                if (action == TCPMessage.FastDevelopmentMessage.Action.PICKUP) {
                    this.resource = null;
                }
                f = 3.0f;
            } else if (this.nextAction instanceof DevelopmentAction.CatchWampus) {
                action = TCPMessage.FastDevelopmentMessage.Action.CATCH_WAMPUS;
                f = 4.0f;
            } else if (!(this.nextAction instanceof DevelopmentAction.GoToAssayStore)) {
                if (this.nextAction instanceof DevelopmentAction.Assay) {
                    object = (DevelopmentAction.Assay)this.nextAction;
                    this.tileX = ((DevelopmentAction.Assay)object).getTile().getPosX();
                    this.tileY = ((DevelopmentAction.Assay)object).getTile().getPosY();
                    action = TCPMessage.FastDevelopmentMessage.Action.ASSAY;
                    f = Properties.mule.assayTime + 4.0f;
                } else if (this.nextAction instanceof DevelopmentAction.GoToPub) {
                    action = TCPMessage.FastDevelopmentMessage.Action.GAMBLE;
                    f = Float.POSITIVE_INFINITY;
                } else {
                    logger.severe("Unknown AI action: " + this.nextAction);
                }
            }
        }
        if (action != null) {
            object = new TCPMessage.FastDevelopmentMessage(action, this.resource, this.tileX, this.tileY);
            this.player.send(this.controller.getClient(), (TCPMessage)object);
        } else {
            this.actionCompleted();
        }
        return f;
    }

    private void actionCompleted() {
        if (this.playerAi != null) {
            this.playerAi.developmentActionCompleted(this.model, this.nextAction);
            this.nextAction = null;
        }
    }
}

