/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.controller.phase.AbstractDevelopmentPhase;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.logging.Logger;

public class DevelopmentPhaseSingle
extends AbstractDevelopmentPhase {
    private static Logger logger = Logger.getLogger("mule");
    private boolean drawMiniAvatar;

    public void begin() {
        if (!this.model.getDevelopment().hasCurrentPlayer()) {
            this.model.getDevelopment().setPlayerOrder();
            this.model.getDevelopment().nextPlayer();
        }
        Player player = this.currentPlayer();
        logger.info("Developing player: " + player);
        this.beginDevelopment(player);
        this.drawMiniAvatar = true;
    }

    public void draw() {
        this.prepareDrawActors(false, false);
        this.drawDevelopment();
    }

    protected void drawMap() {
        if (this.drawMiniAvatar) {
            Vec2 vec2 = this.model.getMap().getShopCenter();
            Avatar avatar = this.currentPlayer().getAvatar();
            this.view.getActorPainter().drawMini(avatar, vec2);
        }
    }

    protected void onShowShop(boolean bl) {
        if (!bl) {
            this.drawMiniAvatar = false;
        }
    }

    public Transition end() {
        this.endDevelopment();
        return null;
    }

    protected void setNextPhase() {
        if (this.model.getDevelopment().isLastPlayer()) {
            this.model.setNextPhase(Phase.COLONY_EVENT_A);
        } else {
            this.model.setNextPhase(Phase.PLAYER_EVENT);
        }
    }

    public void updateUsers(GameInput gameInput) {
        this.updatePlayer(this.currentPlayer());
    }

    protected void countdownFinished() {
        Player player = this.currentPlayer();
        float f = player.getDevelopmentTime();
        this.model.getDevelopment().getDevelopmentTimer().start(f);
    }

    protected boolean isDevelopmentFinished() {
        return this.model.getDevelopment().getDevelopmentTimer().isFinished();
    }

    protected boolean canStartOutro() {
        Player player = this.currentPlayer();
        return player.getAvatar().isInShop();
    }

    private Player currentPlayer() {
        return this.model.getDevelopment().getCurrentPlayer();
    }
}

