/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.ColonyEvent;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.logging.Logger;

public class ColonyEventPhase
extends PhaseController {
    private static final Logger logger = Logger.getLogger("mule");
    private boolean categoryA;
    private ColonyEvent event;
    private boolean eventApplied;
    private boolean goingToNextPhase;

    public ColonyEventPhase(boolean bl) {
        this.categoryA = bl;
    }

    public void begin() {
        ColonyEvent.Type type = this.model.getColonyEventGenerator().getEventType(this.model);
        this.event = null;
        if (type.categoryA == this.categoryA) {
            this.event = this.model.getColonyEventGenerator().createEvent(this.model);
        }
        if (this.event != null) {
            logger.info("ColonyEvent: " + (Object)((Object)type));
            if (this.event.isApplicable()) {
                this.eventApplied = false;
                this.goingToNextPhase = false;
                this.view.beginColonyEvent(this.event, this.model);
                this.view.setTitle(this.event.getEventDescription());
            } else {
                logger.info("Colony event is not applicable.");
                this.event = null;
            }
        } else {
            logger.info("No colony event. Skipping phase.");
        }
        if (this.event == null) {
            this.model.forceUsersReady();
            this.goToNextPhase();
        } else {
            this.controller.checkClientSynchronization();
        }
    }

    public void draw() {
        ColonyEvent colonyEvent = this.model.getColonyEventGenerator().getCurrentEvent();
        this.view.getMapPainter().draw(this.model.getMap(), this.model.getPlayers(), this.model.getMyPlayer(), null, !this.categoryA);
        if (!this.categoryA) {
            this.view.getMapPainter().drawProduction(this.model.getPlayers());
        }
        this.view.drawColonyEvent(colonyEvent, this.model.getRound());
        this.view.drawBigMessage();
    }

    public Transition end() {
        this.view.fadeTerminalMessage();
        this.view.fadeTitle();
        if (this.categoryA) {
            return null;
        }
        return BlobbyTransition.createPlayAreaTransition();
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        if (this.event == null) {
            logger.severe("Invalid state. Colony event is null.");
        }
        this.view.updateColonyEvent(this.event, Properties.mule.delta);
        if (!this.eventApplied && this.view.isColonyEventAppliable(this.event)) {
            this.event.applyEvent(this.model);
            this.eventApplied = true;
        }
        if (this.view.isColonyEventFinished(this.event) && !this.goingToNextPhase) {
            this.goToNextPhase();
            for (User user : this.model.getLocalUsers()) {
                user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
            }
        }
    }

    public void goToNextPhase() {
        this.goingToNextPhase = true;
        if (this.categoryA) {
            this.model.setNextPhase(Phase.PRODUCTION);
        } else {
            this.model.setNextPhase(Phase.COLLECTION_SMITHORE);
        }
    }
}

