/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.Factory;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.AuctionPainter;
import com.turborilla.mule.view.CollectionPainter;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.ArrayList;
import java.util.logging.Logger;

public class CollectionPhase
extends PhaseController {
    private static Logger logger = Logger.getLogger("mule");
    private Resource resource;
    private boolean usageFinished;
    private boolean spoilageFinished;
    private boolean collectionFinished;
    private boolean resultFinished;
    private float previousUnitsTimer;
    private float usageTimer;
    private float currentUnitsTimer;
    private float spoilageTimer;
    private float intermediateUnitsTimer;
    private float collectionTimer;
    private float resultUnitsTimer;
    private float endTimer;
    private int maxProduction;
    private int maxUsage;
    private int maxSpoilage;
    private String title;
    private boolean showCritical;

    public CollectionPhase(Resource resource) {
        this.resource = resource;
    }

    public void begin() {
        this.controller.checkClientSynchronization();
        Shop shop = this.model.getShop();
        shop.calcBuySellPrice(this.model.getRandom(), this.model.getMap(), this.model.getPlayers(), this.resource, this.model.getRound());
        Auction auction = this.model.getAuction();
        auction.beginAuction(this.resource, shop.getBuyPrice(this.resource), shop.getSellPrice(this.resource));
        int n = auction.getCurrentLimits().getMaxOutOfAuctionTicks();
        this.maxProduction = 0;
        this.maxUsage = 0;
        this.maxSpoilage = 0;
        for (Player player : this.model.getPlayers()) {
            for (PlanetTile planetTile : player.getOwnedTiles()) {
                Factory factory = planetTile.getFactory();
                if (factory == null || factory.getResource() != this.resource) continue;
                this.maxProduction = Math.max(factory.getProduction(), this.maxProduction);
            }
            player.setBuyer(true, n);
            Avatar avatar = player.getAvatar();
            avatar.setInShop(true);
            avatar.getBigSprite().setAlwaysIdleSouth(false);
            avatar.stopWalking();
            int n2 = player.getUsage(this.resource);
            int n3 = player.calcSpoilage(this.resource);
            this.maxUsage = Math.max(this.maxUsage, n2);
            this.maxSpoilage = Math.max(this.maxSpoilage, n3);
        }
        this.usageFinished = false;
        this.spoilageFinished = false;
        this.collectionFinished = false;
        this.resultFinished = false;
        this.showCritical = false;
        this.previousUnitsTimer = Properties.mule.previousUnitsTime;
        this.usageTimer = Properties.mule.usageTime;
        this.currentUnitsTimer = Properties.mule.currentUnitsTime;
        this.spoilageTimer = Properties.mule.spoilageTime;
        this.intermediateUnitsTimer = Properties.mule.intermediateUnitsTime;
        this.collectionTimer = Properties.mule.collectionTime;
        this.resultUnitsTimer = Properties.mule.resultUnitsTime;
        this.endTimer = Properties.mule.collectionEndTime;
        if (this.resource == Resource.Crystite || this.resource == Resource.Smithore) {
            this.previousUnitsTimer = 0.0f;
            this.usageTimer = 0.0f;
            this.usageFinished = true;
            if (this.maxSpoilage == 0) {
                this.currentUnitsTimer = 0.0f;
                this.spoilageTimer = 0.0f;
                this.spoilageFinished = true;
            }
        }
        if (this.model.isLastRound() || this.resource == Resource.Crystite || this.resource == Resource.Smithore) {
            this.resultUnitsTimer = 0.0f;
            this.resultFinished = true;
            if (this.maxProduction == 0) {
                this.endTimer = this.intermediateUnitsTimer;
            }
        }
        if (this.maxProduction == 0) {
            this.collectionTimer = 0.0f;
            this.collectionFinished = true;
        }
        this.title = "Previous Amount";
        this.model.getPhaseTimer().reset();
        this.view.getCollectionPainter().begin(this.model.getPlayers(), this.resource);
        this.view.getHUDPainter().setResourceHighlight(this.resource);
        SoundPlayer.get().playBeginPhase();
        this.view.fadeTitle();
        this.view.setTerminalMessage("");
    }

    public void draw() {
        Auction auction = this.model.getAuction();
        ArrayList<Player> arrayList = this.model.getPlayersInRankOrder();
        AuctionPainter auctionPainter = this.view.getAuctionPainter2();
        CollectionPainter collectionPainter = this.view.getCollectionPainter();
        auctionPainter.drawAuction(this.resource, this.model.getRound(), true);
        auctionPainter.drawCollectionTitle(this.title);
        collectionPainter.draw(this.model, this.showCritical);
        if (this.showCritical) {
            auctionPainter.drawCritical(this.resource, this.model.getPlayers(), this.model.getRound(), this.model.getGameInfo().getLastRound());
        } else {
            collectionPainter.drawDisplayAmount(auctionPainter);
        }
        Shop shop = this.model.getShop();
        auctionPainter.drawPlayers(arrayList, auction.getCurrentLimits(), false, false, false);
        auctionPainter.drawShopPrices(this.resource, shop.getResource(this.resource), shop.getBuyPrice(this.resource), shop.getSellPrice(this.resource), null, false);
        auctionPainter.drawTimer(this.model.getPhaseTimer());
    }

    public Transition end() {
        this.view.getCollectionPainter().end();
        return null;
    }

    public void timerFinished(NetworkTimer networkTimer) {
    }

    public void update(GameInput gameInput) {
        this.view.getAuctionPainter2().update();
        CollectionPainter collectionPainter = this.view.getCollectionPainter();
        if (this.previousUnitsTimer > 0.0f) {
            this.previousUnitsTimer -= Properties.mule.delta;
            if (this.previousUnitsTimer <= 0.0f) {
                this.title = this.maxUsage == 0 ? "No Usage" : "Usage";
            }
        } else if (!this.usageFinished) {
            if (this.usageTimer > 0.0f) {
                this.usageTimer -= Properties.mule.delta;
                if (this.usageTimer <= 0.0f) {
                    this.usageTimer = 0.0f;
                    collectionPainter.targetCurrentResources();
                    if (this.maxUsage > 0) {
                        SoundPlayer.get().playCollectDown();
                    }
                }
            } else if (!collectionPainter.isAdjustingResourceBars()) {
                this.useResourceBarAmounts();
                SoundPlayer.get().stopCollectDown();
                this.usageFinished = true;
            }
        } else if (this.currentUnitsTimer > 0.0f) {
            this.currentUnitsTimer -= Properties.mule.delta;
            if (this.currentUnitsTimer <= 0.0f) {
                this.title = !this.spoilageFinished ? (this.maxSpoilage == 0 ? "No Spoilage" : "Spoilage") : (this.maxProduction == 0 ? "No Production" : "Production");
            }
        } else if (!this.spoilageFinished) {
            if (this.spoilageTimer > 0.0f) {
                this.spoilageTimer -= Properties.mule.delta;
                if (this.spoilageTimer <= 0.0f) {
                    this.spoilageTimer = 0.0f;
                    for (Player player : this.model.getPlayers()) {
                        int n = player.calcSpoilage(this.resource);
                        int n2 = player.getResource(this.resource);
                        player.setResource(this.resource, n2 - n);
                    }
                    collectionPainter.targetCurrentResources();
                    if (this.maxSpoilage > 0) {
                        SoundPlayer.get().playCollectDown();
                    }
                    this.useResourceBarAmounts();
                }
            } else if (!collectionPainter.isAdjustingResourceBars()) {
                this.useResourceBarAmounts();
                this.spoilageFinished = true;
                SoundPlayer.get().stopCollectDown();
            }
        } else if (this.intermediateUnitsTimer > 0.0f) {
            this.intermediateUnitsTimer -= Properties.mule.delta;
            if (this.intermediateUnitsTimer <= 0.0f) {
                this.title = this.maxProduction == 0 ? "No Production" : "Production";
            }
        } else if (!this.collectionFinished) {
            if (this.collectionTimer > 0.0f) {
                this.collectionTimer -= Properties.mule.delta;
                if (this.collectionTimer <= 0.0f) {
                    this.collectionTimer = 0.0f;
                    for (Player player : this.model.getPlayers()) {
                        for (PlanetTile planetTile : player.getOwnedTiles()) {
                            int n;
                            Factory factory = planetTile.getFactory();
                            if (factory == null || factory.getResource() != this.resource || (n = factory.getProduction()) == 0) continue;
                            factory.setProduction(0);
                            player.setResource(this.resource, player.getResource(this.resource) + n);
                        }
                    }
                    collectionPainter.targetCurrentResources();
                    SoundPlayer.get().playCollectUp();
                    this.useResourceBarAmounts();
                }
            } else if (!collectionPainter.isAdjustingResourceBars()) {
                this.useResourceBarAmounts();
                this.collectionFinished = true;
                SoundPlayer.get().stopCollectUp();
            }
        } else if (!this.resultFinished) {
            this.resultUnitsTimer -= Properties.mule.delta;
            if (this.resultUnitsTimer <= 0.0f) {
                if (!(this.model.isLastRound() || this.resource != Resource.Food && this.resource != Resource.Energy)) {
                    this.showCritical = true;
                    SoundPlayer.get().playShowCritical();
                    this.setCriticalText();
                }
                this.resultFinished = true;
            }
        } else if (this.endTimer > 0.0f) {
            this.endTimer -= Properties.mule.delta;
            if (this.endTimer <= 0.0f) {
                this.goToNextPhase();
            }
        }
        collectionPainter.update();
    }

    private void useResourceBarAmounts() {
        CollectionPainter collectionPainter = this.view.getCollectionPainter();
        collectionPainter.updateDisplayAmounts();
        for (Player player : this.model.getPlayers()) {
            int n = collectionPainter.getAmount(player);
            player.setResource(this.resource, n);
        }
    }

    private void setCriticalText() {
        Player player = this.model.getMyPlayer();
        int n = player.getResource(this.resource);
        int n2 = player.getResourceCritical(this.resource, this.model);
        this.title = n2 < n ? "You have a Surplus" : (n2 > n ? "You have a Shortage" : "You have Sufficient Units");
    }

    private void goToNextPhase() {
        for (Player user : this.model.getPlayers()) {
            int n = user.getResource(this.resource);
            int n2 = user.getResourceCritical(this.resource, this.model);
            int n3 = n - n2;
            logger.info(user.toString() + " " + this.resource.getName() + ": " + n + " critical: " + n2 + " surplus: " + n3 + " money: $" + user.getMoney());
        }
        this.setNextPhase();
        for (User user : this.model.getLocalUsers()) {
            user.send(this.controller.getClient(), new TCPMessage.ReadyMessage(this.controller.getFrame()));
        }
    }

    private void setNextPhase() {
        switch (this.resource) {
            case Smithore: {
                this.model.setNextPhase(Phase.AUCTION_SMITHORE);
                break;
            }
            case Crystite: {
                this.model.setNextPhase(Phase.AUCTION_CRYSTITE);
                break;
            }
            case Energy: {
                this.model.setNextPhase(Phase.AUCTION_ENERGY);
                break;
            }
            case Food: {
                this.model.setNextPhase(Phase.AUCTION_FOOD);
            }
        }
        this.collectionFinished = true;
    }
}

