/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.AuctionController;
import com.turborilla.mule.controller.phase.AbstractAuctionPhase;
import com.turborilla.mule.model.Auction;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.view.AuctionPainter;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AuctionPhase
extends AbstractAuctionPhase {
    private static Logger logger = Logger.getLogger("mule");

    public AuctionPhase(Resource resource) {
        super(new AuctionController(resource, false));
    }

    public void begin() {
        super.begin();
    }

    public void draw() {
        Resource resource = this.auctionController.getResource();
        Auction auction = this.model.getAuction();
        ArrayList<Player> arrayList = this.model.getPlayersInRankOrder();
        AuctionPainter auctionPainter = this.view.getAuctionPainter2();
        auctionPainter.drawAuction(resource, this.model.getRound(), true);
        auctionPainter.drawShopPrices(resource, this.model.getShop().getResource(this.getResource()), this.shopBuyPrice, this.shopSellPrice, auction.getCurrentLimits(), this.isStoreClosed());
        if (resource == Resource.Energy || resource == Resource.Food) {
            auctionPainter.drawCritical(resource, arrayList, this.model.getRound(), this.model.getGameInfo().getLastRound());
        } else {
            auctionPainter.drawAmount(resource, arrayList);
        }
        boolean bl = true;
        NetworkTimer networkTimer = this.model.getCountdown();
        if (this.isSkipAuction()) {
            if (this.model.isLastRound()) {
                auctionPainter.drawLastAuctionSkipped();
            } else if (networkTimer.isStarted()) {
                auctionPainter.drawNoGoodsForSale();
            } else {
                auctionPainter.drawAuctionSkipped(resource);
            }
        } else if (!networkTimer.isFinished()) {
            float f = networkTimer.getTime();
            String string = "";
            if (f <= Properties.mule.auctionCountdownTime) {
                string = "" + NetworkTimer.getTimeAsInteger(f);
            }
            auctionPainter.drawChooseBuySell(string);
            bl = false;
        } else if (this.model.getPhaseTimer().isStarted()) {
            auctionPainter.drawGoText();
        }
        auctionPainter.drawTimer(this.model.getPhaseTimer());
        boolean bl2 = !this.isSkipAuction();
        auctionPainter.drawPlayers(arrayList, auction.getCurrentLimits(), bl, bl, bl2);
    }
}

