/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.controller.AbstractAuctionController;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.AuctionState;
import com.turborilla.mule.model.Phase;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.PlotSeller;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.network.UDPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.BlinkerListener;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transition;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import org.newdawn.slick.util.Log;

public abstract class AbstractLandAuctionPhase
extends PhaseController
implements AbstractAuctionController.TransactionCountCallback {
    private static Logger logger = Logger.getLogger("mule");
    private AbstractAuctionController auctionController;
    private boolean landBought;
    private String buyTextMessage;
    private int sellLandBlinks;
    private int showBuyBlinks;
    private TCPMessage.BuyLandMessage buyLandMessage;
    private Player leader;
    private BlinkerListener saleBlinkerListener = new BlinkerListener(){

        public void blink(boolean bl) {
            if (bl) {
                if (AbstractLandAuctionPhase.this.sellLandBlinks == Properties.mule.landAuctionSellBlinks) {
                    AbstractLandAuctionPhase.this.finishSaleBlinking();
                    for (Player player : AbstractLandAuctionPhase.this.model.getLocalPlayers()) {
                        player.setContinue(true);
                        player.sendToServer(AbstractLandAuctionPhase.this.controller.getClient(), new TCPMessage.ContinueMessage());
                    }
                    if (AbstractLandAuctionPhase.this.controller.isServer()) {
                        AbstractLandAuctionPhase.this.startAuctionTimeout.start(8.0f);
                    }
                } else {
                    AbstractLandAuctionPhase.this.sellLandBlinks++;
                    SoundPlayer.get().playLandSale();
                }
            }
        }
    };
    protected Timer startAuctionTimeout = new Timer(){

        public void finished() {
            if (AbstractLandAuctionPhase.this.controller.isServer()) {
                TCPMessage.LandAuctionStartMessage landAuctionStartMessage = new TCPMessage.LandAuctionStartMessage();
                TCPMessage.SynchronizedMessage synchronizedMessage = new TCPMessage.SynchronizedMessage(landAuctionStartMessage);
                AbstractLandAuctionPhase.this.model.getMyPlayer().send(AbstractLandAuctionPhase.this.controller.getClient(), synchronizedMessage);
            }
        }
    };
    protected Timer countdown = new Timer(){

        public void finished() {
            AbstractLandAuctionPhase.this.auctionController.startAuction(Properties.mule.landAuctionTime);
            AbstractLandAuctionPhase.this.view.getAuctionPainter2().startGoText();
            SoundPlayer.get().playCountdownGo();
        }
    };
    protected Timer auctionEndStateTimer = new Timer(){

        public void finished() {
            if (AbstractLandAuctionPhase.this.controller.isServer()) {
                ArrayList<Player> arrayList = new ArrayList<Player>();
                int n = 0;
                for (Player object2 : AbstractLandAuctionPhase.this.model.getPlayersInRankOrder()) {
                    if (!object2.getAuctionState().isInAuction()) continue;
                    int n2 = object2.getAuctionState().getPrice(AbstractLandAuctionPhase.this.model.getAuction().getCurrentLimits());
                    if (n2 > n) {
                        arrayList.clear();
                        arrayList.add(object2);
                        n = n2;
                        continue;
                    }
                    if (n2 != n) continue;
                    arrayList.add(object2);
                }
                int n3 = 0;
                if (arrayList.size() > 0) {
                    if (AbstractLandAuctionPhase.this.model.getRound() == 1) {
                        Random random = new Random();
                        Player player = (Player)arrayList.get(random.nextInt(arrayList.size()));
                        n3 = player.getUserNumber();
                    } else {
                        Player player = (Player)arrayList.get(arrayList.size() - 1);
                        n3 = player.getUserNumber();
                    }
                }
                TCPMessage.BuyLandMessage buyLandMessage = new TCPMessage.BuyLandMessage(n3, n, AbstractLandAuctionPhase.this.controller.getFrame());
                AbstractLandAuctionPhase.this.model.getMyPlayer().send(AbstractLandAuctionPhase.this.controller.getClient(), buyLandMessage);
            }
            AbstractLandAuctionPhase.this.auctionController.auctionFinished();
        }
    };
    protected Timer auctionOutroTimer = new Timer(){

        public void finished() {
            AbstractLandAuctionPhase.this.showMap();
            if (AbstractLandAuctionPhase.this.landBought) {
                Player player = AbstractLandAuctionPhase.this.model.getPlotSeller().getLastBoughtLand().getOwner();
                if (player != null) {
                    AbstractLandAuctionPhase.this.view.setTerminalMessage(AbstractLandAuctionPhase.this.buyTextMessage, player, Properties.mule.developmentMessageLife);
                }
                AbstractLandAuctionPhase.this.claimEffectTimer.start(1.2f);
                AbstractLandAuctionPhase.this.view.setTitle("Land Auction #" + AbstractLandAuctionPhase.this.model.getRound());
                AbstractLandAuctionPhase.this.showBuyTimer.start(Properties.mule.landAuctionShowBuyTime);
            } else {
                AbstractLandAuctionPhase.this.showBuyTimer.start(Properties.mule.landAuctionShowNoBuyTime);
            }
        }
    };
    private Timer claimEffectTimer = new Timer(){

        public void finished() {
            if (AbstractLandAuctionPhase.this.showBuyBlinks < 4) {
                AbstractLandAuctionPhase.this.claimEffectTimer.start(0.7f);
                PlanetTile planetTile = AbstractLandAuctionPhase.this.model.getPlotSeller().getLastBoughtLand();
                AbstractLandAuctionPhase.this.view.getMapPainter().tileClaimed(planetTile, AbstractLandAuctionPhase.this.view.getEffectPainter());
                SoundPlayer.get().playLandBought();
                AbstractLandAuctionPhase.this.showBuyBlinks++;
            }
        }
    };
    protected Timer showBuyTimer = new Timer(){

        public void finished() {
            AbstractLandAuctionPhase.this.goToNextPhase();
            for (User user : AbstractLandAuctionPhase.this.model.getLocalUsers()) {
                user.send(AbstractLandAuctionPhase.this.controller.getClient(), new TCPMessage.ReadyMessage(AbstractLandAuctionPhase.this.controller.getFrame()));
            }
        }
    };
    protected Timer noSaleTimer = new Timer(){

        public void finished() {
            AbstractLandAuctionPhase.this.goToNextPhase();
            for (User user : AbstractLandAuctionPhase.this.model.getLocalUsers()) {
                user.send(AbstractLandAuctionPhase.this.controller.getClient(), new TCPMessage.ReadyMessage(AbstractLandAuctionPhase.this.controller.getFrame()));
            }
        }
    };

    public AbstractLandAuctionPhase(AbstractAuctionController abstractAuctionController) {
        this.auctionController = abstractAuctionController;
    }

    public void begin() {
        this.landBought = false;
        this.leader = null;
        PlotSeller plotSeller = this.model.getPlotSeller();
        if (plotSeller.numPlayerAuctions() == 0) {
            if (!plotSeller.hasGeneratedColonyAuctions(this.model.getRound())) {
                plotSeller.generateNextColonyAuction(this.model.getMap(), this.model.getRound());
            }
        } else {
            logger.info("Player Land Auctions: " + plotSeller.numPlayerAuctions());
        }
        this.sellLandBlinks = 0;
        this.showBuyBlinks = 0;
        this.buyLandMessage = null;
        this.noSaleTimer.reset();
        this.startAuctionTimeout.reset();
        this.auctionEndStateTimer.reset();
        this.auctionOutroTimer.reset();
        this.showBuyTimer.reset();
        this.claimEffectTimer.reset();
        this.countdown.reset();
        if (!plotSeller.hasAuction()) {
            this.auctionController.incrementAuctionId();
            String string = "No New Plots for Sale";
            this.view.setTerminalMessage(string, Properties.mule.developmentMessageLife);
            this.noSaleTimer.start(Properties.mule.landAuctionNoSaleTime);
            SoundPlayer.get().playSkipAuction();
        } else {
            Object object;
            plotSeller.beginAuction(this.model);
            int n = plotSeller.getAuctionPrice();
            int n2 = n + Properties.mule.landAuctionPriceRange;
            Player player = this.model.getPlotSeller().getAuctionTile().getOwner();
            if (player != null) {
                object = "%s Sells a Plot of Land";
                this.view.setTerminalMessage((String)object, player, Properties.mule.developmentMessageLife);
            } else {
                object = "Plot of Land for Sale";
                this.view.setTerminalMessage((String)object, Properties.mule.developmentMessageLife);
            }
            this.auctionController.begin(this.model, this.controller, SoundPlayer.get(), n, n2);
            SoundPlayer.get().trackTimer(this.model.getPhaseTimer(), Properties.mule.auctionTickTime);
            this.view.getMapPainter().getBlinker().setVisible(false);
            this.view.getMapPainter().getBlinker().addListener(this.saleBlinkerListener);
            for (Player player2 : this.model.getPlayers()) {
                player2.setContinue(false);
            }
            this.view.getHUDPainter().setLightsAlwaysVisible(true);
        }
        this.view.setTitle("Land Auction #" + this.model.getRound());
    }

    private void finishSaleBlinking() {
        this.view.getMapPainter().getBlinker().removeListener(this.saleBlinkerListener);
        this.view.fadeTitle();
        int n = this.model.getAuction().getCurrentLimits().getMaxOutOfAuctionTicks();
        for (Player player : this.model.getPlayers()) {
            player.setBuyer(true, n);
            player.getAvatar().setInShop(true);
            player.getAvatar().setBlinkType(2);
            player.getAvatar().getBlink().setSpeed(1.25f);
        }
        this.showAuction();
    }

    public void apply(TCPMessage.ContinueMessage continueMessage) {
        if (!this.controller.isServer()) {
            return;
        }
        Player player = this.model.getPlayer(continueMessage.getUserNumber());
        if (player == null) {
            return;
        }
        player.setContinue(true);
        this.checkStartAuction();
    }

    private void checkStartAuction() {
        for (Player player : this.model.getPlayers()) {
            if (player.isContinue()) continue;
            return;
        }
        this.startAuctionTimeout.stop();
    }

    public void apply(TCPMessage.LandAuctionStartMessage landAuctionStartMessage) {
        if (!this.model.getMyUser().isSpectator() && !this.model.getMyPlayer().isContinue()) {
            logger.info("Got land auction start before finishing blinking");
            this.finishSaleBlinking();
        }
        for (Player player : this.model.getPlayers()) {
            player.setContinue(true);
        }
        this.view.getHUDPainter().setLightsAlwaysVisible(false);
        float f = Properties.mule.landAuctionPauseTime + Properties.mule.auctionCountdownTime;
        this.countdown.start(f);
        SoundPlayer.get().trackCountdown(this.countdown, (int)Properties.mule.auctionCountdownTime);
    }

    public final void timerFinished(NetworkTimer networkTimer) {
        if (networkTimer == this.model.getPhaseTimer()) {
            SoundPlayer.get().stopTicking();
            SoundPlayer.get().playAuctionEnded();
        }
    }

    public void update(GameInput gameInput) {
        this.view.getAuctionPainter2().update();
        this.view.getEffectPainter().update();
        Object object = this.model.getPlayers().iterator();
        while (object.hasNext()) {
            Player player = object.next();
            player.getAvatar().getBlink().update();
        }
        if (!this.countdown.isStarted()) {
            this.noSaleTimer.tick(Properties.mule.delta);
            if (!this.startAuctionTimeout.isFinished()) {
                this.startAuctionTimeout.tick(Properties.mule.delta);
                if (this.startAuctionTimeout.isFinished()) {
                    logger.warning("Land auction start timed out");
                }
            }
        } else if (!this.countdown.isFinished()) {
            this.countdown.tick(Properties.mule.delta);
        } else if (!this.auctionEndStateTimer.isFinished()) {
            this.auctionController.update(gameInput);
            this.blinkLeader();
            object = this.model.getPhaseTimer();
            if (!this.auctionEndStateTimer.isStarted()) {
                if (((NetworkTimer)object).isStarted() && ((NetworkTimer)object).getTime() < Properties.mule.landAuctionStopWalkTime) {
                    Log.info("Local players finished auction");
                    for (Player player : this.model.getLocalPlayers()) {
                        player.setFinishedAuction(true);
                    }
                    this.auctionEndStateTimer.start(6.0f);
                }
            } else {
                boolean bl = true;
                for (Player player : this.model.getRemotePlayers()) {
                    if (player.isFinishedAuction() && player.getAuctionState().equals(player.getTargetAuctionState())) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    logger.info("Reached final auction state");
                    this.auctionEndStateTimer.stop();
                } else {
                    this.auctionEndStateTimer.tick(Properties.mule.delta);
                    if (this.auctionEndStateTimer.isFinished()) {
                        logger.warning("Did not reach final auction state");
                    }
                }
            }
        } else {
            if (this.controller.isServer()) {
                this.auctionController.sendTotalAuctionState();
            }
            if (((NetworkTimer)(object = this.model.getPhaseTimer())).isFinished()) {
                if (this.buyLandMessage != null) {
                    this.buyLand(this.buyLandMessage);
                    this.buyLandMessage = null;
                }
                this.auctionOutroTimer.tick(Properties.mule.delta);
                this.showBuyTimer.tick(Properties.mule.delta);
                this.claimEffectTimer.tick(Properties.mule.delta);
            }
        }
    }

    private void blinkLeader() {
        Player player = null;
        int n = Integer.MIN_VALUE;
        for (Player player2 : this.model.getPlayersInRankOrder()) {
            int n2;
            AuctionState auctionState = player2.getAuctionState();
            if (!auctionState.isInAuction() || (n2 = auctionState.getPrice(this.model.getAuction().getCurrentLimits())) < n) continue;
            player = player2;
            n = n2;
        }
        if (player != this.leader) {
            if (this.leader != null) {
                this.leader.getAvatar().getBlink().end();
            }
            if (player != null) {
                player.getAvatar().getBlink().blinkRepeat();
            }
            this.leader = player;
        }
    }

    public void apply(TCPMessage.BuyLandMessage buyLandMessage) {
        this.buyLandMessage = buyLandMessage;
    }

    private void buyLand(TCPMessage.BuyLandMessage buyLandMessage) {
        if (this.leader != null) {
            this.leader.getAvatar().getBlink().end();
        }
        Player player = this.model.getPlayer(buyLandMessage.buyerUserNumber);
        this.landBought = this.model.getPlotSeller().finishAuction(player, buyLandMessage.price, this.model.getMap());
        if (this.landBought) {
            SoundPlayer.get().playTransactionEnded();
            this.buyTextMessage = "%s bought the plot for $" + buyLandMessage.price;
            logger.info(player.toString() + " bought the plot for $" + buyLandMessage.price);
            player.getAvatar().getBlink().setSpeed(3.0f);
            player.getAvatar().setBlinkType(1);
            player.getAvatar().getBlink().blink();
        }
        this.auctionOutroTimer.start(4.0f);
    }

    public void apply(UDPMessage.TotalAuctionStateMessage totalAuctionStateMessage) {
        this.auctionController.apply(totalAuctionStateMessage);
    }

    public void apply(UDPMessage.PlayerAuctionStateMessage playerAuctionStateMessage) {
        this.auctionController.apply(playerAuctionStateMessage, this);
    }

    private void goToNextPhase() {
        for (Player player : this.model.getPlayers()) {
            player.getAvatar().setBlinkType(1);
            player.getAvatar().getBlink().setSpeed(3.0f);
        }
        PlotSeller plotSeller = this.model.getPlotSeller();
        if (!plotSeller.hasGeneratedColonyAuctions(this.model.getRound())) {
            this.model.setNextPhase(Phase.LAND_AUCTION);
        } else if (this.landBought && plotSeller.generateNextColonyAuction(this.model.getMap(), this.model.getRound())) {
            this.model.setNextPhase(Phase.LAND_AUCTION);
        } else {
            plotSeller.clearAuctions();
            this.model.setNextPhase(Phase.PLAYER_EVENT);
        }
    }

    public Transition end() {
        this.auctionController.end();
        return null;
    }

    public void playerTransactionCount() {
    }

    protected abstract void showAuction();

    protected abstract void showMap();
}

