/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.mule.controller.phase;

import com.turborilla.mule.Properties;
import com.turborilla.mule.ai.AIPlayerController;
import com.turborilla.mule.ai.PathFinder;
import com.turborilla.mule.ai.search.SearchAI;
import com.turborilla.mule.controller.DevelopmentMessenger;
import com.turborilla.mule.controller.PlayerController;
import com.turborilla.mule.controller.PlayerControllerState;
import com.turborilla.mule.controller.TargetPlayerController;
import com.turborilla.mule.controller.WampusMenu;
import com.turborilla.mule.controller.phase.PhaseController;
import com.turborilla.mule.model.Actor;
import com.turborilla.mule.model.AssayBot;
import com.turborilla.mule.model.Avatar;
import com.turborilla.mule.model.AvatarCommandStream;
import com.turborilla.mule.model.Collidable;
import com.turborilla.mule.model.CollisionDetector;
import com.turborilla.mule.model.CollisionResolver;
import com.turborilla.mule.model.LabItem;
import com.turborilla.mule.model.Mule;
import com.turborilla.mule.model.Player;
import com.turborilla.mule.model.Resource;
import com.turborilla.mule.model.Shop;
import com.turborilla.mule.model.User;
import com.turborilla.mule.model.map.PlanetMap;
import com.turborilla.mule.model.map.PlanetTile;
import com.turborilla.mule.model.util.AbstractTimer;
import com.turborilla.mule.model.util.NetworkTimer;
import com.turborilla.mule.model.util.Timer;
import com.turborilla.mule.model.util.Vec2;
import com.turborilla.mule.network.TCPMessage;
import com.turborilla.mule.sound.SoundPlayer;
import com.turborilla.mule.view.BlobbyTransition;
import com.turborilla.mule.view.GameInput;
import com.turborilla.mule.view.Transitionable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class AbstractDevelopmentPhase
extends PhaseController {
    private Logger logger = Logger.getLogger("mule");
    protected Player focusPlayer;
    private CollisionDetector enterShopDetector;
    private CollisionDetector returnToShopDetector;
    private CollisionDetector exitShopDetector;
    private CollisionDetector wallDetector;
    private CollisionDetector boundaryDetector;
    private CollisionDetector enterStoreDetector;
    private CollisionResolver.AvatarWallCollision avatarWallCollision = new CollisionResolver.AvatarWallCollision();
    private ArrayList<Actor> opaqueActorsShop = new ArrayList();
    private ArrayList<Actor> opaqueActorsMap = new ArrayList();
    private ArrayList<Actor> transparentActorsShop = new ArrayList();
    private ArrayList<Actor> transparentActorsMap = new ArrayList();
    private BlobbyTransition transition;
    private boolean showShop;
    private HashMap<Player, PlayerControl> playerControls;
    private WampusMenu wampusMenu = new WampusMenu();
    private long nextMuleWhinny;
    private DevelopmentMessenger developmentMessenger = new DevelopmentMessenger();
    Transitionable prevView;
    Transitionable currentView;
    private Transitionable mapPainter = new Transitionable(){

        public void draw() {
            AbstractDevelopmentPhase.this.view.getMapPainter().draw(AbstractDevelopmentPhase.this.model.getMap(), AbstractDevelopmentPhase.this.model.getPlayers(), AbstractDevelopmentPhase.this.model.getMyPlayer());
            AbstractDevelopmentPhase.this.view.getEffectPainter().draw();
            AbstractDevelopmentPhase.this.view.drawWampus(AbstractDevelopmentPhase.this.model.getWampus());
            AbstractDevelopmentPhase.this.view.getActorPainter().draw(AbstractDevelopmentPhase.this.opaqueActorsMap, AbstractDevelopmentPhase.this.transparentActorsMap);
            AbstractDevelopmentPhase.this.view.getArrowPainter().draw(AbstractDevelopmentPhase.this.model.getMap().getShopCenter());
            AbstractDevelopmentPhase.this.view.getMenuPainter().drawWampusMenu(AbstractDevelopmentPhase.this.wampusMenu);
            AbstractDevelopmentPhase.this.view.getMessagePainter().drawSimpleTitle();
            AbstractDevelopmentPhase.this.drawMap();
        }
    };
    private Transitionable shopPainter = new Transitionable(){

        public void draw() {
            boolean bl = AbstractDevelopmentPhase.this.focusPlayer.getAvatar().getAssayBot() == null;
            AbstractDevelopmentPhase.this.view.getShopPainter().draw(AbstractDevelopmentPhase.this.model.getShop(), bl);
            AbstractDevelopmentPhase.this.view.getActorPainter().draw(AbstractDevelopmentPhase.this.opaqueActorsShop, AbstractDevelopmentPhase.this.transparentActorsShop);
            AbstractDevelopmentPhase.this.view.getShopPainter().drawTerminalBackground();
            AbstractDevelopmentPhase.this.view.drawFloatingMessages();
        }
    };
    private Timer outroBlobTimer = new Timer(){

        public void finished() {
            for (Player player : AbstractDevelopmentPhase.this.model.getPlayers()) {
                Mule mule = player.getAvatar().getMule();
                if (mule == null) continue;
                Vec2 vec2 = AbstractDevelopmentPhase.this.model.getMap().getShopCenter();
                mule.setPosition(vec2.x + 36.0f, vec2.y);
                mule.setInShop(false);
                mule.runAway();
            }
            AbstractDevelopmentPhase.this.view.fadeTerminalMessage();
            AbstractDevelopmentPhase.this.showShop(false);
            AbstractDevelopmentPhase.this.startOutroIfDone();
        }
    };
    private Timer outroTimer = new Timer(){

        public void finished() {
            AbstractDevelopmentPhase.this.view.fadeTerminalMessage();
            for (User user : AbstractDevelopmentPhase.this.model.getLocalUsers()) {
                user.send(AbstractDevelopmentPhase.this.controller.getClient(), new TCPMessage.ReadyMessage(AbstractDevelopmentPhase.this.controller.getFrame()));
            }
            AbstractDevelopmentPhase.this.setNextPhase();
        }
    };

    protected void beginDevelopment(Player player) {
        this.focusPlayer = player;
        PlanetMap planetMap = this.model.getMap();
        this.model.createWampus();
        this.randomWhinnyTime();
        this.playerControls = new HashMap();
        for (Player player2 : this.model.getPlayers()) {
            player2.setGambled(false);
            player2.setEnteredShop(false);
            Avatar avatar = player2.getAvatar();
            avatar.setPosition(this.model.getShop().getStartLocation());
            avatar.getBigSprite().setAlwaysIdleSouth(true);
            this.playerControls.put(player2, new PlayerControl(player2, planetMap));
        }
        this.model.getDevelopment().getDevelopmentTimer().reset();
        this.wampusMenu.hide();
        this.enterShopDetector = new CollisionDetector(null, planetMap.getShopCollision(), new EnterShopCallback());
        this.returnToShopDetector = new CollisionDetector(null, planetMap.getShopCollision(), new ReturnToShopCallback());
        this.exitShopDetector = new CollisionDetector(null, this.model.getShop().getExits(), new ExitShopCallback());
        this.wallDetector = new CollisionDetector(null, this.model.getShop().getWalls(), this.avatarWallCollision);
        this.boundaryDetector = new CollisionDetector(null, planetMap.getBoundaryCollision(), this.avatarWallCollision);
        this.enterStoreDetector = new CollisionDetector(null, this.model.getShop().getAllStores(), new EnterStoreCallback());
        this.showShop = false;
        this.prevView = this.shopPainter;
        this.currentView = this.mapPainter;
        this.outroBlobTimer.reset();
        this.outroTimer.reset();
        float f = Properties.mule.developmentCountdown;
        this.model.getCountdown().reset();
        this.model.getCountdown().start(f, this.controller.getClient());
        SoundPlayer.get().trackCountdown(this.model.getCountdown(), (int)Properties.mule.developmentCountdown);
        this.view.setTitleEnabled(false);
        this.view.setTitle("Development #" + this.model.getRound());
        this.view.fadeTerminalMessage();
    }

    private void randomWhinnyTime() {
        long l = Properties.mule.muleWhinnyTimeMax;
        long l2 = Properties.mule.muleWhinnyTimeMin;
        float f = this.view.getRandom().nextFloat();
        long l3 = l2 + (long)(f * (float)(l - l2));
        this.nextMuleWhinny = System.currentTimeMillis() + l3;
    }

    public final void update(GameInput gameInput) {
        this.view.getArrowPainter().update(Properties.mule.delta);
        if (this.transition != null) {
            this.transition.update(Properties.mule.delta);
        }
        if (System.currentTimeMillis() >= this.nextMuleWhinny) {
            Mule mule = this.focusPlayer.getAvatar().getMule();
            if (mule != null && !mule.isOutfitting() && !mule.isRunningAway()) {
                SoundPlayer.get().playMuleWhinny();
            }
            this.randomWhinnyTime();
        }
        this.updateUsers(gameInput);
        for (int i = 0; i < this.model.getMules().size(); ++i) {
            Mule mule = this.model.getMules().get(i);
            if (!mule.isRunningAway()) continue;
            mule.update();
            if (!mule.isOutsideMap()) continue;
            this.model.removeMule(mule);
            --i;
            this.startOutroIfDone();
        }
        this.outroBlobTimer.tick(Properties.mule.delta);
        this.outroTimer.tick(Properties.mule.delta);
    }

    protected abstract void updateUsers(GameInput var1);

    /*
     * Enabled aggressive block sorting
     */
    public void updatePlayer(Player player) {
        PlayerControl playerControl = this.playerControls.get(player);
        Avatar avatar = player.getAvatar();
        Timer timer = this.model.getDevelopment().getDevelopmentTimer();
        if (!playerControl.isFinished) {
            PlayerController playerController;
            block27: {
                Serializable serializable;
                if (!timer.isStarted()) {
                    return;
                }
                playerController = null;
                if (playerControl.isRemote) {
                    serializable = playerControl.remoteCommands;
                    if (((AvatarCommandStream)serializable).update(playerControl.update)) {
                        playerController = serializable;
                        break block27;
                    } else {
                        if (!this.controller.isServer()) return;
                        if (player.getController().isRemote()) return;
                        if (playerControl.update > ((AvatarCommandStream)serializable).getEndUpdate()) {
                            playerControl.isRemote = false;
                            return;
                        }
                        if (!((AvatarCommandStream)serializable).isBuffering()) return;
                        ((AvatarCommandStream)serializable).stopBuffering();
                        return;
                    }
                }
                playerController = player.getController();
                serializable = playerControl.buttonState;
                long l = playerControl.update - playerControl.sentCommandFrame;
                if (timer.isFinished()) {
                    playerControl.finishUpdate = playerControl.update;
                    player.sendToOthers(this.controller.getClient(), new TCPMessage.AvatarFinishMessage(playerControl.update));
                    this.logger.info("My user " + player + " finishes on update " + playerControl.update);
                } else if (playerController.isActionButtonPressed() || ((PlayerControllerState)serializable).isUp() != playerController.isUp() || ((PlayerControllerState)serializable).isDown() != playerController.isDown() || ((PlayerControllerState)serializable).isLeft() != playerController.isLeft() || ((PlayerControllerState)serializable).isRight() != playerController.isRight()) {
                    TCPMessage.AvatarActionMessage avatarActionMessage = new TCPMessage.AvatarActionMessage(playerController.isUp(), playerController.isDown(), playerController.isLeft(), playerController.isRight(), playerController.isActionButtonPressed(), playerControl.update);
                    player.sendToOthers(this.controller.getClient(), avatarActionMessage);
                    playerControl.sentCommandFrame = playerControl.update;
                    ((PlayerControllerState)serializable).setUp(playerController.isUp());
                    ((PlayerControllerState)serializable).setDown(playerController.isDown());
                    ((PlayerControllerState)serializable).setLeft(playerController.isLeft());
                    ((PlayerControllerState)serializable).setRight(playerController.isRight());
                } else if (l > Properties.mule.sendAvatarCommandsInterval) {
                    TCPMessage.AvatarPassiveMessage avatarPassiveMessage = new TCPMessage.AvatarPassiveMessage(playerControl.update);
                    player.sendToOthers(this.controller.getClient(), avatarPassiveMessage);
                    playerControl.sentCommandFrame = playerControl.update;
                }
            }
            if (playerControl.finishUpdate != -1L && playerControl.update >= playerControl.finishUpdate) {
                this.playerFinished(player);
                return;
            }
            if (!this.wampusMenu.isVisible()) {
                timer.tick(Properties.mule.delta);
            }
            this.model.getWampus().update(playerControl.update, !this.isShowShop() ? SoundPlayer.get() : null);
            if (avatar.isInShop()) {
                if (player.isOutfittingMule() || player.hasGambled()) {
                    this.updateAvatar(player, null);
                } else {
                    this.updateAvatar(player, playerController);
                }
                this.wallDetector.setCollisionSetA(playerControl.avatarCollision);
                this.wallDetector.checkCollisions();
                this.enterStoreDetector.setCollisionSetA(playerControl.avatarCollision);
                this.enterStoreDetector.checkCollisions();
                float f = avatar.getPosition().x;
                float f2 = avatar.getPosition().y;
                Shop shop = this.model.getShop();
                if (shop.getAllStores().contains(f, f2)) {
                    if (!player.hasEnteredShop()) {
                        player.setEnteredShop(true);
                        this.enterStore(player, f, f2);
                    }
                } else {
                    player.setEnteredShop(false);
                }
                this.exitShopDetector.setCollisionSetA(playerControl.avatarCollision);
                this.exitShopDetector.checkCollisions();
                if (playerController.isActionButtonPressed()) {
                    SoundPlayer.get().playButtonPressFailed();
                }
            } else {
                if (player.isAssaying()) {
                    this.updateAvatar(player, null);
                } else if (this.wampusMenu.isVisible()) {
                    this.wampusMenu.update(playerController, this.model.getWampus(), this.controller.getClient(), SoundPlayer.get());
                    this.updateAvatar(player, null);
                } else {
                    this.updateAvatar(player, playerController);
                    if (playerController.isActionButtonPressed()) {
                        float f = avatar.getPosition().x;
                        float f3 = avatar.getPosition().y;
                        this.action(player, f, f3, avatar.isInShop());
                    }
                }
                this.boundaryDetector.setCollisionSetA(playerControl.avatarCollision);
                this.boundaryDetector.checkCollisions();
                this.enterShopDetector.setCollisionSetA(playerControl.avatarCollision);
                this.enterShopDetector.checkCollisions();
            }
            ++playerControl.update;
            return;
        }
        if (!avatar.isInShop()) {
            playerControl.targetController.update();
            this.updateAvatar(player, playerControl.targetController);
            this.returnToShopDetector.setCollisionSetA(playerControl.avatarCollision);
            this.returnToShopDetector.checkCollisions();
            return;
        }
        this.updateAvatar(player, null);
    }

    protected void endDevelopment() {
        this.view.setTitleEnabled(true);
        this.model.removeAllMules();
        for (Player player : this.model.getPlayers()) {
            player.getAvatar().setAssayBot(null);
            player.setLabItem(LabItem.NONE);
            player.setSellLand(false);
        }
        this.playerControls.clear();
        this.playerControls = null;
    }

    public void apply(TCPMessage.AvatarActionMessage avatarActionMessage) {
        Player player = this.model.getPlayer(avatarActionMessage.getUserNumber());
        PlayerControl playerControl = this.playerControls.get(player);
        playerControl.remoteCommands.add(avatarActionMessage);
    }

    public void apply(TCPMessage.AvatarPassiveMessage avatarPassiveMessage) {
        Player player = this.model.getPlayer(avatarPassiveMessage.getUserNumber());
        PlayerControl playerControl = this.playerControls.get(player);
        playerControl.remoteCommands.add(avatarPassiveMessage);
    }

    public void apply(TCPMessage.AvatarFinishMessage avatarFinishMessage) {
        Player player = this.model.getPlayer(avatarFinishMessage.getUserNumber());
        PlayerControl playerControl = this.playerControls.get(player);
        playerControl.remoteCommands.add(avatarFinishMessage);
        playerControl.finishUpdate = avatarFinishMessage.update;
        this.logger.info("Remote " + player + " finishes on update " + avatarFinishMessage.update);
    }

    private void enterStore(Player player, float f, float f2) {
        Shop shop = this.model.getShop();
        boolean bl = player == this.focusPlayer;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (shop.getMuleStore().contains(f, f2)) {
            this.view.enterMuleStore();
            player.setSellLand(false);
            if (player.getAvatar().getMule() == null) {
                bl2 = this.model.buyMule(player, bl);
                if (bl2 && bl) {
                    SoundPlayer.get().playBuyMule();
                    if (player == this.focusPlayer) {
                        this.randomWhinnyTime();
                    }
                }
            } else {
                bl2 = bl4 = this.model.sellMule(player, bl);
            }
        } else if (shop.getFoodStore().contains(f, f2)) {
            bl2 = bl3 = this.model.equipMule(player, Resource.Food, bl);
        } else if (shop.getEnergyStore().contains(f, f2)) {
            bl2 = bl3 = this.model.equipMule(player, Resource.Energy, bl);
        } else if (shop.getSmithoreStore().contains(f, f2)) {
            bl2 = bl3 = this.model.equipMule(player, Resource.Smithore, bl);
        } else if (shop.getCrystiteStore().contains(f, f2)) {
            bl2 = bl3 = this.model.equipMule(player, Resource.Crystite, bl);
        } else if (shop.getAssay().contains(f, f2)) {
            player.setSellLand(false);
            if (player.getAvatar().getAssayBot() == null) {
                bl2 = this.model.buyAssay(player, bl);
                if (bl2 && bl) {
                    SoundPlayer.get().playBuyAssay();
                }
            } else {
                bl2 = bl4 = this.model.sellAssay(player, bl);
            }
            if (bl2) {
                player.getAvatar().getBlink().blink();
            }
        } else if (shop.getLand().contains(f, f2)) {
            if (player.getAvatar().getMule() == null) {
                this.model.setSellLand(player, bl);
                bl2 = true;
                bl4 = !player.isSellingLand();
                player.getAvatar().getBlink().blink();
            }
        } else if (shop.getPub().contains(f, f2)) {
            if (player.getAvatar().getMule() == null) {
                this.gamble(player);
            } else {
                bl2 = false;
            }
        }
        if (bl2 && bl) {
            SoundPlayer soundPlayer = SoundPlayer.get();
            soundPlayer.stopStepsShop();
            if (bl3) {
                soundPlayer.playBuy();
                soundPlayer.playOutfitMule();
            } else if (bl4) {
                soundPlayer.playSell();
            } else {
                soundPlayer.playBuy();
            }
        }
    }

    public void gamble(Player player) {
        Timer timer = this.model.getDevelopment().getDevelopmentTimer();
        int n = this.model.gamble(player, timer.getTime(), player == this.focusPlayer);
        timer.stop();
        this.developmentMessenger.gamble(this.view, this.controller, player, n);
        if (player == this.focusPlayer) {
            SoundPlayer.get().stopTicking();
            SoundPlayer.get().stopStepsMap();
            SoundPlayer.get().stopStepsShop();
            SoundPlayer.get().playPub();
        }
    }

    public void action(final Player player, float f, float f2, boolean bl) {
        boolean bl2 = false;
        final PlanetTile planetTile = this.model.getMap().getTileAtPosition(f, f2);
        if (bl) {
            bl2 = false;
        } else if (player.isSellingLand()) {
            bl2 = this.model.getPlotSeller().sellLand(player, planetTile);
            if (bl2) {
                this.view.getMapPainter().tileSold(planetTile, this.view.getEffectPainter());
                String string = "%s Sells a Plot of Land";
                this.view.setTerminalMessage(string, player, Properties.mule.developmentMessageLife);
                if (player == this.focusPlayer) {
                    SoundPlayer.get().playClaimLand();
                }
            }
        } else if (player.isMoveHomeBase() && planetTile != null && planetTile.getOwner() == player) {
            bl2 = player.moveHomeBaseTo(planetTile);
        } else if (player.getAvatar().getAssayBot() != null) {
            if (planetTile == null || this.model.isAssayedBy(player, planetTile)) {
                bl2 = false;
            } else {
                player.getAvatar().getAssayBot().assay(planetTile, new AssayBot.AssayListener(){

                    public void finished() {
                        AbstractDevelopmentPhase.this.assay(player, planetTile);
                    }
                });
                if (player == this.focusPlayer) {
                    SoundPlayer.get().playAssay();
                }
                bl2 = true;
            }
        } else if (player.getAvatar().getMule() == null && planetTile != null && planetTile.getOwner() == null) {
            bl2 = this.huntWampus(player, f, f2);
        } else if (!this.model.allowDevelop(player, planetTile)) {
            this.view.setTerminalMessage("No Mining Allowed on River", player, Properties.mule.developmentMessageLife);
            bl2 = false;
        } else {
            bl2 = this.model.developLand(player, planetTile);
            if (bl2) {
                if (player == this.focusPlayer) {
                    if (planetTile.getBuildings().isEmpty()) {
                        SoundPlayer.get().playUnbuild();
                    } else {
                        SoundPlayer.get().playBuild();
                    }
                }
            } else {
                Mule mule = player.getAvatar().getMule();
                if (mule != null) {
                    mule.runAway();
                    if (player == this.focusPlayer) {
                        SoundPlayer.get().playFreeMule();
                        this.randomWhinnyTime();
                    }
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            SoundPlayer.get().playButtonPressFailed();
        }
    }

    public void assay(Player player, PlanetTile planetTile) {
        if (!planetTile.isAssayedBy(player)) {
            int n;
            Resource resource = this.model.dig(player, planetTile);
            if (resource == Resource.Crystite) {
                this.logger.info(player.toString() + " dug up " + (Object)((Object)resource));
                if (player == this.focusPlayer) {
                    player.getAvatar().getBlink().blink();
                    SoundPlayer.get().playAssayDigUp();
                }
            }
            if ((n = this.model.assay(player, planetTile, player == this.focusPlayer)) != 0 && player == this.focusPlayer) {
                SoundPlayer.get().playAssayFinding();
            }
            this.developmentMessenger.assay(this.view, this.controller, player, n);
        }
    }

    public boolean huntWampus(Player player, float f, float f2) {
        if (this.model.getWampus().canBeCaughtAt(f, f2)) {
            this.model.wampusCaught(player, this.wampusMenu);
            this.wampusMenu.show(player, this.model.getWampus());
            if (player == this.focusPlayer) {
                SoundPlayer.get().playCatchWampus();
            }
            int n = this.model.wampusReward(player, 0);
            this.developmentMessenger.wampusCaught(this.view, this.controller, player, n);
            return true;
        }
        return false;
    }

    public void prepareDrawActors(boolean bl, boolean bl2) {
        this.opaqueActorsShop.clear();
        this.opaqueActorsMap.clear();
        this.transparentActorsShop.clear();
        this.transparentActorsMap.clear();
        for (Player serializable : this.model.getPlayers()) {
            ArrayList<Actor> arrayList;
            ArrayList<Actor> arrayList2;
            if (serializable == this.focusPlayer) {
                arrayList2 = this.opaqueActorsShop;
                arrayList = this.opaqueActorsMap;
            } else {
                if (!bl) continue;
                if (bl2) {
                    arrayList2 = this.transparentActorsShop;
                    arrayList = this.transparentActorsMap;
                } else {
                    arrayList2 = this.opaqueActorsShop;
                    arrayList = this.opaqueActorsMap;
                }
            }
            Avatar avatar = serializable.getAvatar();
            AssayBot assayBot = avatar.getAssayBot();
            if (avatar.isInShop()) {
                arrayList2.add(avatar);
            } else {
                arrayList.add(avatar);
            }
            if (assayBot == null) continue;
            if (assayBot.isInShop()) {
                arrayList2.add(assayBot);
                continue;
            }
            arrayList.add(assayBot);
        }
        for (Mule mule : this.model.getMules()) {
            if (mule.isInShop()) {
                this.opaqueActorsShop.add(mule);
                continue;
            }
            this.opaqueActorsMap.add(mule);
        }
    }

    public void drawDevelopment() {
        Object object;
        Object object2;
        this.view.drawTransition(this.transition, this.prevView, this.currentView);
        if (Properties.mule.debugPathFinding) {
            this.view.getPathFindingPainter().draw(this.model.getMap(), this.model.getAiSystem().getPathFindingGraph(), this.showShop);
            if (this.model.getGameInfo().isSingleDevelopment()) {
                object2 = this.model.getDevelopment().getCurrentPlayer();
                this.drawPathFinding((Player)object2);
            } else {
                object2 = this.model.getPlayers().iterator();
                while (object2.hasNext()) {
                    object = (Player)object2.next();
                    this.drawPathFinding((Player)object);
                }
            }
        }
        if (!((NetworkTimer)(object2 = this.model.getCountdown())).isFinished()) {
            if (((NetworkTimer)object2).getTime() < Properties.mule.developmentCountdown) {
                int n = ((AbstractTimer)object2).getTimeAsInteger();
                if (this.model.getGameInfo().isSingleDevelopment()) {
                    this.view.setTerminalMessage(this.focusPlayer.getHudName() + " starts in " + n);
                } else {
                    this.view.setTerminalMessage("DEVELOPMENT IN " + n);
                }
            }
            if (this.model.getGameInfo().isSingleDevelopment() || !this.model.getMyUser().isSpectator()) {
                this.view.drawTimer(this.focusPlayer.getDevelopmentTime());
            }
        } else if (this.model.getGameInfo().isSingleDevelopment() || !this.model.getMyUser().isSpectator()) {
            object = this.model.getDevelopment().getDevelopmentTimer();
            this.view.drawTimer(((Timer)object).getTime());
        }
        this.view.drawBigMessage();
    }

    protected abstract void drawMap();

    private void drawPathFinding(Player player) {
        SearchAI searchAI;
        PathFinder.Path path;
        AIPlayerController aIPlayerController;
        if (player.getController() instanceof AIPlayerController && (aIPlayerController = (AIPlayerController)player.getController()).getAi() instanceof SearchAI && (path = (searchAI = (SearchAI)aIPlayerController.getAi()).getPathWalker().getPath()) != null) {
            this.view.getPathFindingPainter().draw(path, this.showShop);
        }
    }

    private void updateAvatar(Player player, PlayerController playerController) {
        Object object;
        Avatar avatar = player.getAvatar();
        CollisionDetector.CollisionSet collisionSet = null;
        if (!avatar.isInShop()) {
            object = avatar.getPosition();
            PlanetTile planetTile = this.model.getMap().getTileAtPosition(((Vec2)object).x, ((Vec2)object).y);
            collisionSet = planetTile.getCollisionSet();
        }
        if (playerController == null) {
            avatar.updateLocal(false, false, false, false, collisionSet);
        } else {
            avatar.updateLocal(playerController.isUp(), playerController.isDown(), playerController.isRight(), playerController.isLeft(), collisionSet);
        }
        if (player == this.focusPlayer) {
            object = SoundPlayer.get();
            if (avatar.isWalking()) {
                if (avatar.isInShop()) {
                    ((SoundPlayer)object).loopStepsShop();
                    ((SoundPlayer)object).stopStepsMap();
                } else {
                    ((SoundPlayer)object).loopStepsMap();
                    ((SoundPlayer)object).stopStepsShop();
                }
            } else {
                ((SoundPlayer)object).stopStepsShop();
                ((SoundPlayer)object).stopStepsMap();
            }
        }
    }

    protected final void showShop(boolean bl) {
        if (this.showShop != bl) {
            this.showShop = bl;
            if (this.showShop) {
                this.prevView = this.mapPainter;
                this.currentView = this.shopPainter;
            } else {
                this.prevView = this.shopPainter;
                this.currentView = this.mapPainter;
            }
            this.transition = BlobbyTransition.createPlayAreaTransition();
            this.onShowShop(bl);
        }
    }

    protected abstract void onShowShop(boolean var1);

    protected final boolean isShowShop() {
        return this.showShop;
    }

    public void timerFinished(NetworkTimer networkTimer) {
        if (networkTimer == this.model.getCountdown()) {
            if (this.focusPlayer.getAvatar().isInShop()) {
                this.showShop(true);
            }
            Timer timer = this.model.getDevelopment().getDevelopmentTimer();
            SoundPlayer.get().playCountdownGo();
            SoundPlayer.get().trackTimer(timer, Properties.mule.developmentTickTime);
            this.view.setTerminalMessage("");
            Player player = this.model.getDevelopment().getCurrentPlayer();
            player.setContinue(true);
            this.view.getMapPainter().setBlinkingPlayer(null);
            this.countdownFinished();
        }
    }

    private void playerFinished(Player player) {
        AssayBot assayBot;
        if (player == this.focusPlayer) {
            SoundPlayer.get().stopTicking();
            if (!player.hasGambled()) {
                SoundPlayer.get().playAuctionEnded();
                this.view.setBigMessage("TIME UP");
            }
            if (player.getAvatar().isInShop()) {
                this.outroBlobTimer.start(3.0f);
            }
            this.wampusMenu.hide();
        }
        player.getAvatar().clearPositions();
        Mule mule = player.getAvatar().getMule();
        if (!player.getAvatar().isInShop() && mule != null) {
            mule.runAway();
        }
        if ((assayBot = player.getAvatar().getAssayBot()) != null) {
            assayBot.stopAssay();
        }
        this.playerControls.get((Object)player).isFinished = true;
        this.model.getWampus().die();
        this.startOutroIfDone();
    }

    private void startOutroIfDone() {
        if (!this.model.getDevelopment().getDevelopmentTimer().isFinished()) {
            return;
        }
        if (this.outroBlobTimer.isStarted() && !this.outroBlobTimer.isFinished()) {
            return;
        }
        if (!this.canStartOutro()) {
            return;
        }
        if (!this.model.getMules().isEmpty()) {
            return;
        }
        this.logger.info("Starting outro");
        this.outroTimer.start(Properties.mule.developmentOutro);
    }

    protected abstract void countdownFinished();

    protected abstract boolean isDevelopmentFinished();

    protected abstract boolean canStartOutro();

    protected abstract void setNextPhase();

    public void userRemoved(User user) {
        if (user == this.focusPlayer) {
            this.wampusMenu.hide();
        }
    }

    private class ExitShopCallback
    implements CollisionDetector.CollisionCallback {
        private CollisionResolver.AvatarWallCollision wallCollision = new CollisionResolver.AvatarWallCollision();

        private ExitShopCallback() {
        }

        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            if (avatar.getMule() != null && avatar.getMule().getEquipment() == null) {
                this.wallCollision.collision(avatar, collidable2, collisionResult);
                if (AbstractDevelopmentPhase.this.focusPlayer.getAvatar() == avatar) {
                    AbstractDevelopmentPhase.this.view.setTerminalMessage("You must Outfit your M.U.L.E.", AbstractDevelopmentPhase.this.focusPlayer, 1.0f);
                }
            } else {
                PlanetMap planetMap = AbstractDevelopmentPhase.this.model.getMap();
                Shop shop = AbstractDevelopmentPhase.this.model.getShop();
                if (shop.getSouthExit() == collidable2) {
                    avatar.setPosition(planetMap.getSouthEnterance());
                } else if (shop.getNorthExit() == collidable2) {
                    avatar.setPosition(planetMap.getNorthEnterance());
                } else if (shop.getEastExit() == collidable2) {
                    avatar.setPosition(planetMap.getEastEnterance());
                } else {
                    avatar.setPosition(planetMap.getWestEnterance());
                }
                avatar.setInShop(false);
                if (avatar == AbstractDevelopmentPhase.this.focusPlayer.getAvatar()) {
                    AbstractDevelopmentPhase.this.showShop(false);
                }
            }
        }
    }

    private class ReturnToShopCallback
    implements CollisionDetector.CollisionCallback {
        private ReturnToShopCallback() {
        }

        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            avatar.setInShop(true);
            AbstractDevelopmentPhase.this.startOutroIfDone();
        }
    }

    private class EnterShopCallback
    implements CollisionDetector.CollisionCallback {
        private EnterShopCallback() {
        }

        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            float f = avatar.getPosition().x - collidable2.getPosition().x;
            float f2 = avatar.getPosition().y - collidable2.getPosition().y;
            if (Math.abs(f) > Math.abs(f2)) {
                if (f < 0.0f) {
                    avatar.setPosition(AbstractDevelopmentPhase.this.model.getShop().getWestEnterance());
                } else {
                    avatar.setPosition(AbstractDevelopmentPhase.this.model.getShop().getEastEnterance());
                }
            } else if (f2 < 0.0f) {
                avatar.setPosition(AbstractDevelopmentPhase.this.model.getShop().getNorthEnterance());
            } else {
                avatar.setPosition(AbstractDevelopmentPhase.this.model.getShop().getSouthEnterance());
            }
            avatar.setInShop(true);
            if (avatar == AbstractDevelopmentPhase.this.focusPlayer.getAvatar()) {
                AbstractDevelopmentPhase.this.showShop(true);
            }
        }
    }

    private class EnterStoreCallback
    implements CollisionDetector.CollisionCallback {
        private EnterStoreCallback() {
        }

        public void collision(Collidable collidable, Collidable collidable2, CollisionDetector.CollisionResult collisionResult) {
            Avatar avatar = (Avatar)collidable;
            boolean bl = false;
            boolean bl2 = false;
            for (Player player : AbstractDevelopmentPhase.this.model.getPlayers()) {
                if (player.getAvatar() != avatar) continue;
                bl = avatar.getMule() != null;
                bl2 = player.getAvatar().getAssayBot() != null;
            }
            Shop shop = AbstractDevelopmentPhase.this.model.getShop();
            if (bl) {
                if (collidable2 == shop.getPub() || collidable2 == shop.getAssay() || collidable2 == shop.getLand()) {
                    this.stop(avatar, collisionResult, "No M.U.L.E.s Allowed");
                }
            } else if (collidable2 == shop.getCrystiteStore() || collidable2 == shop.getSmithoreStore() || collidable2 == shop.getEnergyStore() || collidable2 == shop.getFoodStore()) {
                this.stop(avatar, collisionResult, "You need a M.U.L.E. to Enter");
            } else if (bl2 && (collidable2 == shop.getMuleStore() || collidable2 == shop.getLand() || collidable2 == shop.getPub())) {
                this.stop(avatar, collisionResult, "No Assay Bots Allowed");
            }
        }

        private void stop(Avatar avatar, CollisionDetector.CollisionResult collisionResult, String string) {
            collisionResult.overlap.scale(2.0f);
            avatar.getPosition().add(collisionResult.overlap);
            if (AbstractDevelopmentPhase.this.focusPlayer.getAvatar() == avatar) {
                AbstractDevelopmentPhase.this.view.setTerminalMessage(string, AbstractDevelopmentPhase.this.focusPlayer, 1.0f);
            }
        }
    }

    private static class PlayerControl {
        public long sentCommandFrame = -1L;
        public PlayerControllerState buttonState = new PlayerControllerState();
        public AvatarCommandStream remoteCommands = new AvatarCommandStream(this.buttonState);
        public TargetPlayerController targetController;
        public CollisionDetector.CollisionSet avatarCollision;
        public long update;
        public long finishUpdate;
        public boolean isFinished;
        public boolean isRemote;

        public PlayerControl(Player player, PlanetMap planetMap) {
            this.targetController = new TargetPlayerController(player.getAvatar(), this.buttonState);
            this.targetController.addTarget(planetMap.getShopCenter());
            this.avatarCollision = new CollisionDetector.CollisionSet();
            this.avatarCollision.add(player.getAvatar());
            this.update = 0L;
            this.finishUpdate = -1L;
            this.isFinished = false;
            this.isRemote = player.getController().isRemote();
        }
    }
}

